/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_GRADLIST_H
#define _AZPT_GRADLIST_H

#include "AXList.h"
#include "AXMem.h"

class AXImage;
class AXString;
union RGBAFIX15;

class CGradListItem:public AXListItem
{
public:
    enum
    {
        POINT_MAXCNT = 30,
        MAXSIZE = 3 + POINT_MAXCNT * 5 + POINT_MAXCNT * 4
    };

    AXMem   m_memDat;

public:
    CGradListItem *prev() { return (CGradListItem *)m_pPrev; }
    CGradListItem *next() { return (CGradListItem *)m_pNext; }

    BOOL setDefault();
    BOOL copy(CGradListItem *pItem);
    BOOL getTextFormat(AXString *pstr);
    BOOL setFromTextFormat(const AXString &strText);
    BOOL setDrawDat(AXMem *pmem,const RGBAFIX15 &colDraw,const RGBAFIX15 &colBack,BOOL bRev,BOOL bLoop);

    void drawPrev(AXImage *pimg,int x,int y,int w,int h);
};


class CGradList:public AXList
{
public:
    static CGradList *m_pSelf;

protected:
    enum{ MAXCNT = 200 };

    BOOL m_bUpdate;

public:
    CGradList();

    void updateON() { m_bUpdate = TRUE; }

    CGradListItem *addNewGrad(const AXString *pstr=NULL);
    CGradListItem *copyGrad(CGradListItem *pItem);

    BOOL setDrawDat(AXMem *pmem,int no,const RGBAFIX15 &colDraw,const RGBAFIX15 &colBack,BOOL bRev,BOOL bLoop);

    void saveFile(const AXString &filename);
    void loadFile(const AXString &filename);
};

//

void drawGradPrev(AXImage *pimg,int x,int y,int w,int h,LPBYTE pColBuf,LPBYTE pABuf,BOOL bSingle);

#define GRADLIST  (CGradList::m_pSelf)

#endif

