/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_FILTEWIDGET_H_
#define _AZPT_FILTEWIDGET_H_

#include "AXWindow.h"
#include "CXImage.h"

class CTileImage;
struct RECTANDSIZE;

//! ダイアログ内プレビュー

class CFilterPrev:public AXWindow
{
public:
    enum
    {
        NOTIFY_UP
    };

protected:
    CXImage     m_img;
    CTileImage  *m_pimgSrc;

    int         m_nCanvasW,
                m_nCanvasH;
    BOOL        m_bScroll;
    AXRectSize  m_rcsSrc,
                m_rcsFrame;
    AXSize      m_szAreaBox;

protected:
    BOOL _setDragPos(int x,int y);
    void _drawImgDrag();

public:
    CFilterPrev(AXWindow *pParent,UINT uLayoutFlags,UINT uID,DWORD dwPadding,int w,int h,CTileImage *pimgSrc);

    void getDrawRect(RECTANDSIZE *prs);
    void drawImg(CTileImage *pimg);

    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
    virtual BOOL onButtonUp(AXHD_MOUSE *phd);
    virtual BOOL onMouseMove(AXHD_MOUSE *phd);
};

//! レベル補正

class CFilterWidgetLevel:public AXWindow
{
protected:
    AXImage     m_img;
    int         m_nVal[5],
                m_fDrag;

protected:
    void _drawCursor();
    void _changePos(int x,int y);

public:
    CFilterWidgetLevel(AXWindow *pParent,UINT uID,DWORD dwPadding);

    void getVal(int *pVal);
    void drawAll(LPDWORD pHistogram);

    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
    virtual BOOL onButtonUp(AXHD_MOUSE *phd);
    virtual BOOL onMouseMove(AXHD_MOUSE *phd);
};

#endif
