/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_CONFIG_H_
#define _AZPT_CONFIG_H_

#include "AXRect.h"
#include "AXString.h"
#include "AXMem.h"

class AXConfRead;
class AXConfWrite;

class CConfig
{
public:
    enum
    {
        RECFILE_NUM     = 10,
        RECDIR_NUM      = 8,
        RECSAVEDIR_NUM  = 6,
        RECEXPDIR_NUM   = 6,
        NEWREG_NUM      = 8,
        NEWRECENT_NUM   = 6,
        GRIDLIST_NUM    = 6,
        RULEANGLE_NUM   = 6,
        RULEPOS_NUM     = 6,
        IMGBKCOL_NUM    = 5,
        HEADTAIL_NUM    = 10,
        GRADPAL_NUM     = 3,
        COLMASK_NUM     = 6,
        WATERPRESET_NUM = 5,

        WININITVAL      = -10000
    };

    enum FLAGS
    {
        FLAG_AUTOACTIVE         = 1,
        FLAG_MES_SAVE_OVERWRITE = 2,
        FLAG_MES_SAVE_APD       = 4
    };

    enum WINVIEWFLAGS
    {
        WINVIEWF_TOOL       = 0x0001,
        WINVIEWF_LAYER      = 0x0002,
        WINVIEWF_BRUSH      = 0x0004,
        WINVIEWF_OPTION     = 0x0008,
        WINVIEWF_COLOR      = 0x0010,
        WINVIEWF_PREV       = 0x0020,
        WINVIEWF_IMGVIEW    = 0x0040,
        WINVIEWF_FILTERLIST = 0x0080
    };

    enum ETCVIEWFLAGS
    {
        ETCVIEWF_BK_CHECK   = 0x0001,
        ETCVIEWF_GRID       = 0x0002,
        ETCVIEWF_GRIDSPLIT  = 0x0004,
        ETCVIEWF_TOOLBAR    = 0x0008,
        ETCVIEWF_SCROLLBAR  = 0x0010,
        ETCVIEWF_ALLHIDE    = 0x0020
    };

    enum PREVWINFLAGS
    {
        PREVF_FULLVIEW      = 1,
        PREVF_LEFT_CANVAS   = 2,
        PREVF_RIGHT_CANVAS  = 4,
        PREVF_MODE_LOUPE    = 8
    };

    enum IMGVIEWFLAGS
    {
        IMGVF_FITSIZE   = 1,
        IMGVF_FULLVIEW  = 2
    };

    enum ETCFLAGS
    {
        ETCF_FILTERDLG_PREV     = 1,
        ETCF_SCALEROTDLG_PREV   = 2
    };
    
    enum TOOLBOXTYPE
    {
        TOOLBOXTYPE_UTILITY,
        TOOLBOXTYPE_NORMAL
    };

public:
    AXRectSize  rcsMainWin,
                rcsLayerWin,
                rcsBrushWin,
                rcsOptWin,
                rcsColWin,
                rcsPrevWin,
                rcsImgViewWin,
                rcsFilterListWin,
                rcsTextWin;
    AXPoint     ptToolWin;
    AXSize      szSelImgDlg;
    BOOL        bMaximized;

    UINT        uFlags,
                uEtcFlags,
                uWinViewFlags,
                uEtcViewFlags,
                uWinViewBkFlags,
                uPrevWinFlags,
                uImgVFlags,
                uBrushValExpand,
                uUndoMaxBuf,
                uJPEGSave;  //[0-6bit]品質 [7-16bit] サンプリング比

    int         nInitImgW,
                nInitImgH,
                nScaleUpStep,
                nScaleDownStep,
                nAngleStep,
                nPrevWinScale,      //1.0=10
                nPrevWinLoupeScale,
                nUndoCnt,
                nGridW,
                nGridH,
                nGridSplitX,
                nGridSplitY,
                n1pxGridScale,
                nColHLSVal[4],  //[0]タイプ [1-3]各タイプの値
                nBrushWinH[2];

    BYTE        btColWinTab,
                btColBarType,   //バータイプ [0]RGB [1]HSV
                btColMaskType,  //[0]OFF [1]ON [2]REV
                btColPalSel,
                btOptWinTab,
                btImgBkColSel,
                btOptHeadTailType,
                btScaleCanvType,
                btPNGLevel,
                btExportType,
                btToolboxType;

    DWORD       dwDrawCol,
                dwBackCol,
                dwCanvasBkCol,
                dwImgBkCol,
                dwImgBkColList[IMGBKCOL_NUM],
                dwBkCheckCol[2],
                dwGridCol,
                dwGridSplitCol,
                dwColMask[COLMASK_NUM],         //!< 色マスク
                dwGradPalCol[GRADPAL_NUM * 2],  //!< グラデーションパレット色
                dwNewRegSize[NEWREG_NUM],       //!< 新規作成サイズ・登録リスト（上位bit:幅、下位bit:高さ）
                dwNewRecentSize[NEWRECENT_NUM], //!< 新規作成サイズ・履歴（px。上位bit:幅、下位bit:高さ）
                dwGridList[GRIDLIST_NUM],       //!< グリッド登録リスト（上位bit:幅、下位bit:高さ）
                dwWaterPreset[WATERPRESET_NUM]; //!< 水彩プリセット(10bit x 3)

    WORD        wNewRegDPI[NEWREG_NUM],         //!< 新規作成・登録リストのDPI
                wNewRecentDPI[NEWRECENT_NUM],   //!< 新規作成・履歴のDPI
                wRuleAngle[RULEANGLE_NUM],      //!< 定規角度・登録
                wHeadTailList[HEADTAIL_NUM],    //!< 入り抜きリスト
                wPalOneSize;                    //!< パレット、ひとつの表示サイズ (上位8bit:幅、下位8bit:高さ)

    short       sRulePos[RULEPOS_NUM * 2],      //!< 定規中心位置・登録
                sDragBrushSizeW,
                sFontSizeDef,
                sFontSizeSubWin;

    AXString    strOpenDir,
                strSaveDir,
                strExportDir,
                strImgViewDir,
                strLayerSaveDir,
                strRecFile[RECFILE_NUM],
                strRecOpenDir[RECDIR_NUM],
                strRecSaveDir[RECSAVEDIR_NUM],
                strRecExpDir[RECEXPDIR_NUM],
                strUserTexDir,
                strUserBrushDir,
                strOptTexPath,
                strFontWin;

    AXMem       memDrawCursor;

public:
    CConfig();

    BOOL isToolWin() { return uWinViewFlags & WINVIEWF_TOOL; }
    BOOL isLayerWin() { return uWinViewFlags & WINVIEWF_LAYER; }
    BOOL isBrushWin() { return uWinViewFlags & WINVIEWF_BRUSH; }
    BOOL isOptionWin() { return uWinViewFlags & WINVIEWF_OPTION; }
    BOOL isColorWin() { return uWinViewFlags & WINVIEWF_COLOR; }
    BOOL isPrevWin() { return uWinViewFlags & WINVIEWF_PREV; }
    BOOL isImgViewWin() { return uWinViewFlags & WINVIEWF_IMGVIEW; }
    BOOL isFilterWin() { return uWinViewFlags & WINVIEWF_FILTERLIST; }

    BOOL isBkCheck() const { return uEtcViewFlags & ETCVIEWF_BK_CHECK; }
    BOOL isGrid() const { return uEtcViewFlags & ETCVIEWF_GRID; }
    BOOL isGridSplit() const { return uEtcViewFlags & ETCVIEWF_GRIDSPLIT; }
    BOOL isToolBar() const { return uEtcViewFlags & ETCVIEWF_TOOLBAR; }
    BOOL isScrollBar() const { return uEtcViewFlags & ETCVIEWF_SCROLLBAR; }

    BOOL isPrevWinLoupe() { return uPrevWinFlags & PREVF_MODE_LOUPE; }
    BOOL isPrevWinFullView() { return uPrevWinFlags & PREVF_FULLVIEW; }

    //

    void addNewRecent(int w,int h,int dpi);
    void resetWaterPreset();

    void load(AXConfRead *pcf);
    void save(AXConfWrite *pcf);
};

#endif
