/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_COLORWIN_H_
#define _AZPT_COLORWIN_H_

#include "AXTopWindow.h"

class CColWin_tabbase;
class CColSub_drawcol;
class CColSub_colmasktype;
class CColSub_colmask;
class AXTab;

class CColorWin:public AXTopWindow
{
public:
    static CColorWin *m_pSelf;

protected:
    CColWin_tabbase *m_pwinTab;
    AXTab           *m_ptab;

    CColSub_drawcol     *m_pDrawCol;
    CColSub_colmasktype *m_pColMaskType;
    CColSub_colmask     *m_pColMask;

    int     m_nPalScrPos[4];

    void _setTabWidget(int no,BOOL bLayout=TRUE);

public:
    CColorWin(AXWindow *pOwner,UINT addstyle);

    void setPalScrPos(int no,int pos) { m_nPalScrPos[no] = pos; }
    int getPalScrPos(int no) const { return m_nPalScrPos[no]; }

    void showToggle();
    void setDrawColor();
    void updateMaskColor();
    void updateDrawColor();

    virtual BOOL onClose();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

#define COLORWIN  (CColorWin::m_pSelf)

#endif
