/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    [CBrushWin_value.cpp]
*/


//============================
// アイテムID

enum
{
    WID_CK_MANUALSAVE = 100,
    WID_BT_SAVE,
    WID_BAR_RADIUS,
    WID_BT_RADIUS_MENU,
    WID_BAR_OPACITY,
    WID_CB_PIXTYPE,
    WID_CB_HOSEITYPE,
    WID_CB_HOSEISTR,
    WID_BAR_MINSIZE,
    WID_BAR_MINOPA,
    WID_BAR_INTERVAL,
    WID_BAR_RANDSIZE,
    WID_BAR_RANDPOS,
    WID_CK_WATERON,
    WID_BT_WATERMENU,
    WID_BAR_WATER1,
    WID_BAR_WATER2,
    WID_BAR_WATER3,
    WID_SEL_BRUSHIMG,
    WID_BAR_BRUSHHARD,
    WID_BAR_BRUSHROUGH,
    WID_CB_BRUSHROT,
    WID_BAR_BRUSHROTANGLE,
    WID_BAR_BRUSHROTRAND,
    WID_PRESS_SIZE,
    WID_PRESS_OPACITY,
    WID_EDIT_PRESSSIZE,
    WID_EDIT_PRESSOPACITY,
    WID_SEL_TEXTUREIMG,
    WID_CK_ANTIALIAS,
    WID_CK_CURVE,

    WID_BT_WATER_PRESET = 200,

    WID_EXP_MAIN = 300,
    WID_EXP_MININTER,
    WID_EXP_RANDOM,
    WID_EXP_WATER,
    WID_EXP_BRUSHSTYLE,
    WID_EXP_PRESS,
    WID_EXP_ETC,
};


//============================
// 文字列ID

enum
{
    STRID_MANUALSAVE = 0,
    STRID_SAVE,
    STRID_RADIUS,
    STRID_OPACITY,
    STRID_PIXTYPE,
    STRID_HOSEI,
    STRID_MINSIZE,
    STRID_MINOPACITY,
    STRID_INTERVAL,
    STRID_RANDSIZE,
    STRID_RANDPOS,
    STRID_WATERON,
    STRID_WATERPRESET,
    STRID_WATER1,
    STRID_WATER2,
    STRID_WATER3,
    STRID_BRUSHHARD,
    STRID_BRUSHROUGH,
    STRID_BRUSHROT,
    STRID_BRUSHROTANGLE,
    STRID_BRUSHROTRAND,
    STRID_PRESSSIZE,
    STRID_PRESSOPACITY,
    STRID_TEXTURE,
    STRID_ANTIALIAS,
    STRID_CURVE,

    STRID_EXPANDER_MAIN = 100,
    STRID_EXPANDER_MININTER,
    STRID_EXPANDER_RANDOM,
    STRID_EXPANDER_WATER,
    STRID_EXPANDER_BRUSHSTYLE,
    STRID_EXPANDER_PRESS,
    STRID_EXPANDER_ETC,

    STRID_HOSEITYPE_TOP = 1000,
    STRID_BRUSHROT_TYPE_TOP = 1100,

    STRID_WATERMENU_REGIST = 10000,
    STRID_WATERMENU_RESET,
};


//============================
// ウィンドウ

//! 項目ウィンドウ

class CBrushValueBase:public AXWindow
{
protected:
    AXLabel         *m_pwidName;
    AXCheckButton   *m_pckManualSave,
                    *m_pckWaterOn,
                    *m_pckEtc[2];

    CValBar     *m_pbarRadius,
                *m_pbarOpacity,
                *m_pbarMinSize,
                *m_pbarMinOpa,
                *m_pbarInterval,
                *m_pbarRandSize,
                *m_pbarRandPos,
                *m_pbarWater[3],
                *m_pbarBrushHard,
                *m_pbarBrushRough,
                *m_pbarBrushRotAngle,
                *m_pbarBrushRotRand;
    CSelImgBar  *m_pselBrushImg,
                *m_pselTexture;
    CPressCurve *m_pPressCurve[2];
    AXLineEdit  *m_peditPress[2];
    AXComboBox  *m_pcbPix,
                *m_pcbHoseiType,
                *m_pcbHoseiStr,
                *m_pcbBrushRot;

protected:
    void _createMain();
    void _createMinInterval();
    void _createRandom();
    void _createWater();
    void _createBrushStyle();
    void _createPress();
    void _createEtc();

    void _enableFromPixType(int type);
    void _enableFromBrushImg(BOOL bNormal);

    void _runSizeMenu();
    void _runWaterMenu();

public:
    CBrushValueBase(AXWindow *pParent);

    void setValue(CBrushItem *p);
    void setValRadius();

    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//! CBrushValueBase の表示部分

class CBrushValueArea:public AXWindow
{
protected:
    AXScrollBar     *m_pScr;
    CBrushValueBase *m_pBase;

public:
    CBrushValueArea(AXWindow *pParent);

    CBrushValueBase *getBaseWidget() { return m_pBase; }

    void setScroll(AXScrollBar *p) { m_pScr = p; }
    void setScrollInfo();

    virtual BOOL onSize();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};
