/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_BRUSHWIN_H_
#define _AZPT_BRUSHWIN_H_

#include "AXTopWindow.h"

class CBrushWin_sizeList;
class CBrushWin_brushList;
class CBrushWin_value;

class CBrushWin:public AXTopWindow
{
public:
    static CBrushWin   *m_pSelf;

protected:
    CBrushWin_sizeList  *m_pwidSize;
    CBrushWin_brushList *m_pwidList;
    CBrushWin_value     *m_pwidValue;

public:
    CBrushWin(AXWindow *pOwner,UINT addstyle);

    void showToggle();
    void getWinH();
    void setBrushSize(int size);
    void moveSelBrush(int dir);
    void toggleRegBrush();

    virtual BOOL onClose();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

#define BRUSHWIN  (CBrushWin::m_pSelf)

#endif

