/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_BRUSHSIZELIST_H_
#define _AZPT_BRUSHSIZELIST_H_

#include "AXMem.h"

class AXString;

class CBrushSizeList
{
public:
    static CBrushSizeList *m_pSelf;

protected:
    AXMemAuto   m_memBuf;
    int         m_nCnt;

    enum
    {
        MAXCNT  = 200,
        MINVAL  = 3,
        MAXVAL  = 6000
    };

public:
    CBrushSizeList();

    int getCnt() { return m_nCnt; }
    LPWORD getBuf() { return (LPWORD)m_memBuf; }
    LPWORD getBufPt(int no) { return (LPWORD)m_memBuf + no; }
    int getVal(int no) { return *((LPWORD)m_memBuf + no); }

    void alloc(int cnt);
    void addSize(int size);
    void addFromText(AXString *pstr);
    void del(int no);
};

#define BRUSHSIZELIST  (CBrushSizeList::m_pSelf)

#endif
