/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_BRUSHLIST_H_
#define _AZPT_BRUSHLIST_H_

#include "AXList.h"
#include "struct.h"

class CBrushItem;
class AXString;

//

class CBrushGroupItem:public AXListItem
{
public:
    AXList  m_list;
    BOOL    m_bExpand;

    enum{ MAXITEMCNT = 500 };

public:
    CBrushGroupItem();

    CBrushGroupItem *prev() { return (CBrushGroupItem *)m_pPrev; }
    CBrushGroupItem *next() { return (CBrushGroupItem *)m_pNext; }

    int getItemCnt() { return m_list.getCnt(); }
    CBrushItem *getTopItem() { return (CBrushItem *)m_list.getTop(); }
    CBrushItem *getNoItem(int no) { return (CBrushItem *)m_list.getItem(no); }

    int getViewAreaHCnt(int xcnt);
    CBrushItem *addNew();
};

//

class CBrushList:public AXList
{
public:
    static CBrushList *m_pSelf;

protected:
    enum { GROUP_MAXCNT = 100 };

    CBrushItem  *m_pEditItem,
                *m_pSelItem,
                *m_pRegItem,
                *m_pToggleItem; //登録ブラシ/直前のブラシ切替時の直前ブラシ

    BRUSHDRAWPARAM  m_predit,
                    m_prreg;

protected:
    void _getRegImage();
    void _updateSelItem();

public:
    CBrushList();
    virtual ~CBrushList();

    CBrushGroupItem *getTopItem() { return (CBrushGroupItem *)m_pTop; }
    int getGroupCnt() { return getCnt(); }
    CBrushItem *getSelItem() { return m_pSelItem; }
    CBrushItem *getEditItem() { return m_pEditItem; }

    BOOL isItemRegBrush(CBrushItem *p) { return (p == m_pRegItem); }
    CBrushItem *getCopyBrush(CBrushItem *p) { return (p == m_pSelItem)? m_pEditItem: p; }
    CBrushItem *getDrawBrush(BOOL bReg) { return (bReg && m_pRegItem && m_pSelItem != m_pRegItem)? m_pRegItem: m_pEditItem; }
    BRUSHDRAWPARAM *getDrawParam(BOOL bReg) { return (bReg && m_pRegItem && m_pSelItem != m_pRegItem)? &m_prreg: &m_predit; }

    CBrushGroupItem *addNewGroup();
    BOOL deleteGroup(CBrushGroupItem *pGroup);
    void moveGroup(CBrushGroupItem *pGroup,BOOL bUp);

    CBrushItem *addNewBrush(CBrushGroupItem *pGroup);
    BOOL deleteBrush(CBrushGroupItem *pGroup,CBrushItem *pItem);
    void moveBrush(CBrushGroupItem *pGroupSrc,CBrushItem *pItemSrc,CBrushGroupItem *pGroupDst,CBrushItem *pItemDst);
    BOOL pasteBrush(CBrushGroupItem *pGroup,CBrushItem *pItem,const AXString &str);

    BOOL changeSelItem(CBrushItem *p);
    void changeRegItem(CBrushItem *p);
    void manualSave();
    BOOL toggleRegItem();

    void setDrawParam(BOOL bReg);

    BOOL isSelLinkSave();
    void changeValManualSave();
    void changeValRadius(int val,BOOL bDirect=FALSE);
    void changeValRadiusCtlMax(int radius,int max);
    void changeValOpacity(int val);
    void changeValPixType(int type);
    void changeValHoseiType(int type);
    void changeValHoseiStr(int val);
    void changeValMinSize(int val);
    void changeValMinOpacity(int val);
    void changeValInterval(int val);
    void changeValRandSize(int val);
    void changeValRandPos(int val);
    void changeValWaterOn();
    void changeValWater1(int val);
    void changeValWater2(int val);
    void changeValWater3(int val);
    void changeValBrushHardness(int val);
    void changeValBrushRoughness(int val);
    void changeValBrushRotType(int type);
    void changeValBrushRotAngle(int val);
    void changeValBrushRotRandom(int val);
    void changeValPressSize(int val);
    void changeValPressOpacity(int val);
    void changeValAntiAlias();
    void changeValCurve();
    BOOL changeValBrushImg(const AXString &str);
    void changeValTexture(const AXString &str);

    void saveFile(const AXString &filename);
    void loadFile(const AXString &filename);
    void setDefault();
};

#define BRUSHLIST   (CBrushList::m_pSelf)

#endif
