/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_BRUSHITEMIMGLIST_H_
#define _AZPT_BRUSHITEMIMGLIST_H_

#include "AXList.h"
#include "AXString.h"

class CImage8;


class CBrushImgItem:public AXListItem
{
public:
    AXString    m_strPath;
    CImage8     *m_pimg;

public:
    CBrushImgItem();
    virtual ~CBrushImgItem();

    CBrushImgItem *next() { return (CBrushImgItem *)m_pNext; }
};

//

class CBrushItemImgList
{
public:
    enum
    {
        TYPE_BRUSH   = 0,
        TYPE_TEXTURE = 1
    };

protected:
    AXList  m_list[2];

protected:
    CBrushImgItem *_searchImage(int type,const AXString &strPath);
    CImage8 *_loadImage(int type,const AXString &strPath);

public:
    CImage8 *getImage(int type,const AXString &strPath);
};

#endif
