/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    フィルタ描画関数 - 効果
*/

#include <math.h>

#include "CTileImage.h"

#include "AXRand.h"
#include "AXMem.h"

#include "filterdraw.h"
#include "filterdrawfunc.h"


namespace filterdraw
{

//! グロー

BOOL eff_glow(FILTERDRAW &info)
{
    CTileImage *pimgTmp,*pimgSrc,*pimgDst;
    int ix,iy,i,c,n,amount;
    RGBAFIX15 col,col2;
    void (CTileImage::*funcPix)(int,int,const RGBAFIX15&) = CTileImage::m_pinfo->funcDrawPixel;

    pimgTmp = allocTmpImage(info, info.rs);
    if(!pimgTmp) return FALSE;

    pimgSrc = info.pimgSrc;
    pimgDst = info.pimgDst;

    //---------- レベル補正 入力最小 (src -> tmp)

    n = 0x8000 - (info.valbar[0] << 15) / 100;

    for(iy = info.rs.y1; iy <= info.rs.y2; iy++)
    {
        for(ix = info.rs.x1; ix <= info.rs.x2; ix++)
        {
            pimgSrc->getPixel(&col, ix, iy);
            if(!col.a) continue;

            for(i = 0; i < 3; i++)
            {
                c = col.c[i];
                if(c < n) c = n;

                col.c[i] = ((c - n) << 15) / (0x8000 - n);
            }

            pimgTmp->setPixel_create(ix, iy, col);
        }

        info.progIncSub();
    }

    //------- ガウスぼかし (tmp -> tmp)

    if(!tmpGaussBlur(info, pimgTmp, pimgTmp, info.valbar[1], &CTileImage::setPixel_create))
        return FALSE;

    //------ スクリーン合成

    amount = (info.valbar[2] << 8) / 100;

    info.progBeginOneStep(50, info.rs.h);

    for(iy = info.rs.y1; iy <= info.rs.y2; iy++)
    {
        for(ix = info.rs.x1; ix <= info.rs.x2; ix++)
        {
            pimgSrc->getPixel(&col, ix, iy);
            if(!col.a) continue;

            pimgTmp->getPixel(&col2, ix, iy);

            //

            n = col.a * amount >> 8;

            for(i = 0; i < 3; i++)
            {
                c = col.c[i] + col2.c[i] - (col.c[i] * col2.c[i] >> 15);

                col.c[i] = ((c - col.c[i]) * n >> 15) + col.c[i];
            }

            (pimgDst->*funcPix)(ix, iy, col);
        }

        info.progIncSub();
    }

    //

    delete pimgTmp;

    return TRUE;
}

//! RGBずらし

BOOL eff_rgbshift_func(FILTERDRAW &info,RGBAFIX15 *p,int x,int y)
{
    RGBAFIX15 col;

    if(!p->a) return FALSE;

    //R

    info.pimgSrc->getPixel(&col, x + info.ntmp[0], y + info.ntmp[1], info.bClipping);
    p->r = col.r;

    //B

    info.pimgSrc->getPixel(&col, x + info.ntmp[2], y + info.ntmp[3], info.bClipping);
    p->b = col.b;

    return TRUE;
}

BOOL eff_rgbshift(FILTERDRAW &info)
{
    int n;

    for(n = 0; n < 4; n++)
        info.ntmp[n] = 0;

    n = info.valbar[0];

    //0:r-x 1:r-y 2:b-x 3:b-y

    if(info.valcombo[0] == 0)
    {
        info.ntmp[0] = info.ntmp[1] = info.ntmp[3] = n;
        info.ntmp[2] = -n;
    }
    else if(info.valcombo[0] == 1)
        info.ntmp[0] = n, info.ntmp[2] = -n;
    else
        info.ntmp[1] = n, info.ntmp[3] = -n;

    //

    return common1(info, eff_rgbshift_func);
}

//! 油絵風

BOOL eff_oilpaint(FILTERDRAW &info)
{
    int ix,iy,jx,jy,i,j,min[3],max[3],vmin;
    AXPoint posSt[4],posEd[4];
    double dcol[4],weight;
    CTileImage *pimgSrc,*pimgDst;
    RGBAFIX15 col,colMin;
    void (CTileImage::*funcPix)(int,int,const RGBAFIX15&) = CTileImage::m_pinfo->funcDrawPixel;

    //

    AXMemZero(posSt, sizeof(AXPoint) * 4);
    AXMemZero(posEd, sizeof(AXPoint) * 4);

    ix = info.valbar[0];

    posSt[0].x = posSt[0].y = posSt[1].y = posSt[3].x = -ix;
    posEd[1].x = posEd[2].x = posEd[2].y = posEd[3].y = ix;

    weight = 1.0 / ((ix + 1) * (ix + 1));

    //

    pimgSrc = info.pimgSrc;
    pimgDst = info.pimgDst;

    for(iy = info.rs.y1; iy <= info.rs.y2; iy++)
    {
        for(ix = info.rs.x1; ix <= info.rs.x2; ix++)
        {
            vmin = 0;

            for(i = 0; i < 4; i++)
            {
                dcol[0] = dcol[1] = dcol[2] = dcol[3] = 0;

                min[0] = min[1] = min[2] = 0x8000;
                max[0] = max[1] = max[2] = 0;

                for(jy = posSt[i].y; jy <= posEd[i].y; jy++)
                {
                    for(jx = posSt[i].x; jx <= posEd[i].x; jx++)
                    {
                        pimgSrc->getPixel(&col, ix + jx, iy + jy, info.bClipping);

                        addAdvColor(dcol, col);

                        for(j = 0; j < 3; j++)
                        {
                            if(col.c[j] < min[j]) min[j] = col.c[j];
                            if(col.c[j] > max[j]) max[j] = col.c[j];
                        }
                    }
                }

                //

                jx = max[0] - min[0] + max[1] - min[1] + max[2] - min[2];

                if(i == 0 || jx < vmin)
                {
                    vmin = jx;
                    getAdvColor(&colMin, dcol, weight);
                }
            }

            //

            (pimgDst->*funcPix)(ix, iy, colMin);
        }

        info.progIncSub();
    }

    return TRUE;
}

//! エンボス

BOOL eff_emboss(FILTERDRAW &info)
{
    FILTER3X3DAT dat;
    int i;

    for(i = 0; i < 9; i++)
        dat.mul[i] = 0;

    i = info.valbar[0];
    if(info.valcheck[0]) i = -i;    //反転

    if(info.valcombo[0] == 0)
        //斜め
        dat.mul[0] = dat.mul[1] = -i, dat.mul[7] = dat.mul[8] = i;
    else if(info.valcombo[0] == 1)
        //左右
        dat.mul[3] = -i, dat.mul[5] = i;
    else
        //上下
        dat.mul[1] = -i, dat.mul[7] = i;

    if(info.valcheck[1])
        dat.add = 0x4000;
    else
    {
        dat.mul[4] = 1;
        dat.add    = 0;
    }

    dat.divmul = 1;

    return filter3x3(info, dat, info.valcheck[1]);
}

//! ノイズ

BOOL eff_noise_func(FILTERDRAW &info,RGBAFIX15 *p,int x,int y)
{
    int i,rnd,n;

    if(!p->a) return FALSE;

    for(i = 0; i < 3; i++)
    {
        if(info.ntmp[1] || i == 0)
            rnd = CTileImage::m_prand->getRange(-info.ntmp[0], info.ntmp[0]);

        n = p->c[i] + rnd;
        if(n < 0) n = 0; else if(n > 0x8000) n = 0x8000;

        p->c[i] = n;
    }

    return TRUE;
}

BOOL eff_noise(FILTERDRAW &info)
{
    info.ntmp[0] = info.valbar[0] << 7;
    info.ntmp[1] = !info.valcheck[0];

    return common1(info, eff_noise_func);
}

//! 拡散

BOOL eff_diffusion_func(FILTERDRAW &info,RGBAFIX15 *p,int x,int y)
{
    x += CTileImage::m_prand->getRange(-info.valbar[0], info.valbar[0]);
    y += CTileImage::m_prand->getRange(-info.valbar[0], info.valbar[0]);

    info.pimgSrc->getPixel(p, x, y, info.bClipping);

    return TRUE;
}

BOOL eff_diffusion(FILTERDRAW &info)
{
    return common1(info, eff_diffusion_func);
}

//! ひっかき

BOOL eff_scratch(FILTERDRAW &info)
{
    int ix,iy,x,y,yrange,lw,lh;
    double r;
    RGBAFIX15 col;

    //プレビュー時はコピー

    if(info.isPrev()) copyRect(info);

    //

    yrange = info.valbar[0] << 1;

    r  = -info.valbar[1] * M_PI / 180;
    lw = (int)(info.valbar[0] * ::cos(r));
    lh = (int)(info.valbar[0] * ::sin(r));

    for(iy = info.rs.y1; iy <= info.rs.y2; iy++)
    {
        for(ix = info.rs.x1; ix <= info.rs.x2; ix++)
        {
            x = CTileImage::m_prand->getRange(info.rs.x1, info.rs.x2);
            y = iy + CTileImage::m_prand->getRange(-yrange, yrange);

            info.pimgSrc->getPixel(&col, x, y, info.bClipping);

            x -= lw >> 1;
            y -= lh >> 1;

            info.pimgDst->drawLineB(x, y, x + lw, y + lh, col, FALSE);
        }

        info.progIncSub();
    }

    return TRUE;
}

//! メディアン

BOOL eff_median(FILTERDRAW &info)
{
    int ix,iy,i,j,radius,cnt,pos,no;
    RGBAFIX15 col,*pcol;
    WORD v[7*7];
    AXMem memCol;
    CTileImage *pimgSrc,*pimgDst;
    void (CTileImage::*funcPix)(int,int,const RGBAFIX15&) = CTileImage::m_pinfo->funcDrawPixel;

    radius = info.valbar[0];
    cnt    = (radius * 2 + 1) * (radius * 2 + 1);

    if(!memCol.alloc(sizeof(RGBAFIX15) * cnt)) return FALSE;
    pcol = (RGBAFIX15 *)memCol.getBuf();

    //適用位置

    i = info.valcombo[0];

    if(i == 0) pos = 0;
    else if(i == 1) pos = cnt >> 1;
    else pos = cnt - 1;

    //

    pimgSrc = info.pimgSrc;
    pimgDst = info.pimgDst;

    for(iy = info.rs.y1; iy <= info.rs.y2; iy++)
    {
        for(ix = info.rs.x1; ix <= info.rs.x2; ix++)
        {
            //周囲の色と輝度

            for(i = -radius, no = 0; i <= radius; i++)
            {
                for(j = -radius; j <= radius; j++, no++)
                {
                    pimgSrc->getPixel(&col, ix + j, iy + i, info.bClipping);

                    pcol[no] = col;
                    v[no]    = _GETV(col.r, col.g, col.b);
                }
            }

            //輝度の小さい順に並べ替え

            for(i = 0; i < cnt - 1; i++)
            {
                no = i;

                for(j = i + 1; j < cnt; j++)
                {
                    if(v[j] < v[no]) no = j;
                }

                if(no != i)
                {
                    j = v[i], v[i] = v[no], v[no] = j;
                    col = pcol[i], pcol[i] = pcol[no], pcol[no] = col;
                }
            }

            //

            (pimgDst->*funcPix)(ix, iy, pcol[pos]);
        }

        info.progIncSub();
    }

    return TRUE;
}

//! ぶれ

BOOL eff_blurring(FILTERDRAW &info)
{
    int ix,iy,i;
    AXPoint pt[4];
    double dcol[4];
    RGBAFIX15 col;
    CTileImage *pimgSrc,*pimgDst;
    void (CTileImage::*funcPix)(int,int,const RGBAFIX15&) = CTileImage::m_pinfo->funcDrawPixel;

    i = info.valbar[0];

    pt[0].x = pt[0].y = -i;
    pt[1].x = -i, pt[1].y =  i;
    pt[2].x =  i, pt[2].y = -i;
    pt[3].x =  i, pt[3].y =  i;

    //

    pimgSrc = info.pimgSrc;
    pimgDst = info.pimgDst;

    for(iy = info.rs.y1; iy <= info.rs.y2; iy++)
    {
        for(ix = info.rs.x1; ix <= info.rs.x2; ix++)
        {
            dcol[0] = dcol[1] = dcol[2] = dcol[3] = 0;

            for(i = 0; i < 4; i++)
                addAdvColor(dcol, pimgSrc, ix + pt[i].x, iy + pt[i].y, info.bClipping);

            getAdvColor(&col, dcol, 1.0 / 4);

            (pimgDst->*funcPix)(ix, iy, col);
        }

        info.progIncSub();
    }

    return TRUE;
}

};
