/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    フィルタ描画関数 - アンチエイリアシング
*/
/*
    TANE 氏のソースを参考にしています。

    http://www5.ocn.ne.jp/~tane/

    layman-0.62.tar.gz : lervise.c
*/


#include "CTileImage.h"

#include "filterdraw.h"
#include "filterdrawfunc.h"


namespace filterdraw
{

// 色の比較

BOOL _aa_comp(const RGBAFIX15 &c1,const RGBAFIX15 &c2)
{
    return ((!c1.a && !c2.a) ||
        (c1.a && c2.a && (c1.r >> 9) == (c2.r >> 9) && (c1.g >> 9) == (c2.g >> 9) && (c1.b >> 9) == (c2.b >> 9)));
}

BOOL _aa_comp(int x1,int y1,int x2,int y2,FILTERDRAW &info)
{
    RGBAFIX15 c1,c2;

    info.pimgSrc->getPixel(&c1, x1, y1);
    info.pimgSrc->getPixel(&c2, x2, y2);

    return ((!c1.a && !c2.a) ||
        (c1.a && c2.a && (c1.r >> 9) == (c2.r >> 9) && (c1.g >> 9) == (c2.g >> 9) && (c1.b >> 9) == (c2.b >> 9)));
}

// 点の描画

void _aa_pixel(int sx,int sy,int dx,int dy,int opacity,FILTERDRAW &info)
{
    RGBAFIX15 cols,cold;
    double sa,da,na;
    int i;

    if(opacity <= 0) return;

    info.pimgSrc->getPixel(&cols, sx, sy);
    info.pimgSrc->getPixel(&cold, dx, dy);

    if(_aa_comp(cols, cold)) return;

    //合成

    sa = (double)(cols.a * opacity >> 15) / 0x8000;
    da = (double)cold.a / 0x8000;
    na = sa + da - sa * da;

    cold.a = (WORD)(na * 0x8000 + 0.5);

    if(!cold.a)
        cold.r = cold.g = cold.b = 0;
    else
    {
        da = da * (1 - sa);
        na = 1 / na;

        for(i = 0; i < 3; i++)
            cold.c[i] = (WORD)((cols.c[i] * sa + cold.c[i] * da) * na + 0.5);
    }

    (info.pimgDst->*(CTileImage::m_pinfo->funcDrawPixel))(dx, dy, cold);
}

// 描画

void _aa_draw(int x,int y,const AXRect &rc,BOOL bRight,FILTERDRAW &info)
{
    int cnt,a,i,sx,sy,dx,dy;

    //上

    sx = dx = x;
    if(bRight) sx++; else dx++;

    if(!rc.top)
        _aa_pixel(sx, y, dx, y, info.ntmp[0] >> 1, info);
    else
    {
        cnt = (rc.top + 1) >> 1;
        if(y - cnt + 1 < info.rs.y1) cnt = y - info.rs.y1 + 1;

        a = info.ntmp[0]; if(cnt < 4) a -= 2048;

        for(i = 0; i <= cnt; i++)
            _aa_pixel(sx, y, dx, y - i, a - (a * i / cnt), info);
    }

    //下

    sx = dx = x;
    sy = dy = y + 1;
    if(bRight) dx++; else sx++;

    if(!rc.bottom)
        _aa_pixel(sx, sy, dx, dy, info.ntmp[0] >> 1, info);
    else
    {
        cnt = (rc.bottom + 1) >> 1;
        if(y + cnt > info.rs.y2) cnt = info.rs.y2 - y;

        a = info.ntmp[0]; if(cnt < 4) a -= 2048;

        for(i = 0; i <= cnt; i++)
            _aa_pixel(sx, sy, dx, dy + i, a - (a * i / cnt), info);
    }

    //左

    sy = dy = y;
    if(bRight) sy++; else dy++;

    if(rc.left)
    {
        cnt = (rc.left + 1) >> 1;
        if(x - cnt + 1 < info.rs.x1) cnt = x - info.rs.x1 + 1;

        a = info.ntmp[0]; if(cnt < 4) a -= 2048;

        for(i = 0; i <= cnt; i++)
            _aa_pixel(x, sy, x - i, dy, a - (a * i / cnt), info);
    }

    //右

    sx = dx = x + 1;
    sy = dy = y;
    if(bRight) dy++; else sy++;

    if(rc.right)
    {
        cnt = (rc.right + 1) >> 1;
        if(x + cnt > info.rs.x2) cnt = info.rs.x2 - x;

        a = info.ntmp[0]; if(cnt < 4) a -= 2048;

        for(i = 0; i <= cnt; i++)
            _aa_pixel(sx, sy, dx + i, dy, a - (a * i / cnt), info);
    }
}

// 判定

void _aa_func(int x,int y,BOOL bRight,FILTERDRAW &info)
{
    int i,x1,y1,x2,y2;
    RGBAFIX15 col,col2,col3;
    AXRect rc;
    CTileImage *pimg = info.pimgSrc;

    rc.left = rc.top = rc.right = rc.bottom = 0;

    //上に伸びているか

    x1 = x2 = x;
    if(bRight) x1++; else x2++;

    if(!_aa_comp(x1, y, x2, y, info))
    {
        pimg->getPixel(&col, x1, y);

        for(i = y - 1; i >= info.rs.y1; i--)
        {
            pimg->getPixel(&col2, x1, i);
            pimg->getPixel(&col3, x2, i);

            if(_aa_comp(col, col2) && !_aa_comp(col, col3)) rc.top++; else break;
        }
    }

    //下に伸びているか

    x1 = x2 = x;
    y1 = y + 1;
    if(bRight) x2++; else x1++;

    if(!_aa_comp(x1, y1, x2, y1, info))
    {
        pimg->getPixel(&col, x1, y1);

        for(i = y + 2; i <= info.rs.y2; i++)
        {
            pimg->getPixel(&col2, x1, i);
            pimg->getPixel(&col3, x2, i);

            if(_aa_comp(col, col2) && !_aa_comp(col, col3)) rc.bottom++; else break;
        }
    }

    //左に伸びているか

    y1 = y2 = y;
    if(bRight) y1++; else y2++;

    if(!_aa_comp(x, y1, x, y2, info))
    {
        pimg->getPixel(&col, x, y1);

        for(i = x - 1; i >= info.rs.x1; i--)
        {
            pimg->getPixel(&col2, i, y1);
            pimg->getPixel(&col3, i, y2);

            if(_aa_comp(col, col2) && !_aa_comp(col, col3)) rc.left++; else break;
        }
    }

    //右に伸びているか

    x1 = x + 1;
    y1 = y2 = y;
    if(bRight) y2++; else y1++;

    if(!_aa_comp(x1, y1, x1, y2, info))
    {
        pimg->getPixel(&col, x1, y1);

        for(i = x + 2; i <= info.rs.x2; i++)
        {
            pimg->getPixel(&col2, i, y1);
            pimg->getPixel(&col3, i, y2);

            if(_aa_comp(col, col2) && !_aa_comp(col, col3)) rc.right++; else break;
        }
    }

    //

    _aa_draw(x, y, rc, bRight, info);
}

//! アンチエイリアシング

BOOL antialiasing(FILTERDRAW &info)
{
    int ix,iy,f;
    RGBAFIX15 col,colxy,colx,coly;
    CTileImage *pimg;

    info.ntmp[0] = (info.valbar[0] << 14) / 100;

    //プレビュー時はコピー

    if(info.isPrev()) copyRect(info);

    //(右端・下端は処理しない)

    pimg = info.pimgSrc;

    info.progBeginOneStep(50, info.rs.h - 1);

    for(iy = info.rs.y1; iy < info.rs.y2; iy++)
    {
        for(ix = info.rs.x1; ix < info.rs.x2; ix++)
        {
            pimg->getPixel(&col, ix, iy);
            pimg->getPixel(&colx, ix + 1, iy);
            pimg->getPixel(&coly, ix, iy + 1);
            pimg->getPixel(&colxy, ix + 1, iy + 1);

            f = _aa_comp(col, colxy) | (_aa_comp(colx, coly) << 1) | (_aa_comp(col, coly) << 2);

            if(f == 7) continue;

            if(f & 1) _aa_func(ix, iy, FALSE, info);
            if(f & 2) _aa_func(ix, iy, TRUE, info);
        }

        info.progIncSub();
    }

    return TRUE;
}

};
