/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CSinTable [sin 値テーブル（512個 float）]

    360度=512 として、角度は 0〜511。
    cos値は、+90度したsin値で取得できる。
*/


#include <math.h>

#include "CSinTable.h"



CSinTable *CSinTable::m_pSelf = 0;


CSinTable::CSinTable()
{
    int i;
    double angle,add;

    m_pSelf = this;

    //

    angle = 0;
    add   = M_PI / 256.0;

    for(i = 0; i < 512; i++, angle += add)
        m_buf[i] = (float)::sin(angle);
}

