/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CConfig - 設定データ
*/


#include <string.h>

#include "CConfig.h"

#include "AXConfRead.h"
#include "AXConfWrite.h"
#include "AXApp.h"


//----------------------------

DWORD g_dwWaterPresetInit[CConfig::WATERPRESET_NUM] = {
    800|(1000<<10)|(500<<20), 500|(900<<10)|(400<<20), 300|(600<<10)|(200<<20),
    100|(1000<<10)|(50<<20), 100|(100<<10)|(200<<20)
};

//----------------------------


CConfig::CConfig()
{
    int i;

    btColMaskType = 0;

    /*-- !配列読み込みをするデータは必ず初期化すること --*/

    nColHLSVal[0] = 0;
    nColHLSVal[1] = 0;
    nColHLSVal[2] = 50;
    nColHLSVal[3] = 100;

    //

    AXMemZero(wRuleAngle, sizeof(WORD) * RULEANGLE_NUM);
    AXMemZero(sRulePos, sizeof(short) * RULEPOS_NUM * 2);

    //色マスク

    for(i = 0; i < COLMASK_NUM; i++)
        dwColMask[i] = 0;

    //イメージ背景色リスト

    for(i = 0; i < IMGBKCOL_NUM; i++)
        dwImgBkColList[i] = 0xffffff;

    //グラデーションパレット

    for(i = 0; i < GRADPAL_NUM; i++)
    {
        dwGradPalCol[i * 2]     = 0;
        dwGradPalCol[i * 2 + 1] = 0xffffff;
    }

    //新規サイズ登録

    for(i = 0; i < NEWREG_NUM; i++)
    {
        dwNewRegSize[i] = (300 << 16) | 300;
        wNewRegDPI[i]   = 300;
    }

    //新規サイズ履歴

    for(i = 0; i < NEWRECENT_NUM; i++)
    {
        dwNewRecentSize[i] = (300 << 16) | 300;
        wNewRecentDPI[i]   = 300;
    }

    //グリッドリスト

    for(i = 0; i < GRIDLIST_NUM; i++)
        dwGridList[i] = (100 << 16) | 100;

    //入り抜きリスト

    for(i = 0; i < HEADTAIL_NUM; i++)
        wHeadTailList[i] = 100;

    //水彩プリセット

    resetWaterPreset();
}

//! 新規作成の履歴を追加

void CConfig::addNewRecent(int w,int h,int dpi)
{
    DWORD val;
    int i,top;

    val = ((DWORD)w << 16) | h;
    top = NEWRECENT_NUM - 1;

    //すでに存在するか

    for(i = 0; i < NEWRECENT_NUM; i++)
    {
        if(dwNewRecentSize[i] == val && wNewRecentDPI[i] == dpi)
        {
            top = i;
            break;
        }
    }

    //先頭を空ける

    for(i = top; i > 0; i--)
    {
        dwNewRecentSize[i] = dwNewRecentSize[i - 1];
        wNewRecentDPI[i]   = wNewRecentDPI[i - 1];
    }

    dwNewRecentSize[0] = val;
    wNewRecentDPI[0]   = dpi;
}

//! 水彩プリセットを初期値に戻す

void CConfig::resetWaterPreset()
{
    ::memcpy(dwWaterPreset, g_dwWaterPresetInit, sizeof(DWORD) * WATERPRESET_NUM);
}


//==========================
// 設定ファイル
//==========================


//! 設定ファイルから読み込み

void CConfig::load(AXConfRead *pcf)
{
    //-------- window

    pcf->setGroup("window");

    pcf->getRectSize("main", &rcsMainWin, WININITVAL);
    pcf->getPoint("tool", &ptToolWin, WININITVAL);
    pcf->getRectSize("brush", &rcsBrushWin, WININITVAL);
    pcf->getRectSize("layer", &rcsLayerWin, WININITVAL);
    pcf->getRectSize("option", &rcsOptWin, WININITVAL);
    pcf->getRectSize("color", &rcsColWin, WININITVAL);
    pcf->getRectSize("imgview", &rcsImgViewWin, WININITVAL);
    pcf->getRectSize("prev", &rcsPrevWin, WININITVAL);
    pcf->getRectSize("flist", &rcsFilterListWin, WININITVAL);
    pcf->getRectSize("text", &rcsTextWin, WININITVAL);
    pcf->getSize("selimg", &szSelImgDlg, 0, 0);

    bMaximized = pcf->getInt("maximized", FALSE);

    nBrushWinH[0] = pcf->getInt("brushH1", 58);
    nBrushWinH[1] = pcf->getInt("brushH2", 70);

    //-------- env

    pcf->setGroup("env");

    uFlags          = pcf->getHex("flag", FLAG_AUTOACTIVE|FLAG_MES_SAVE_OVERWRITE);
    uEtcFlags       = pcf->getHex("etcflag", ETCF_FILTERDLG_PREV|ETCF_SCALEROTDLG_PREV);
    uWinViewFlags   = pcf->getHex("winviewf",
                WINVIEWF_TOOL|WINVIEWF_LAYER|WINVIEWF_BRUSH|WINVIEWF_OPTION|WINVIEWF_COLOR);
    uEtcViewFlags   = pcf->getHex("etcviewf", ETCVIEWF_TOOLBAR|ETCVIEWF_SCROLLBAR);
    uWinViewBkFlags = pcf->getHex("viewbkf", 0);
    uPrevWinFlags   = pcf->getHex("prevf", PREVF_LEFT_CANVAS|PREVF_FULLVIEW);
    uImgVFlags      = pcf->getHex("imgvf", IMGVF_FULLVIEW);
    uBrushValExpand = pcf->getHex("brushvalexp", 1);
    uUndoMaxBuf     = pcf->getHex("undomaxbuf", 2 * 1024 * 1024);
    uJPEGSave       = pcf->getHex("jpegsave", 85|(411<<7));

    nInitImgW       = pcf->getInt("initw", 400);
    nInitImgH       = pcf->getInt("inith", 400);
    nScaleUpStep    = pcf->getInt("scaleupstep", 100);
    nScaleDownStep  = pcf->getInt("scaledownstep", 15);
    nAngleStep      = pcf->getInt("anglestep", 15);
    nPrevWinScale      = pcf->getInt("prevscale", 1000);
    nPrevWinLoupeScale = pcf->getInt("prevlpscale", 100);
    nUndoCnt        = pcf->getInt("undocnt", 60);
    sDragBrushSizeW = pcf->getInt("dragbrushsizew", 10);
    sFontSizeDef    = pcf->getInt("fontsizedef", 9);
    sFontSizeSubWin = pcf->getInt("fontsizesubwin", 8);
    wPalOneSize     = pcf->getInt("palonesize", (14<<8)|12);

    nGridW          = pcf->getInt("gridw", 100);
    nGridH          = pcf->getInt("gridh", 100);
    nGridSplitX     = pcf->getInt("gridspx", 2);
    nGridSplitY     = pcf->getInt("gridspy", 2);
    n1pxGridScale   = pcf->getInt("grid1px", 8000);

    btColWinTab     = pcf->getInt("colwintab", 0);
    btColBarType    = pcf->getInt("colbartype", 0);
    btColPalSel     = pcf->getInt("colpalsel", 0);
    btOptWinTab     = pcf->getInt("optwintab", 0);
    btImgBkColSel   = pcf->getInt("imgbkcolsel", 0);
    btOptHeadTailType = pcf->getInt("headtailtype", 0);
    btScaleCanvType = pcf->getInt("scalecanvtype", 3);
    btPNGLevel      = pcf->getInt("pnglevel", 6);
    btExportType    = pcf->getInt("exporttype", 0);
    btToolboxType	= pcf->getInt("toolboxtype", 0);

    pcf->getArrayVal("colhlsval", nColHLSVal, 4, sizeof(int));

    //------- color

    pcf->setGroup("color");

    dwDrawCol       = pcf->getHex("drawcol", 0);
    dwBackCol       = pcf->getHex("backcol", 0xffffff);
    dwCanvasBkCol   = pcf->getHex("canvasbkcol", 0xc0c0c0);
    dwImgBkCol      = pcf->getHex("imgbkcol", 0xffffff);
    dwBkCheckCol[0] = pcf->getHex("bkcheckcol1", 0xd0d0d0);
    dwBkCheckCol[1] = pcf->getHex("bkcheckcol2", 0xf0f0f0);
    dwGridCol       = pcf->getHex("gridcol", 0x400040ff);
    dwGridSplitCol  = pcf->getHex("gridspcol", 0x40ff00ff);

    //-------- envstr

    pcf->setGroup("envstr");

    pcf->getStr("opendir", &strOpenDir);
    pcf->getStr("savedir", &strSaveDir);
    pcf->getStr("exportdir", &strExportDir);
    pcf->getStr("imgviewdir", &strImgViewDir);
    pcf->getStr("layersavedir", &strLayerSaveDir);
    pcf->getStr("usertexdir", &strUserTexDir);
    pcf->getStr("userbrushdir", &strUserBrushDir);
    pcf->getStr("opttexpath", &strOptTexPath);
    pcf->getStr("fontwin", &strFontWin);

    if(strUserTexDir.isEmpty())
        axapp->getConfigPath(&strUserTexDir, "texture");

    if(strUserBrushDir.isEmpty())
        axapp->getConfigPath(&strUserBrushDir, "brush");

    //---------- dat

    pcf->setGroup("dat");

    pcf->getArrayVal("imgbkcol", dwImgBkColList, IMGBKCOL_NUM, sizeof(DWORD), TRUE);
    pcf->getArrayVal("colmask", dwColMask, COLMASK_NUM, sizeof(DWORD), TRUE);
    pcf->getArrayVal("gradpal", dwGradPalCol, GRADPAL_NUM * 2, sizeof(DWORD), TRUE);
    pcf->getArrayVal("newregsize", dwNewRegSize, NEWREG_NUM, sizeof(DWORD), TRUE);
    pcf->getArrayVal("newregdpi", wNewRegDPI, NEWREG_NUM, sizeof(WORD), FALSE);
    pcf->getArrayVal("newrecsize", dwNewRecentSize, NEWRECENT_NUM, sizeof(DWORD), TRUE);
    pcf->getArrayVal("newrecdpi", wNewRecentDPI, NEWRECENT_NUM, sizeof(WORD), FALSE);
    pcf->getArrayVal("gridlist", dwGridList, GRIDLIST_NUM, sizeof(DWORD), TRUE);
    pcf->getArrayVal("ruleangle", wRuleAngle, RULEANGLE_NUM, sizeof(WORD));
    pcf->getArrayVal("rulepos", sRulePos, RULEPOS_NUM * 2, sizeof(short));
    pcf->getArrayVal("waterpreset", dwWaterPreset, WATERPRESET_NUM, sizeof(DWORD), TRUE);
    pcf->getArrayVal("headtail", wHeadTailList, HEADTAIL_NUM, sizeof(WORD), FALSE);
    pcf->getBase64("drawcursor", &memDrawCursor);

    //-------- 最近使ったファイル

    pcf->setGroup("recentfile");
    pcf->getStrArray(0, strRecFile, RECFILE_NUM);

    //-------- 開いたディレクトリ履歴

    pcf->setGroup("recopendir");
    pcf->getStrArray(0, strRecOpenDir, RECDIR_NUM);

    //-------- 保存ディレクトリ履歴

    pcf->setGroup("recsavedir");
    pcf->getStrArray(0, strRecSaveDir, RECSAVEDIR_NUM);

    //-------- エクスポートディレクトリ履歴

    pcf->setGroup("recexportdir");
    pcf->getStrArray(0, strRecExpDir, RECEXPDIR_NUM);
}

//! 設定ファイルに書き込み

void CConfig::save(AXConfWrite *pcf)
{
    //-------- window

    pcf->putGroup("window");

    pcf->putRectSize("main", rcsMainWin);
    pcf->putPoint("tool", ptToolWin);
    pcf->putRectSize("brush", rcsBrushWin);
    pcf->putRectSize("layer", rcsLayerWin);
    pcf->putRectSize("option", rcsOptWin);
    pcf->putRectSize("color", rcsColWin);
    pcf->putRectSize("imgview", rcsImgViewWin);
    pcf->putRectSize("prev", rcsPrevWin);
    pcf->putRectSize("flist", rcsFilterListWin);
    pcf->putRectSize("text", rcsTextWin);
    pcf->putSize("selimg", szSelImgDlg);

    pcf->putInt("maximized", bMaximized);

    pcf->putInt("brushH1", nBrushWinH[0]);
    pcf->putInt("brushH2", nBrushWinH[1]);

    //--------- env

    pcf->putGroup("env");

    pcf->putHex("flag", uFlags);
    pcf->putHex("etcflag", uEtcFlags);
    pcf->putHex("winviewf", uWinViewFlags);
    pcf->putHex("etcviewf", uEtcViewFlags);
    pcf->putHex("viewbkf", uWinViewBkFlags);
    pcf->putHex("prevf", uPrevWinFlags);
    pcf->putHex("imgvf", uImgVFlags);
    pcf->putHex("brushvalexp", uBrushValExpand);
    pcf->putHex("undomaxbuf", uUndoMaxBuf);
    pcf->putHex("jpegsave", uJPEGSave);

    pcf->putInt("initw", nInitImgW);
    pcf->putInt("inith", nInitImgH);
    pcf->putInt("scaleupstep", nScaleUpStep);
    pcf->putInt("scaledownstep", nScaleDownStep);
    pcf->putInt("anglestep", nAngleStep);
    pcf->putInt("prevscale", nPrevWinScale);
    pcf->putInt("prevlpscale", nPrevWinLoupeScale);
    pcf->putInt("undocnt", nUndoCnt);
    pcf->putInt("dragbrushsizew", sDragBrushSizeW);
    pcf->putInt("fontsizedef", sFontSizeDef);
    pcf->putInt("fontsizesubwin", sFontSizeSubWin);
    pcf->putInt("palonesize", wPalOneSize);

    pcf->putInt("gridw", nGridW);
    pcf->putInt("gridh", nGridH);
    pcf->putInt("gridspx", nGridSplitX);
    pcf->putInt("gridspy", nGridSplitY);
    pcf->putInt("grid1px", n1pxGridScale);

    pcf->putInt("colwintab", btColWinTab);
    pcf->putInt("colbartype", btColBarType);
    pcf->putInt("colpalsel", btColPalSel);
    pcf->putInt("optwintab", btOptWinTab);
    pcf->putInt("imgbkcolsel", btImgBkColSel);
    pcf->putInt("headtailtype", btOptHeadTailType);
    pcf->putInt("scalecanvtype", btScaleCanvType);
    pcf->putInt("pnglevel", btPNGLevel);
    pcf->putInt("exporttype", btExportType);
    pcf->putInt("toolboxtype", btToolboxType);

    pcf->putArrayVal("colhlsval", nColHLSVal, 4, sizeof(int));

    //-------- color

    pcf->putGroup("color");

    pcf->putHex("drawcol", dwDrawCol);
    pcf->putHex("backcol", dwBackCol);
    pcf->putHex("canvasbkcol", dwCanvasBkCol);
    pcf->putHex("imgbkcol", dwImgBkCol);
    pcf->putHex("bkcheckcol1", dwBkCheckCol[0]);
    pcf->putHex("bkcheckcol2", dwBkCheckCol[1]);
    pcf->putHex("gridcol", dwGridCol);
    pcf->putHex("gridspcol", dwGridSplitCol);

    //-------- envstr

    pcf->putGroup("envstr");

    pcf->putStr("opendir", strOpenDir);
    pcf->putStr("savedir", strSaveDir);
    pcf->putStr("exportdir", strExportDir);
    pcf->putStr("imgviewdir", strImgViewDir);
    pcf->putStr("layersavedir", strLayerSaveDir);
    pcf->putStr("usertexdir", strUserTexDir);
    pcf->putStr("userbrushdir", strUserBrushDir);
    pcf->putStr("opttexpath", strOptTexPath);
    pcf->putStr("fontwin", strFontWin);

    //-------- dat

    pcf->putGroup("dat");

    pcf->putArrayHex("imgbkcol", dwImgBkColList, IMGBKCOL_NUM);
    pcf->putArrayHex("colmask", dwColMask, COLMASK_NUM);
    pcf->putArrayHex("gradpal", dwGradPalCol, GRADPAL_NUM * 2);
    pcf->putArrayHex("newregsize", dwNewRegSize, NEWREG_NUM);
    pcf->putArrayVal("newregdpi", wNewRegDPI, NEWREG_NUM, sizeof(WORD));
    pcf->putArrayHex("newrecsize", dwNewRecentSize, NEWRECENT_NUM);
    pcf->putArrayVal("newrecdpi", wNewRecentDPI, NEWRECENT_NUM, sizeof(WORD));
    pcf->putArrayHex("gridlist", dwGridList, GRIDLIST_NUM);
    pcf->putArrayVal("ruleangle", wRuleAngle, RULEANGLE_NUM, sizeof(WORD));
    pcf->putArrayVal("rulepos", sRulePos, RULEPOS_NUM * 2, sizeof(short));
    pcf->putArrayHex("waterpreset", dwWaterPreset, WATERPRESET_NUM);
    pcf->putArrayVal("headtail", wHeadTailList, HEADTAIL_NUM, sizeof(WORD));
    pcf->putBase64("drawcursor", memDrawCursor, memDrawCursor.getSize());

    //--------- 最近使ったファイル

    pcf->putGroup("recentfile");
    pcf->putStrArray(0, strRecFile, RECFILE_NUM);

    //-------- 開いたディレクトリ履歴

    pcf->putGroup("recopendir");
    pcf->putStrArray(0, strRecOpenDir, RECDIR_NUM);

    //-------- 保存ディレクトリ履歴

    pcf->putGroup("recsavedir");
    pcf->putStrArray(0, strRecSaveDir, RECSAVEDIR_NUM);

    //-------- エクスポートディレクトリ履歴

    pcf->putGroup("recexportdir");
    pcf->putStrArray(0, strRecExpDir, RECEXPDIR_NUM);
}
