/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    描画操作・サブ2

    グラデーション、テキスト、矩形編集、選択範囲
*/


#include "drawdat.h"
#include "drawOpDef.h"

#include "draw_main.h"
#include "draw_opsub.h"
#include "draw_opfunc.h"
#include "draw_update.h"
#include "draw_calc.h"

#include "CCanvasWin.h"
#include "CDrawTextDlg.h"
#include "CScaleRotDlg.h"
#include "CLayerItem.h"
#include "CGradList.h"
#include "CTileImageA1.h"
#include "CPolygonPaint.h"
#include "CPosBuf.h"
#include "CFont.h"
#include "CConfig.h"

#include "cursor.h"
#include "global.h"

#include "AXApp.h"


namespace draw
{

//=============================
// グラデーション
//=============================


//! 描画色->背景色データセット

void setGradDatDefault(AXMem *pmem)
{
    LPBYTE p;
    int i;
    BYTE flag;

    if(!pmem->alloc(3 + 8 * 2 + 4 * 2)) return;

    p = *pmem;

    flag = (g_draw->tool.optGrad & (1<<12))? 1: 0;
    if(g_draw->tool.optGrad & (1<<13)) flag |= 2;

    *(p++) = flag;
    *(p++) = 2;
    *(p++) = 2;

    //COL

    *((LPWORD)p) = 0; p += 2;

    for(i = 0; i < 3; i++, p += 2)
        *((LPWORD)p) = g_draw->colDraw.c[i];

    *((LPWORD)p) = 0x8000; p += 2;

    for(i = 0; i < 3; i++, p += 2)
        *((LPWORD)p) = g_draw->colBack.c[i];

    //A

    *((LPWORD)p) = 0; p += 2;

    for(i = 0; i < 3; i++, p += 2)
        *((LPWORD)p) = 0x8000;
}

//! グラデーション描画

void draw_grad()
{
    AXPoint pt[2];
    AXRect rc;
    AXMem mem;
    int type,opacity;
    DWORD val;
    void (CTileImage::*funcDraw[4])(int,int,int,int,const AXRect&,int,LPBYTE) = {
        &CTileImage::drawGradient_line, &CTileImage::drawGradient_circle,
        &CTileImage::drawGradient_box, &CTileImage::drawGradient_radial
    };

    val = g_draw->tool.optGrad;

    //描画用データセット

    if(val & (1<<11))
    {
        //カスタム

        if(!GRADLIST->setDrawDat(&mem, (val >> 16) & 255,
                g_draw->colDraw, g_draw->colBack, val & (1<<12), val & (1<<13)))
            setGradDatDefault(&mem);
    }
    else
        setGradDatDefault(&mem);

    if(mem.isNULL()) return;

    //描画位置

    g_draw->view.winToimg(&pt[0], g_draw->work.ptTmp[0].x, g_draw->work.ptTmp[0].y);
    g_draw->view.winToimg(&pt[1], g_draw->work.ptTmp[1].x, g_draw->work.ptTmp[1].y);

    //描画する矩形範囲

    if(g_draw->work.rcfSel.flag)
        g_draw->work.rcfSel.toRect(&rc);
    else
        g_draw->pcurlayer->m_pimg->getEnableDrawRectPixel(&rc);

    //

    opacity = ((val & 127) * 256 + 50) / 100;

    //描画

    setBeforeDraw(TOOL_GRAD);

    beginDraw();

    type = g_draw->tool.toolSubNo[TOOL_GRAD];

    (g_draw->pcurlayer->m_pimg->*funcDraw[type])(pt[0].x, pt[0].y, pt[1].x, pt[1].y, rc, opacity, mem);

    endDraw();
}


//=============================
// テキスト
//=============================
/*
    pimgTmp[0] : プレビュー表示用（updateRect 時に直接描画する）
    ptTmp[0]   : 描画位置（イメージ位置）
    rcfDrawUp  : プレビュー前回の描画範囲
*/


//! 押し時

void op_text_down()
{
    CDrawTextDlg *pdlg;
    BOOL ret;
    AXRect rc;

	//描画位置

	getNowImgPoint(&g_draw->work.ptTmp[0]);

    //プレビュー用イメージ

    rc.set(0, 0, g_draw->nImgW, g_draw->nImgH);

    if(!allocTmpTileImg(0, rc)) return;

    //

    g_draw->work.nNowOpNo = OPNO_DRAWTEXT;

    g_draw->work.rcfDrawUp.clear();

    g_draw->drawinfo.colDraw = g_draw->colDraw;
    g_draw->drawinfo.colDraw.a = 0x8000;

    //-------- ダイアログ

    pdlg = new CDrawTextDlg;

    ret = pdlg->runDialog();

    //-------- 終了

    g_draw->work.nNowOpNo = OPNO_NONE;

    //プレビュー用イメージ削除

    freeTmpTileImg();

    //プレビュー範囲を元に戻す

    updateRect(g_draw->work.rcfDrawUp);

    //描画

    if(ret)
    {
        CFont::DRAWINFO info;

        setBeforeDraw(TOOL_TEXT);
        beginDrawUndo();

        //描画情報

        info.nCharSpace = g_draw->text.nCharSpace;
        info.nLineSpace = g_draw->text.nLineSpace;
        info.nHinting   = g_draw->text.nHinting;
        info.pixfunc    = &CTileImage::setPixelDraw;
        info.col        = g_draw->drawinfo.colDraw;
        info.col.a      = 0x8000;

        info.uFlags = 0;
        if(g_draw->text.is2col()) info.uFlags |= CFont::INFOFLAG_2COL;
        if(g_draw->text.isVert()) info.uFlags |= CFont::INFOFLAG_VERT;

        //

        g_draw->pfont->drawString(g_draw->pcurlayer->m_pimg,
            g_draw->work.ptTmp[0].x, g_draw->work.ptTmp[0].y,
            g_draw->text.strText, info);

        commonAfterDraw();
    }
}

//! ダイアログ中の押し時（描画位置変更）

void op_textInDlg_down(int winx,int winy)
{
    //位置

    g_draw->view.winToimg(&g_draw->work.ptTmp[0], winx, winy);

    //プレビュー

    draw_textPrev();
}


//! フォント作成（ダイアログ表示時）

void text_createFontInit()
{
    if(g_draw->pfont->isNone())
        text_createFont();
}

//! フォント作成

void text_createFont()
{
    g_draw->pfont->load(g_draw->text.strFontFace, g_draw->text.strFontStyle, g_draw->text.nSize);
}

//! キャッシュクリア

void text_clearCache()
{
    g_draw->pfont->freeCache();
}

//! テキストプレビュー描画

void draw_textPrev()
{
    CFont::DRAWINFO info;
    FLAGRECT rcf;

    rcf = g_draw->work.rcfDrawUp;

    //プレビューイメージ・範囲クリア

    if(g_draw->work.rcfDrawUp.flag)
    {
        g_draw->pimgTmp[0]->freeAllTile();
        g_draw->work.rcfDrawUp.clear();
    }

    //プレビューなしの時、前回の範囲を消す

    if(!g_draw->text.isPreview())
    {
        updateRect(rcf);
        return;
    }

    //描画情報

    info.nCharSpace = g_draw->text.nCharSpace;
    info.nLineSpace = g_draw->text.nLineSpace;
    info.nHinting   = g_draw->text.nHinting;
    info.pixfunc    = &CTileImage::setPixel_subdraw;
    info.col        = g_draw->drawinfo.colDraw;

    info.uFlags = 0;
    if(g_draw->text.is2col()) info.uFlags |= CFont::INFOFLAG_2COL;
    if(g_draw->text.isVert()) info.uFlags |= CFont::INFOFLAG_VERT;

    //描画

    g_draw->drawinfo.funcColor = &CTileImage::colfunc_normal;
    g_draw->drawinfo.rcfDraw.clear();

    g_draw->pfont->drawString(g_draw->pimgTmp[0],
            g_draw->work.ptTmp[0].x, g_draw->work.ptTmp[0].y,
            g_draw->text.strText, info);

    //更新（前回の範囲と合わせた範囲）

    rcf.combine(g_draw->drawinfo.rcfDraw);

    updateRect(rcf);
    axapp->update();

    //rcfDrawUp = 今回の範囲

    g_draw->work.rcfDrawUp = g_draw->drawinfo.rcfDraw;
}


//=============================
// 矩形編集
//=============================
/*
    rcsTmp[0] に矩形範囲（イメージ位置）
    ※範囲はキャンバス内に調整されている
*/


//! 左右・上下反転

void draw_boxedit_revHV(BOOL bHorz)
{
    setBeforeDraw(TOOL_BOXEDIT);
    beginDraw();

    if(bHorz)
        g_draw->pcurlayer->m_pimg->reverseHorzRect(g_draw->work.rcsTmp[0]);
    else
        g_draw->pcurlayer->m_pimg->reverseVertRect(g_draw->work.rcsTmp[0]);

    endDraw();
}

//! 左/右に90度回転

void draw_boxedit_rotate90(BOOL bLeft)
{
    AXRect rc;

    rc.set(g_draw->work.rcsTmp[0]);

    //作業用に範囲イメージコピー

    if(!allocTmpTileImg(0, rc)) return;

    g_draw->pimgTmp[0]->copyRect(g_draw->pcurlayer->m_pimg, rc);

    //

    setBeforeDraw(TOOL_BOXEDIT);
    beginDraw();

    g_draw->pcurlayer->m_pimg->clearRect(rc);

    if(bLeft)
        g_draw->pcurlayer->m_pimg->rotateLeftRect(g_draw->pimgTmp[0], g_draw->work.rcsTmp[0]);
    else
        g_draw->pcurlayer->m_pimg->rotateRightRect(g_draw->pimgTmp[0], g_draw->work.rcsTmp[0]);

    endDraw();

    //

    freeTmpTileImg();
}

//! 拡大縮小＆回転
/*
    プレビュー中はカレントレイヤの矩形範囲は消去する。

    pimgTmp[0]   : 矩形範囲内のイメージ
    pimgTmp[1]   : プレビュー描画用(updateRect 時に直接描画)
    drawinfo::rcfDraw : プレビューの描画範囲
*/

void draw_boxedit_scaleRot()
{
    CScaleRotDlg *pdlg;
    AXRect rc,rc2;
    FLAGRECT rcf;
    BOOL ret;
    double val[2];

    //範囲をFLAGRECTに

    rcf.set(g_draw->work.rcsTmp[0]);

    rcf.toRect(&rc);

    //作業用イメージ

    rc2.set(0, 0, g_draw->nImgW - 1, g_draw->nImgH - 1);

    if(!allocTmpTileImg(0, rc)) return;
    if(!allocTmpTileImg(1, rc2)) { freeTmpTileImg(0); return; }

    //範囲のイメージを pimgTmp[0] にコピー & カレントの範囲内をクリア

    g_draw->pcurlayer->m_pimg->copyClearRect(g_draw->pimgTmp[0], rc);

    //----------

    g_draw->work.nNowOpNo = OPNO_SCALEROTDLG;

    g_draw->drawinfo.funcDrawPixel = &CTileImage::setPixel_subdraw;
    g_draw->drawinfo.funcColor     = &CTileImage::colfunc_overwrite;
    g_draw->drawinfo.rcfDraw.clear();

    //プレビュー（OFF 時は、消去した部分を更新）

    if(g_conf->uEtcFlags & CConfig::ETCF_SCALEROTDLG_PREV)
        draw_boxedit_scaleRotPrev(rc, 1.0, 0);
    else
        updateRect(rcf);

    //--------- ダイアログ

    pdlg = new CScaleRotDlg(&rc, val);

    ret = pdlg->runDialog();

    //---------

    g_draw->work.nNowOpNo = OPNO_NONE;

    freeTmpTileImg(1);

    //クリアした部分のイメージを戻す

    g_draw->pcurlayer->m_pimg->copyRect(g_draw->pimgTmp[0], rc);

    //矩形範囲＋プレビュー範囲を戻す

    rcf.combine(g_draw->drawinfo.rcfDraw);

    updateRect(rcf);

    //描画

    if(ret)
    {
        setBeforeDraw(TOOL_BOXEDIT);
        beginDraw();

        //消去

        g_draw->pcurlayer->m_pimg->drawFillBox(rc.left, rc.top, rc.width(), rc.height(), 0);

        //描画

        g_draw->drawinfo.funcColor = &CTileImage::colfunc_normal;

        g_draw->pcurlayer->m_pimg->scaleAndRotate(g_draw->pimgTmp[0], rc, val[0], val[1], TRUE);

        endDraw();
    }

    freeTmpTileImg(0);
}

//! 拡大縮小＆回転 プレビュー

void draw_boxedit_scaleRotPrev(const AXRect &rc,double scale,double angle)
{
    FLAGRECT rcf;

    rcf = g_draw->drawinfo.rcfDraw;

    g_draw->drawinfo.rcfDraw.clear();

    g_draw->pimgTmp[1]->freeAllTile();

    //

    if(g_conf->uEtcFlags & CConfig::ETCF_SCALEROTDLG_PREV)
    {
        //描画

        g_draw->pimgTmp[1]->scaleAndRotate(g_draw->pimgTmp[0], rc, scale, angle, FALSE);

        //範囲

        rcf.combine(g_draw->drawinfo.rcfDraw);
    }

    updateRect(rcf);
}


//==================================
// 選択範囲
//==================================
/*
    - 選択範囲イメージは pimgSel (A-1bit)。
    - 範囲情報は work.rcfSel。
*/


//! 選択範囲 多角形 共通

void draw_sel_polygonCommon()
{
    BOOL bDel;

    CANVASAREA->setCursorWait();

    if(selAllocArray())
    {
        bDel = (g_draw->tool.optSel == 1 || g_draw->work.uModDown == MOD_SHIFT);

        //多角形

        setBeforeDraw(TOOL_SEL);

        g_draw->pimgSel->drawFillPolygonNoAA(g_draw->pPolyPaint, !bDel);

        //範囲

        if(bDel)
        {
            selFreeEmpty(); //透明部分解放

            g_draw->pimgSel->getExistImgRectPx(&g_draw->work.rcfSel);
        }
        else
            g_draw->work.rcfSel.combine(g_draw->drawinfo.rcfDraw);

        //更新

        updateCanvas(g_draw->drawinfo.rcfDraw);
    }

    CANVASAREA->restoreCursorTool();
}

//! 選択範囲(四角塗りつぶし)

void draw_sel_box()
{
    DPOINT pt[4];
    int i;

    //描画位置

    getDrawBoxPoint(pt);

    //点セット

    if(!g_draw->pPolyPaint->alloc(5)) return;

    for(i = 0; i < 4; i++)
        g_draw->pPolyPaint->add(pt[i].x, pt[i].y);

    g_draw->pPolyPaint->endPos();

    //描画

    draw_sel_polygonCommon();
}


//=============================
// 選択範囲 ブラシ描画
//=============================
/*
    +Shift or 消しゴムブラシで範囲削除
*/


//! 押し時

BOOL op_selbrush_down()
{
    DRAWPOINT pt;

    //イメージ準備

    if(!selAllocArray()) return FALSE;

    //

    setOpInfo(OPNO_SELBRUSH, op_selbrush_move, op_selbrush_up);

    //描画準備

    setBeforeDraw_selBrush();

    getDrawPoint(&pt, FALSE);

    g_draw->pPosBuf->init(0, 0, pt.x, pt.y, pt.press);

    g_draw->pimgSel->startDrawBrushFree(pt.x, pt.y, pt.press);

    g_draw->work.rcfDrawUp.clear();

    return TRUE;
}

//! 移動時

void op_selbrush_move(UINT uModKey)
{
    DRAWPOINT pt;
    CPosBuf::POSDAT *p;

    //位置 （定規無効）

    getDrawPoint(&pt, FALSE);

    p = g_draw->pPosBuf->addPos(pt.x, pt.y, pt.press);

    //描画

    g_draw->drawinfo.rcfDraw.clear();

    g_draw->pimgSel->drawBrush_free(p->x, p->y, p->press);

    g_draw->work.rcfSel.combine(g_draw->drawinfo.rcfDraw);

    commonFreeDraw();
}

//! 離し

BOOL op_selbrush_up()
{
    //範囲削除時

    if(g_draw->drawinfo.funcColor == &CTileImage::colfunc_erase)
    {
        selFreeEmpty();

        g_draw->pimgSel->getExistImgRectPx(&g_draw->work.rcfSel);
    }

    return TRUE;
}


//=============================
// 選択範囲イメージ ドラッグ移動
//=============================
/*
    update_blendImage() で pimgTmp をカレントレイヤの後に描画。
    移動はレイヤのオフセット移動で行う。

    pimgTmp[0] : ドラッグイメージ
    ptTmp[0]   : 押し時のレイヤオフセット位置
    ptTmp[1]   : レイヤオフセット位置総移動px数
*/


//! 押し

BOOL op_selimgmove_down()
{
    AXRect rc;

    if(checkDrawLayer()) return FALSE;

    //pimgTmp にドラッグ用イメージ作成

    g_draw->work.rcfSel.toRect(&rc);

    if(!allocTmpTileImg(0, rc)) return FALSE;

    //UNDO開始

    beginDrawUndo();

    //元範囲を切り取り->pimgTmpにコピー

    setBeforeDraw_clearMask();
    g_draw->drawinfo.funcColor = &CTileImage::colfunc_overwrite;

    g_draw->pimgTmp[0]->copyCutSelectImage(g_draw->pcurlayer->m_pimg, g_draw->pimgSel);

    //作業用

    setOpInfo(OPNO_SELIMGMOVE, op_selimgmove_move, op_selimgmove_up);

    g_draw->pimgTmp[0]->getOffset(&g_draw->work.ptTmp[0]);

    g_draw->work.ptTmp[1].zero();

    //カーソル

    CANVASAREA->setCursorDrag(cursor::SELDRAG);

    return TRUE;
}

//! 移動

void op_selimgmove_move(UINT uModKey)
{
    AXPoint pt,pt2,ptMov;
    FLAGRECT rcf;
    AXRectSize rcs;

    pt2.x = (int)(g_draw->work.ptWinNow.x - g_draw->work.ptWinDown.x);
    pt2.y = (int)(g_draw->work.ptWinNow.y - g_draw->work.ptWinDown.y);

    //総移動数 変換

    g_draw->view.getMoveDst(&pt, pt2);

    pt.x += g_draw->work.ptTmp[0].x;
    pt.y += g_draw->work.ptTmp[0].y;

    //前回からの変化数

    g_draw->pimgTmp[0]->getOffset(&ptMov);

    ptMov.x = pt.x - ptMov.x;
    ptMov.y = pt.y - ptMov.y;

    if(ptMov.x == 0 && ptMov.y == 0) return;

    //オフセット移動

    g_draw->pimgTmp[0]->moveOffset(ptMov.x, ptMov.y);
    g_draw->pimgSel->moveOffset(ptMov.x, ptMov.y);

    g_draw->work.ptTmp[1].x += ptMov.x;
    g_draw->work.ptTmp[1].y += ptMov.y;

    //範囲

    rcf.combineMove(g_draw->work.rcfSel, ptMov.x, ptMov.y);
    rcf.inflate(2);

    g_draw->work.rcfSel.move(ptMov.x, ptMov.y);

    //更新

    if(getImgRect(&rcs, rcf))
        CANVASAREA->setTimer_updateRect(rcs, 5);
}

//! 離し

BOOL op_selimgmove_up()
{
    BOOL bOverwrite;

    CANVASAREA->clearTimer_updateRect();

    //押し時 Ctrl+Shift で上書き

    bOverwrite = (g_draw->work.uModDown == (MOD_CTRL | MOD_SHIFT));

    //ドラッグイメージを合成 (setPixelDraw - 合成/上書き)
    /*
        drawinfo.rcfDraw は切り取り時の範囲を残してあるので、そのまま範囲追加。
        切り取り＋合成の範囲がセットされることになる。
    */

    setBeforeDraw_selImgMove(bOverwrite);

    g_draw->pcurlayer->m_pimg->blendSelectImage(g_draw->pimgTmp[0], g_draw->pimgSel, bOverwrite);

    //

    freeTmpTileImg();

    //更新

    commonAfterDraw();

    //カーソル

    CANVASAREA->restoreCursorTool();

    return TRUE;
}

};
