/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    画像ファイル関連 : アルファ付きPNG出力
*/

#include "CProgressDlg.h"

#include "CTileImage.h"
#include "CLayerList.h"
#include "CLayerItem.h"

#include "AXPNGSave.h"

#include "draw_file.h"

#include "drawdat.h"
#include "global.h"


namespace draw
{

//! アルファ付きPNG出力 (レイヤはすべて「通常」合成)

int savePNG_alpha(const AXString &filename,CProgressDlg *pProgDlg)
{
    AXPNGSave png;
    AXPNGSave::INFO info;
    AXMem memLine;
    CLayerItem *p;
    int ix,iy;
    double r,g,b,a,sa,da,na,sr,sg,sb;
    RGBAFIX15 col;
    LPBYTE pDst;

    info.nWidth  = g_draw->nImgW;
    info.nHeight = g_draw->nImgH;
    info.nBits   = 32;
    info.nPalCnt = 0;

    if(!png.openFile(filename, &info)) return SAVERET_ERR;

    //Y1列分

    if(!memLine.alloc(png.getPitch())) return SAVERET_ERR;

    //

    if(!png.startImg()) return SAVERET_ERR;

    pProgDlg->beginProgSub(50, info.nHeight, TRUE);

    for(iy = 0; iy < info.nHeight; iy++)
    {
        pDst = memLine;

        *(pDst++) = 0;  //PNGフィルタ

        for(ix = 0; ix < info.nWidth; ix++)
        {
            //各レイヤイメージの点を合成

            r = g = b = a = 0;

            for(p = g_draw->player->getBottomVisibleImg(); p; p = p->prevVisibleImg())
            {
                p->m_pimg->getPixel(&col, ix, iy);

                sa = (double)(col.a * p->getViewOpacity() >> 7) / 0x8000;

                if(sa == 0) continue;

                sr = (double)col.r / 0x8000;
                sg = (double)col.g / 0x8000;
                sb = (double)col.b / 0x8000;

                if(sa == 1)
                    r = sr, g = sg, b = sb, a = sa;
                else
                {
                    da = a;
                    na = sa + da - sa * da;

                    a = na;

                    if(a != 0)
                    {
                        da *= 1.0 - sa;
                        na = 1.0 / na;

                        r = (sr * sa + r * da) * na;
                        g = (sg * sa + g * da) * na;
                        b = (sb * sa + b * da) * na;
                    }
                }
            }

            //1px分

            *(pDst++) = (BYTE)(r * 255 + 0.5);
            *(pDst++) = (BYTE)(g * 255 + 0.5);
            *(pDst++) = (BYTE)(b * 255 + 0.5);
            *(pDst++) = (BYTE)(a * 255 + 0.5);
        }

        //Y1列分出力

        if(!png.putImg(memLine)) return SAVERET_ERR;

        pProgDlg->incProgSub();
    }

    png.endImg();
    png.close();

    return SAVERET_OK;
}

};
