/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    draw::MAINDAT
*/

#include <string.h>
#include <math.h>

#include "drawdat.h"

#include "CXImage.h"
#include "CImageRGB16.h"
#include "CImage8.h"
#include "CTileImageRGBA.h"
#include "CTileImageA1.h"
#include "CLayerList.h"
#include "CPolygonPaint.h"
#include "CFont.h"
#include "CPosBuf.h"
#include "CSinTable.h"
#include "CUndo.h"

#include "blendcol.h"

#include "AXRand.h"
#include "AXConfRead.h"
#include "AXConfWrite.h"


//--------------------

AXRand      g_rand;
CSinTable   g_sintbl;

//--------------------


namespace draw
{

//! 解放

MAINDAT::~MAINDAT()
{
    delete pundo;
    delete pPosBuf;
    delete pfont;
    delete pPolyPaint;
    delete player;
    delete pimg8OptTex;
    delete pimg8DotBrush;
    delete pimgSel;
    delete pimgXor;
    delete pimgUndo;
    delete pimgCanvas;
    delete pimgBlend;
}

//! 初期化

MAINDAT::MAINDAT()
{
    int i;

    pimgTmp[0] = NULL;
    pimgTmp[1] = NULL;

    //確保

    pimgCanvas  = new CXImage;
    pimgBlend   = new CImageRGB16;
    pimgUndo    = new CTileImageRGBA;    //とりあえずRGBAで確保しておく
    pimgXor     = new CTileImageA1;
    pimgSel     = new CTileImageA1;
    pimg8DotBrush = new CImage8;
    pimg8OptTex   = new CImage8;

    player      = new CLayerList;
    pPolyPaint  = new CPolygonPaint;
    pfont       = new CFont;
    pPosBuf     = new CPosBuf;
    pundo       = new CUndo;

    //イメージ作成

    pimg8DotBrush->create(32, 32);

    //CTileImage 初期化

    CTileImage::m_pinfo  = &drawinfo;
    CTileImage::m_prand  = &g_rand;

    CTileImage::initCurve();

    //ゼロクリア

    ::memset(&drawinfo, 0, sizeof(TILEIMGDRAWINFO));
    ::memset(&tool, 0, sizeof(TOOLDAT));
    ::memset(&work, 0, sizeof(WORKDAT));
    ::memset(&rule, 0, sizeof(RULEDAT));

    //値初期化

    drawinfo.pDotBrush = pimg8DotBrush;

    rule.dAngleLine = rule.dAngleGrid = 90 * M_PI / 180;
    rule.dEllHV[0] = rule.dEllHV[1] = 1.0;
    rule.dEllTmp[0] = rule.dEllTmp[2] = 1.0;

    //合成関数

    funcBlendCol[0] = blendcol::normal;
    funcBlendCol[1] = blendcol::mul;
    funcBlendCol[2] = blendcol::add;
    funcBlendCol[3] = blendcol::sub;
    funcBlendCol[4] = blendcol::screen;
    funcBlendCol[5] = blendcol::overlay;
    funcBlendCol[6] = blendcol::hardlight;
    funcBlendCol[7] = blendcol::softlight;
    funcBlendCol[8] = blendcol::dodge;
    funcBlendCol[9] = blendcol::burn;
    funcBlendCol[10] = blendcol::linearburn;
    funcBlendCol[11] = blendcol::vividlight;
    funcBlendCol[12] = blendcol::linearlight;
    funcBlendCol[13] = blendcol::pinlight;
    funcBlendCol[14] = blendcol::darken;
    funcBlendCol[15] = blendcol::lighten;
    funcBlendCol[16] = blendcol::difference;

    //---- ツールデータ

    for(i = 0; i < DOTPENLIST_NUM; i++)
        tool.dwDotPenList[i] = 1 | (100 << 8);
}

//! 設定ファイルから読み込み

void MAINDAT::loadConfig(AXConfRead *pcf)
{
    //メイン

    pcf->setGroup("draw");

    tool.toolno = pcf->getInt("toolno", 0);
    tool.btDotPenListSel = pcf->getInt("dotpenlistsel", 0);

    tool.optMove        = pcf->getInt("optmove", 0);
    tool.optPolyPaint   = pcf->getInt("optpolyp", 100|(1<<11));
    tool.optPolyErase   = pcf->getInt("optpolye", 100|(1<<11));
    tool.optSel         = pcf->getInt("optsel", 0);
    tool.optPaint       = pcf->getInt("optpaint", 0|(100<<6));
    tool.optMagicWand   = pcf->getInt("optmagwand", 0);
    tool.optGrad        = pcf->getInt("optgrad", 100);
    tool.headtail[0]    = pcf->getInt("headtailline", 0);
    tool.headtail[1]    = pcf->getInt("headtailbezier", 0);

    pcf->getArrayVal("toolsub", tool.toolSubNo, TOOL_NUM, 1);
    pcf->getArrayVal("dotpenlist", tool.dwDotPenList, DOTPENLIST_NUM, sizeof(DWORD), TRUE);

    //テキスト

    pcf->setGroup("text");

    pcf->getStr("face", &text.strFontFace);
    pcf->getStr("style", &text.strFontStyle);

    text.nSize      = pcf->getInt("size", 12);
    text.nCharSpace = pcf->getInt("charsp", 0);
    text.nLineSpace = pcf->getInt("linesp", 0);
    text.nHinting   = pcf->getInt("hinting", 1);
    text.uFlags     = pcf->getInt("flags", DTEXTF_PREVIEW);
}

//! 設定ファイルに書き込み

void MAINDAT::saveConfig(AXConfWrite *pcf)
{
    //メイン

    pcf->putGroup("draw");

    pcf->putInt("toolno", tool.toolno);
    pcf->putInt("dotpenlistsel", tool.btDotPenListSel);

    pcf->putInt("optmove", tool.optMove);
    pcf->putInt("optpolyp", tool.optPolyPaint);
    pcf->putInt("optpolye", tool.optPolyErase);
    pcf->putInt("optsel", tool.optSel);
    pcf->putInt("optpaint", tool.optPaint);
    pcf->putInt("optmagwand", tool.optMagicWand);
    pcf->putInt("optgrad", tool.optGrad);
    pcf->putInt("headtailline", tool.headtail[0]);
    pcf->putInt("headtailbezier", tool.headtail[1]);

    pcf->putArrayVal("toolsub", tool.toolSubNo, TOOL_NUM, 1);
    pcf->putArrayHex("dotpenlist", tool.dwDotPenList, DOTPENLIST_NUM);

    //テキスト

    pcf->putGroup("text");

    pcf->putStr("face", text.strFontFace);
    pcf->putStr("style", text.strFontStyle);
    pcf->putInt("size", text.nSize);
    pcf->putInt("charsp", text.nCharSpace);
    pcf->putInt("linesp", text.nLineSpace);
    pcf->putInt("hinting", text.nHinting);
    pcf->putInt("flags", text.uFlags);
}

};
