<?php

/**
 * autorespond/setup.php
 * 
 * The plugin initialization page for the SquirrelMail "autorespond" plugin,
 * which allows a user to modify an email forward file and vacation files
 * over FTP, using their IMAP credentials for authentication.
 * 
 * @copyright Copyright (c) 2002-2007 O'Shaughnessy Evans <shaug-spamrule @ wumpus.org>
 * @version $Id: setup.php,v 1.10 2007/09/11 18:50:11 shaug Exp $
 * @license http://opensource.org/licenses/artistic-license-2.0.php
 * @package plugins
 * @subpackage autorespond
 */


/**
 * squirrelmail_plugin_init_autorespond()
 * 
 * Initialize the plugin.
 */
function squirrelmail_plugin_init_autorespond()
{
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['optpage_register_block']['autorespond']
     = 'autorespond_options';
    $squirrelmail_plugin_hooks['menuline']['autorespond']
     = 'autorespond_menuline';
}


/**
 * autorespond_options()
 * 
 * Set up the Options page block.
 */
function autorespond_options()
{
    global $optpage_blocks;

    bindtextdomain('autorespond', SM_PATH. 'plugins/autorespond/locale');
    textdomain('autorespond');

    $optpage_blocks[] = array(
        'name' => _("Auto Response:  Reply or Forward"),
        'url'  => '../plugins/autorespond/options.php',
        'desc' => _("Automatically reply to incoming mail or send ".
                  "it all to another address."),
        'js'   => FALSE
    );

    bindtextdomain('squirrelmail', SM_PATH. 'locale');
    textdomain('squirrelmail');
}


/**
 * autorespond_menuline()
 * 
 * Add a link to the main frame's menu line.
 */
function autorespond_menuline()
{
    bindtextdomain('autorespond', SM_PATH. 'plugins/autorespond/locale');
    textdomain('autorespond');

    displayInternalLink('plugins/autorespond/options.php',
                        _("Auto Response"),
                        '');
    echo '&nbsp;&nbsp;';

    bindtextdomain('squirrelmail', SM_PATH. 'locale');
    textdomain('squirrelmail');
}


/**
 * autorespond_info()
 * 
 * @returns array with various bits of information about the plugin.
 * Thanks to Paul Lesniewski for the example in the compatibility plugin.
 * 
 * Each element in the array is an info parameter.  Elements may be of any type.
 */
function autorespond_info()
{
    return array(
	'english_name' => 'Autorespond',
	'authors' => array(
	    'O\'Shaughnessy Evans' => array('email' => 'shaug-sqml@wumpus.org'),
	),
	'version' => '0.5.1',
	'required_sm_version' => '1.4',
	'requires_configuration' => 1,
	'requires_source_patch' => 0,
	'required_plugins' => array(),
	'summary' => 'Uses FTP to maintain vacation and forward files in '.
	             'the same page.',
	'details' => 'Autorespond is Yet Another vacation and forwarding '.
	             'plugin.  It lets you modify your vacation message and '.
		     'forwarding address and toggle either one on or off, '.
		     'and it will also let you toggle whether to keep a local '.
		     'copy.  It\'s FTP-based, so your system will need to '.
		     'provide FTP access to accounts via the IMAP login names.',
    );
}


/**
 * autorespond_version()
 * 
 * @returns string identifying the plugin's version number.
 */
function autorespond_version()
{
    $info = autorespond_info();
    return $info['version'];
}

?>
