/************************************************************************************

	AstroMenace
	Hardcore 3D space scroll-shooter with spaceship upgrade possibilities.
	Copyright (c) 2006-2019 Mikhail Kurinnoi, Viewizard


	AstroMenace is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	AstroMenace is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with AstroMenace. If not, see <https://www.gnu.org/licenses/>.


	Website: https://viewizard.com/
	Project: https://github.com/viewizard/astromenace
	E-mail: viewizard@viewizard.com

*************************************************************************************/

#ifndef ASSETS_MODEL3D_H
#define ASSETS_MODEL3D_H

#include "../core/base.h"

namespace viewizard {

struct sModel3D;

namespace astromenace {

// Get all model3d assets load value.
unsigned GetModel3DAssetsLoadValue();
// Cycle with function callback on each model3d asset load.
void ForEachModel3DAssetLoad(std::function<void (unsigned AssetValue)> function);
// Get preloaded model3d asset (preloaded by ForEachModel3DAssetLoad() call).
std::weak_ptr<sModel3D> GetPreloadedModel3DAsset(const std::string &FileName);

} // astromenace namespace
} // viewizard namespace

#endif // ASSETS_MODEL3D_H
