/*
 * Asterisk -- A telephony toolkit for Linux.
 *
 * saycountpl application
 * 
 * Copyright (C) 2004, Andy Powell & TAAN Softworks Corp. 
 *
 */

#include <asterisk.h>
#include <asterisk/file.h>
#include <asterisk/logger.h>
#include <asterisk/channel.h>
#include <asterisk/pbx.h>
#include <asterisk/module.h>
#include <asterisk/lock.h>
#include <asterisk/app.h>

static char *app = "SayCountPL";

static char *synopsis = "Say Polish counting words";

static char *descrip =
"Polish grammar has some funny rules for counting words. for example 1 zloty,\n"
"2 zlote, 5 zlotych. This application will take the words for 1, 2-4 and 5 and\n"
"decide based on grammar rules which one to use with the number you pass to it.\n\n"
"Example: SayCountPL(zloty,zlote,zlotych,122) will give: zlote\n";

static int saywords(struct ast_channel *chan, char *word1, char *word2, char *word5, int num)
{
	/* Put this in a separate proc because it's bound to change */
	int d = 0;

	if (num > 0) {
		if (num % 1000 == 1) {
			ast_streamfile(chan, word1, chan->language);
			d = ast_waitstream(chan,"");
		} else if (((num % 10) >= 2) && ((num % 10) <= 4 ) && ((num % 100) < 10 || (num % 100) > 20)) {
			ast_streamfile(chan, word2, chan->language);
			d = ast_waitstream(chan, "");
		} else {
			ast_streamfile(chan, word5, chan->language);
			d = ast_waitstream(chan, "");
		}
	}

	return d;
}


static int sayword_exec(struct ast_channel *chan, void *data)
{
	int res = 0;
	char *s;
	int inum;
	AST_DECLARE_APP_ARGS(args,
		AST_APP_ARG(word1);
		AST_APP_ARG(word2);
		AST_APP_ARG(word5);
		AST_APP_ARG(num);
	);

	if (!data) {
		ast_log(LOG_WARNING, "SayCountPL requires 4 arguments: word-1,word-2,word-5,number\n");
		return -1;
	}

	s = ast_strdupa(data);

	AST_STANDARD_APP_ARGS(args, s);

	/* Check to see if params passed */
	if (!args.word1 || !args.word2 || !args.word5 || !args.num) {
		ast_log(LOG_WARNING, "SayCountPL requires 4 arguments: word-1,word-2,word-3,number\n");
		return -1;
	}

	if (sscanf(args.num, "%d", &inum) != 1) {
		ast_log(LOG_WARNING, "'%s' is not a valid number\n", args.num);
		return -1;
	}

	/* do the saying part (after a bit of maths) */

	res = saywords(chan, args.word1, args.word2, args.word5, inum);

	return res;
}

static int unload_module(void)
{
	return ast_unregister_application(app);
}

static int load_module(void)
{
	return ast_register_application(app, sayword_exec, synopsis, descrip);
}

AST_MODULE_INFO_STANDARD(ASTERISK_GPL_KEY, "Say polish counting words");
