/*
 * Copyright (c) 1990, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2009, 2010, 2013
 * The Regents of the University of California. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University nor the names of its contributors
 *       may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef lint
static const char rcsid[] =
    "@(#) $Id: file.c 1244 2013-11-18 05:39:46Z leres $ (LBL)";
#endif

/*
 * file - arpwatch file i/o routines
 */

#include <sys/types.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/time.h>

#if __STDC__
struct mbuf;
struct rtentry;
#endif
#include <net/if.h>

#include <netinet/in.h>

#include <arpa/inet.h>

#include <ctype.h>
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include "ec.h"
#include "file.h"
#include "util.h"

int
file_loop(FILE *f, file_process fn, const char *name)
{
	int n;
	char *cp, *cp2, *h;
	u_int32_t a;
	time_t t;
#ifdef notdef
	struct hostent *hp;
#endif
	char line[1024];
	u_char e[6];

	n = 0;
	while (fgets(line, sizeof(line), f)) {
		++n;
		cp = line;
		cp2 = cp + strlen(cp) - 1;
		if (cp2 >= cp && *cp2 == '\n')
			*cp2++ = '\0';
		if (*cp == '#')
			continue;
		if ((cp2 = strchr(cp, '\t')) == NULL) {
			lg(LOG_ERR, "file_loop: %s:%d syntax error #1",
			    name, n);
fprintf(stderr, "file_loop: %s:%d syntax error #1\n", name, n);
			continue;
		}

		/* Ethernet address comes first */
		*cp2++ = '\0';
		if (!str2e(cp, e)) {
			lg(LOG_ERR, "file_loop: %s:%d bad ether addr \"%s\"",
			    name, n, cp);
fprintf(stderr, "file_loop: %s:%d bad ether addr \"%s\"\n", name, n, cp);
			continue;
		}

		/* ip address is next */
		cp = cp2;
		if ((cp2 = strchr(cp, '\t')) != NULL)
			*cp2++ = '\0';
		if (!isdigit((int)*cp) || (int32_t)(a = inet_addr(cp)) == -1) {
#ifndef notdef
			lg(LOG_ERR, "file_loop: %s:%d bad ip address \"%s\"",
			    name, n, cp);
fprintf(stderr, "file_loop: %s:%d bad ip address \"%s\"\n", name, n, cp);
			continue;
		
#else
			if ((hp = gethostbyname(cp)) == NULL) {
				lg(LOG_ERR,
				    "file_loop: %s:%d bad hostname \"%s\"",
				    name, n, cp);
fprintf(stderr, "file_loop: %s:%d bad hostname \"%s\"\n", name, n, cp);
				continue;
			}
			memmove(&a, hp->h_addr, 4);
#endif
		}

		/* timestamp and hostname are optional */
		if (cp2 == NULL) {
			t = 0;
			h = NULL;
		} else {
			t = atoi(cp2);
			h = strchr(cp2, '\t');
			if (h != NULL) {
				++h;
				cp2 = h;
				while (*cp2 != '\n' && *cp2 != '\t' &&
				    *cp2 != '\0')
					++cp2;
				*cp2 = '\0';
			}
		}

		if (!(*fn)(a, e, t, h))
			return(0);
	}

	return(1);
}
