dnl @(#) $Id: aclocal.m4 1416 2018-11-21 06:52:50Z leres $ (LBL)
dnl
dnl Copyright (c) 2009, 2010, 2011, 2013, 2016, 2019
dnl  The Regents of the University of California. All rights reserved.
dnl
dnl  Redistribution and use in source and binary forms, with or without
dnl  modification, are permitted provided that the following conditions are met:
dnl      * Redistributions of source code must retain the above copyright
dnl        notice, this list of conditions and the following disclaimer.
dnl      * Redistributions in binary form must reproduce the above copyright
dnl        notice, this list of conditions and the following disclaimer in the
dnl        documentation and/or other materials provided with the distribution.
dnl      * Neither the name of the University nor the names of its contributors
dnl        may be used to endorse or promote products derived from this software
dnl        without specific prior written permission.
dnl
dnl  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
dnl  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
dnl  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
dnl  ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
dnl  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
dnl  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
dnl  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
dnl  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
dnl  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
dnl  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
dnl  SUCH DAMAGE.
dnl
dnl LBL autoconf macros
dnl

dnl
dnl Determine which compiler we're using (cc or gcc)
dnl If using gcc, determine the version number
dnl If using cc, require that it support ansi prototypes
dnl Always explicitly specify /usr/local/include and /usr/local/lib
dnl (It's too difficult to tell when we might need them!)
dnl
dnl usage:
dnl
dnl	AC_LBL_C_INIT(copt, incls)
dnl
dnl results:
dnl
dnl	$1 (copt set)
dnl	$2 (incls set)
dnl	CC
dnl	LDFLAGS set
dnl
AC_DEFUN(AC_LBL_C_INIT,
    [AC_PREREQ(2.12)
    AC_ARG_ENABLE([optimization],
	[AS_HELP_STRING([--disable-optimization],
	    [turn off gcc optimization])],
	ac_cv_enable_optimization=${enableval})
    AC_BEFORE([$0], [AC_PROG_CC])
    AC_BEFORE([$0], [AC_LBL_FIXINCLUDES])
    AC_BEFORE([$0], [AC_LBL_DEVEL])
    AC_ARG_WITH(gcc, [  --without-gcc           don't use gcc])
    AC_USE_SYSTEM_EXTENSIONS
    AC_PROG_CC
    AC_SYS_LARGEFILE
    $1=""
    if test "${ac_cv_enable_optimization}" = "no"; then
	    CFLAGS="`echo ${CFLAGS} | sed -e 's/ -O[[0-3]]*//'`"
    fi
    $2=""
    if test "${srcdir}" != "." ; then
	    $2="-I\$\(srcdir\)"
    fi
    if test -z "$CC" ; then
	    case "$target_os" in

	    bsdi*)
		    AC_CHECK_PROG(SHLICC2, shlicc2, yes, no)
		    if test $SHLICC2 = yes ; then
			    CC=shlicc2
			    export CC
		    fi
		    ;;
	    esac
    fi
    if test -z "$CC" -a "$with_gcc" = no ; then
	    CC=cc
	    export CC
    fi
    $2="$$2 -I/usr/local/include"
    LDFLAGS="$LDFLAGS -L/usr/local/lib"
    if test "$GCC" != yes ; then
	    AC_MSG_CHECKING(that $CC handles ansi prototypes)
	    AC_CACHE_VAL(ac_cv_lbl_cc_ansi_prototypes,
		AC_TRY_COMPILE(
		    [#include <sys/types.h>],
		    [int frob(int, char *)],
		    ac_cv_lbl_cc_ansi_prototypes=yes,
		    ac_cv_lbl_cc_ansi_prototypes=no))
	    AC_MSG_RESULT($ac_cv_lbl_cc_ansi_prototypes)
	    if test $ac_cv_lbl_cc_ansi_prototypes = no ; then
		    case "$target_os" in

		    hpux*)
			    AC_MSG_CHECKING(for HP-UX ansi compiler ($CC -Aa -D_HPUX_SOURCE))
			    savedcflags="$CFLAGS"
			    CFLAGS="-Aa -D_HPUX_SOURCE $CFLAGS"
			    AC_CACHE_VAL(ac_cv_lbl_cc_hpux_cc_aa,
				AC_TRY_COMPILE(
				    [#include <sys/types.h>],
				    [int frob(int, char *)],
				    ac_cv_lbl_cc_hpux_cc_aa=yes,
				    ac_cv_lbl_cc_hpux_cc_aa=no))
			    AC_MSG_RESULT($ac_cv_lbl_cc_hpux_cc_aa)
			    if test $ac_cv_lbl_cc_hpux_cc_aa = no ; then
				    AC_MSG_ERROR(see the INSTALL doc for more info)
			    fi
			    CFLAGS="$savedcflags"
			    $1="-Aa $$1"
			    AC_DEFINE(_HPUX_SOURCE,,[HP-UX ansi compiler])
			    ;;

		    *)
			    AC_MSG_ERROR(see the INSTALL doc for more info)
			    ;;
		    esac
	    fi

	    case "$target_os" in

	    irix*)
		    $1="$$1 -xansi -signed -g3"
		    ;;

	    osf*)
		    $1="$$1 -std1 -g3"
		    ;;

	    ultrix*)
		    AC_MSG_CHECKING(that Ultrix $CC hacks const in prototypes)
		    AC_CACHE_VAL(ac_cv_lbl_cc_const_proto,
			AC_TRY_COMPILE(
			    [#include <sys/types.h>],
			    [struct a { int b; };
			    void c(const struct a *)],
			    ac_cv_lbl_cc_const_proto=yes,
			    ac_cv_lbl_cc_const_proto=no))
		    AC_MSG_RESULT($ac_cv_lbl_cc_const_proto)
		    if test $ac_cv_lbl_cc_const_proto = no ; then
			    AC_DEFINE(const,,[ultrix can't hack const])
		    fi
		    ;;
	    esac
    fi
])

AC_LBL_ENABLE_CHECK(brov6 activemapping expire-dfa-states)
dnl
dnl This allows us to check for bogus configure enable/disable
dnl command line options
dnl
dnl usage:
dnl
dnl	AC_LBL_ENABLE_CHECK(opt ...)
dnl
AC_DEFUN(AC_LBL_ENABLE_CHECK,
    [set |
	sed -n -e 's/^enable_\([[^=]]*\)=[[^=]]*$/\1/p' |
	while read var; do
	    ok=0
	    for o in $1; do
		    if test "${o}" = "${var}" ; then
			    ok=1
			    break
		    fi
	    done
	    if test ${ok} -eq 0 ; then
		    # It's hard to kill configure script from subshell!
		    AC_MSG_ERROR(unknown enable option: ${var})
		    exit 1
	    fi
	done
	if test $? -ne 0 ; then
		exit 1
	fi])

dnl
dnl Use pfopen.c if available and pfopen() not in standard libraries
dnl Require libpcap
dnl Look for libpcap in ..
dnl Use the installed libpcap if there is no local version
dnl
dnl usage:
dnl
dnl	AC_LBL_LIBPCAP(pcapdep, incls)
dnl
dnl results:
dnl
dnl	$1 (pcapdep set)
dnl	$2 (incls appended)
dnl	LIBS
dnl	LDFLAGS
dnl	LBL_LIBS
dnl
AC_DEFUN(AC_LBL_LIBPCAP,
    [AC_REQUIRE([AC_LBL_LIBRARY_NET])
    dnl
    dnl save a copy before locating libpcap.a
    dnl
    LBL_LIBS="$LIBS"
    pfopen=/usr/examples/packetfilter/pfopen.c
    if test -f $pfopen ; then
	    AC_CHECK_FUNCS(pfopen)
	    if test $ac_cv_func_pfopen = "no" ; then
		    AC_MSG_RESULT(Using $pfopen)
		    LIBS="$LIBS $pfopen"
	    fi
    fi
    AC_MSG_CHECKING(for local pcap library)
    libpcap=FAIL
    lastdir=FAIL
    places=`ls .. | sed -e 's,/$,,' -e 's,^,../,' | \
	egrep '/libpcap-[[0-9]]*\.[[0-9]]*(\.[[0-9]]*)?([[ab]][[0-9]]*)?$'`
    for dir in $places ../libpcap libpcap ; do
	    basedir=`echo $dir | sed -e 's/[[ab]][[0-9]]*$//'`
	    if test $lastdir = $basedir ; then
		    dnl skip alphas when an actual release is present
		    continue;
	    fi
	    lastdir=$dir
	    if test -r $dir/pcap.c ; then
		    libpcap=$dir/libpcap.a
		    d=$dir
		    dnl continue and select the last one that exists
	    fi
    done
    if test "x$libpcap" = xFAIL ; then
	    AC_MSG_RESULT(not found)
	    AC_CHECK_LIB(pcap, pcap_open_live, libpcap="-lpcap")
	    unset ac_cv_lib_pcap_pcap_open_live
	    if test "x$libpcap" = xFAIL ; then
		    AC_CHECK_LIB(pcap, pcap_open_live, libpcap="-lpcap")
		    unset ac_cv_lib_pcap_pcap_open_live
		    if test "x$libpcap" = xFAIL ; then
			    AC_MSG_ERROR(see the INSTALL doc for more info)
		    fi
	    fi
	    LIBS="$LIBS -lpcap"
    else
	    $1=$libpcap
	    $2="-I$d $$2"
	    AC_MSG_RESULT($libpcap)
    fi
    if test "x$libpcap" != "x-lpcap" ; then
	    LIBS="$libpcap $LIBS"
    fi
    case "$target_os" in

    aix*)
	    pseexe="/lib/pse.exp"
	    AC_MSG_CHECKING(for $pseexe)
	    if test -f $pseexe ; then
		    AC_MSG_RESULT(yes)
		    LIBS="$LIBS -I:$pseexe"
	    fi
	    ;;
    esac

    dnl
    dnl Foo: pcap_lookupdev() deprecation mess
    dnl
    AC_CHECK_FUNCS(pcap_findalldevs)])

dnl
dnl Define RETSIGTYPE and RETSIGVAL
dnl
dnl usage:
dnl
dnl	AC_LBL_TYPE_SIGNAL
dnl
dnl results:
dnl
dnl	RETSIGTYPE (defined)
dnl	RETSIGVAL (defined)
dnl
AC_DEFUN(AC_LBL_TYPE_SIGNAL,
    [AC_BEFORE([$0], [AC_LBL_LIBPCAP])
    AC_TYPE_SIGNAL
    if test "$ac_cv_type_signal" = void ; then
	    AC_DEFINE(RETSIGVAL,,[signal function return value])
    else
	    AC_DEFINE(RETSIGVAL,(0))
    fi
    case "$target_os" in

    irix*)
	    AC_DEFINE(_BSD_SIGNALS,,[irix's BSD style signals])
	    ;;

    *)
	    dnl prefer sigset() to sigaction()
	    AC_CHECK_FUNCS(sigset)
	    if test $ac_cv_func_sigset = yes ; then
		    AC_DEFINE(signal,sigset,[use sigset() instead of signal()])
	    else
		    AC_CHECK_FUNCS(sigaction)
	    fi
	    ;;
    esac])

dnl
dnl If using gcc, make sure we have ANSI ioctl definitions
dnl
dnl usage:
dnl
dnl	AC_LBL_FIXINCLUDES
dnl
AC_DEFUN(AC_LBL_FIXINCLUDES,
    [if test "$GCC" = yes ; then
	    AC_MSG_CHECKING(for ANSI ioctl definitions)
	    AC_CACHE_VAL(ac_cv_lbl_gcc_fixincludes,
		AC_TRY_COMPILE(
		    [/*
		     * This generates a "duplicate case value" when fixincludes
		     * has not be run.
		     */
#		include <sys/types.h>
#		include <sys/time.h>
#		include <sys/ioctl.h>
#		ifdef HAVE_SYS_IOCCOM_H
#		include <sys/ioccom.h>
#		endif],
		    [switch (0) {
		    case _IO('A', 1):;
		    case _IO('B', 1):;
		    }],
		    ac_cv_lbl_gcc_fixincludes=yes,
		    ac_cv_lbl_gcc_fixincludes=no))
	    AC_MSG_RESULT($ac_cv_lbl_gcc_fixincludes)
	    if test $ac_cv_lbl_gcc_fixincludes = no ; then
		    # Don't cache failure
		    unset ac_cv_lbl_gcc_fixincludes
		    AC_MSG_ERROR(see the INSTALL for more info)
	    fi
    fi])

dnl
dnl Check for flex, default to lex
dnl Require flex 2.4 or higher
dnl Check for bison, default to yacc
dnl Default to lex/yacc if both flex and bison are not available
dnl Define the yy prefix string if using flex and bison
dnl
dnl usage:
dnl
dnl	AC_LBL_LEX_AND_YACC(lex, yacc, yyprefix)
dnl
dnl results:
dnl
dnl	$1 (lex set)
dnl	$2 (yacc appended)
dnl	$3 (optional flex and bison -P prefix)
dnl
AC_DEFUN(AC_LBL_LEX_AND_YACC,
    [AC_ARG_WITH(flex, [  --without-flex          don't use flex])
    AC_ARG_WITH(bison, [  --without-bison         don't use bison])
    if test "$with_flex" = no ; then
	    $1=lex
    else
	    AC_CHECK_PROGS($1, flex, lex)
    fi
    if test "$$1" = flex ; then
	    # The -V flag was added in 2.4
	    AC_MSG_CHECKING(for flex 2.4 or higher)
	    AC_CACHE_VAL(ac_cv_lbl_flex_v24,
		if flex -V >/dev/null 2>&1; then
			ac_cv_lbl_flex_v24=yes
		else
			ac_cv_lbl_flex_v24=no
		fi)
	    AC_MSG_RESULT($ac_cv_lbl_flex_v24)
	    if test $ac_cv_lbl_flex_v24 = no ; then
		    s="2.4 or higher required"
		    AC_MSG_WARN(ignoring obsolete flex executable ($s))
		    $1=lex
	    fi
    fi
    if test "$with_bison" = no ; then
	    $2=yacc
    else
	    AC_CHECK_PROGS($2, bison, yacc)
    fi
    if test "$$2" = bison ; then
	    $2="$$2 -y"
    fi
    if test "$$1" != lex -a "$$2" = yacc -o "$$1" = lex -a "$$2" != yacc ; then
	    AC_MSG_WARN(don't have both flex and bison; reverting to lex/yacc)
	    $1=lex
	    $2=yacc
    fi
    if test "$$1" = flex -a -n "$3" ; then
	    $1="$$1 -P$3"
	    $2="$$2 -p $3"
    fi])

dnl
dnl Checks to see if union wait is used with WEXITSTATUS()
dnl
dnl usage:
dnl
dnl	AC_LBL_UNION_WAIT
dnl
dnl results:
dnl
dnl	DECLWAITSTATUS (defined)
dnl
AC_DEFUN(AC_LBL_UNION_WAIT,
    [AC_MSG_CHECKING(if union wait is used)
    AC_CACHE_VAL(ac_cv_lbl_union_wait,
	AC_TRY_COMPILE([
#	include <sys/types.h>
#	include <sys/wait.h>],
	    [int status;
	    u_int i = WEXITSTATUS(status);
	    u_int j = waitpid(0, &status, 0);],
	    ac_cv_lbl_union_wait=no,
	    ac_cv_lbl_union_wait=yes))
    AC_MSG_RESULT($ac_cv_lbl_union_wait)
    if test $ac_cv_lbl_union_wait = yes ; then
	    AC_DEFINE(DECLWAITSTATUS,union wait)
    else
	    AC_DEFINE(DECLWAITSTATUS,int)
    fi])

dnl
dnl Checks to see if the sockaddr struct has the 4.4 BSD sa_len member
dnl
dnl usage:
dnl
dnl	AC_LBL_SOCKADDR_SA_LEN
dnl
dnl results:
dnl
dnl	HAVE_SOCKADDR_SA_LEN (defined)
dnl
AC_DEFUN(AC_LBL_SOCKADDR_SA_LEN,
    [AC_CHECK_MEMBERS(struct sockaddr.sa_len,
	AC_DEFINE(HAVE_SOCKADDR_SA_LEN),,[
#	include <sys/types.h>
#	include <sys/socket.h>])])

dnl
dnl Makes sure socklen_t is defined
dnl
dnl usage:
dnl
dnl	AC_LBL_SOCKLEN_T
dnl
dnl results:
dnl
dnl	socklen_t (defined if missing)
dnl
AC_DEFUN(AC_LBL_SOCKLEN_T,
    [AC_MSG_CHECKING(for socklen_t in sys/socket.h using $CC)
    AC_CACHE_VAL(ac_cv_lbl_socklen_t,
	AC_TRY_COMPILE([
#	include "confdefs.h"
#	include <sys/types.h>
#	include <sys/socket.h>
#	if STDC_HEADERS
#	include <stdlib.h>
#	include <stddef.h>
#	endif],
	[socklen_t i],
	ac_cv_lbl_socklen_t=yes,
	ac_cv_lbl_socklen_t=no))
    AC_MSG_RESULT($ac_cv_lbl_socklen_t)
    if test $ac_cv_lbl_socklen_t = no ; then
	    AC_DEFINE(socklen_t, int, [Define socklen_t if missing])
    fi])

dnl
dnl Checks to see if the IFF_LOOPBACK exists as a define or enum
dnl
dnl   (stupidly some versions of linux use an enum...)
dnl
dnl usage:
dnl
dnl	AC_LBL_IFF_LOOPBACK
dnl
dnl results:
dnl
dnl	HAVE_IFF_LOOPBACK (defined)
dnl
AC_DEFUN(AC_LBL_IFF_LOOPBACK,
    [AC_MSG_CHECKING(for IFF_LOOPBACK define/enum)
    AC_CACHE_VAL(ac_cv_lbl_have_iff_loopback,
	AC_TRY_COMPILE([
#	include <sys/param.h>
#	include <sys/file.h>
#	include <sys/ioctl.h>
#	include <sys/socket.h>
#	ifdef HAVE_SYS_SOCKIO_H
#	include <sys/sockio.h>
#	endif
#	include <sys/time.h>
#	include <net/if.h>
#	include <netinet/in.h>],
	[int i = IFF_LOOPBACK],
	ac_cv_lbl_have_iff_loopback=yes,
	ac_cv_lbl_have_iff_loopback=no))
    AC_MSG_RESULT($ac_cv_lbl_have_iff_loopback)
    if test $ac_cv_lbl_have_iff_loopback = yes ; then
	    AC_DEFINE(HAVE_IFF_LOOPBACK,, [Have IFF_LOOPBACK define/enum])
    fi])

dnl
dnl Due to the stupid way it's implemented, AC_CHECK_TYPE is nearly useless.
dnl
dnl usage:
dnl
dnl	AC_LBL_CHECK_TYPE
dnl
dnl results:
dnl
dnl	int32_t (defined)
dnl	u_int32_t (defined)
dnl
AC_DEFUN(AC_LBL_CHECK_TYPE,
    [AC_MSG_CHECKING(for $1 using $CC)
    AC_CACHE_VAL(ac_cv_lbl_have_$1,
	AC_TRY_COMPILE([
#	include "confdefs.h"
#	include <sys/types.h>
#	if STDC_HEADERS
#	include <stdlib.h>
#	include <stddef.h>
#	endif],
	[$1 i],
	ac_cv_lbl_have_$1=yes,
	ac_cv_lbl_have_$1=no))
    AC_MSG_RESULT($ac_cv_lbl_have_$1)
    if test $ac_cv_lbl_have_$1 = no ; then
	    AC_DEFINE($1, $2, Define $1)
    fi])

dnl
dnl Checks to see if unaligned memory accesses fail
dnl
dnl usage:
dnl
dnl	AC_LBL_UNALIGNED_ACCESS
dnl
dnl results:
dnl
dnl	LBL_ALIGN (DEFINED)
dnl
AC_DEFUN(AC_LBL_UNALIGNED_ACCESS,
    [AC_MSG_CHECKING(if unaligned accesses fail)
    AC_CACHE_VAL(ac_cv_lbl_unaligned_fail,
	[case "$target_cpu" in

	alpha|hp*|mips|sparc)
		ac_cv_lbl_unaligned_fail=yes
		;;

	*)
		cat >conftest.c <<EOF
#		include <sys/types.h>
#		include <sys/wait.h>
#		include <stdio.h>
		unsigned char a[[5]] = { 1, 2, 3, 4, 5 };
		main() {
		unsigned int i;
		pid_t pid;
		int status;
		/* avoid "core dumped" message */
		pid = fork();
		if (pid <  0)
			exit(2);
		if (pid > 0) {
			/* parent */
			pid = waitpid(pid, &status, 0);
			if (pid < 0)
				exit(3);
			exit(!WIFEXITED(status));
		}
		/* child */
		i = *(unsigned int *)&a[[1]];
		printf("%d\n", i);
		exit(0);
		}
EOF
		${CC-cc} -o conftest $CFLAGS $CPPFLAGS $LDFLAGS \
		    conftest.c $LIBS >/dev/null 2>&1
		if test ! -x conftest ; then
			dnl failed to compile for some reason
			ac_cv_lbl_unaligned_fail=yes
		else
			./conftest >conftest.out
			if test ! -s conftest.out ; then
				ac_cv_lbl_unaligned_fail=yes
			else
				ac_cv_lbl_unaligned_fail=no
			fi
		fi
		rm -f conftest* core core.conftest
		;;
	esac])
    AC_MSG_RESULT($ac_cv_lbl_unaligned_fail)
    if test $ac_cv_lbl_unaligned_fail = yes ; then
	    AC_DEFINE(LBL_ALIGN)
    fi])

dnl
dnl add all warning option to CFLAGS
dnl
dnl usage:
dnl
dnl	AC_LBL_CHECK_WALL
dnl
dnl results:
dnl
dnl	CFLAGS (appended)
dnl	ac_cv_lbl_gcc_vers
dnl
AC_DEFUN(AC_LBL_CHECK_WALL,
    [ if test "$GCC" = yes ; then
	    CFLAGS="${CFLAGS} -Wall -Wmissing-prototypes -Wstrict-prototypes -Wno-unused-const-variable"
	    if [[ "`uname -s`" = "FreeBSD" ]]; then
		    CFLAGS="${CFLAGS} -Werror"
	    fi

	    AC_MSG_CHECKING([if $CC supports -Wunused-const-variable])
	    AC_CACHE_VAL(ac_cv_lbl_cc_unused_const_variable,
		savedcflags="$CFLAGS"
		CFLAGS="${CFLAGS} -Wunused-const-variable"
		AC_TRY_COMPILE(,
		    [int frob()],
		    ac_cv_lbl_cc_unused_const_variable=yes,
		    ac_cv_lbl_cc_unused_const_variable=no))
		CFLAGS="${savedcflags}"
	    AC_MSG_RESULT($ac_cv_lbl_cc_unused_const_variable)
	    if test $ac_cv_lbl_cc_unused_const_variable = yes ; then
		    CFLAGS="${CFLAGS} -Wno-unused-const-variable"
	    fi
    fi])

dnl
dnl If --enable-debug:
dnl
dnl	If an os prototype include exists, symlink os-proto.h to it
dnl	If gcc (or compatible) Compile with:
dnl
dnl		-Wall -Wmissing-prototypes -Wstrict-prototypes
dnl
dnl usage:
dnl
dnl	AC_LBL_DEVEL
dnl
dnl results:
dnl
dnl	$1 (appended)
dnl	HAVE_OS_PROTO_H (defined)
dnl	os-proto.h (symlinked)
dnl
AC_DEFUN(AC_LBL_DEVEL,[
    AC_BEFORE([$0], [AC_LBL_LD_RUN_PATH])
    AC_ARG_ENABLE([debug],
	[AS_HELP_STRING([--enable-debug],
	    [enable debugging @<:@default=no@:>@])],
	ac_cv_enable_debug=${enableval})

    rm -f os-proto.h
    if test "${ac_cv_enable_debug}" = yes ; then
	    AC_LBL_CHECK_WALL
	    os=`echo $target_os | sed -e 's/\([[0-9]][[0-9]]*\)[[^0-9]].*$/\1/'`
	    name="lbl/os-$os.h"
	    if test -f $name ; then
		    ln -s $name os-proto.h
		    AC_DEFINE(HAVE_OS_PROTO_H,,[have os-proto.h])
	    fi
    fi])

dnl
dnl Improved version of AC_CHECK_LIB
dnl
dnl Thanks to John Hawkinson (jhawk@mit.edu)
dnl
dnl usage:
dnl
dnl	AC_LBL_CHECK_LIB(LIBRARY, FUNCTION [, ACTION-IF-FOUND [,
dnl	    ACTION-IF-NOT-FOUND [, OTHER-LIBRARIES]]])
dnl
dnl results:
dnl
dnl	LIBS
dnl

define(AC_LBL_CHECK_LIB,
[AC_MSG_CHECKING([for $2 in -l$1])
dnl Use a cache variable name containing both the library and function name,
dnl because the test really is for library $1 defining function $2, not
dnl just for library $1.  Separate tests with the same $1 and different $2's
dnl may have different results.
ac_lib_var=`echo $1['_']$2['_']$5 | sed 'y%./+- %__p__%'`
AC_CACHE_VAL(ac_cv_lbl_lib_$ac_lib_var,
[ac_save_LIBS="$LIBS"
LIBS="-l$1 $5 $LIBS"
AC_TRY_LINK(dnl
ifelse([$2], [main], , dnl Avoid conflicting decl of main.
[/* Override any gcc2 internal prototype to avoid an error.  */
]ifelse(AC_LANG, CPLUSPLUS, [#ifdef __cplusplus
extern "C"
#endif
])dnl
[/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $2();
]),
	    [$2()],
	    eval "ac_cv_lbl_lib_$ac_lib_var=yes",
	    eval "ac_cv_lbl_lib_$ac_lib_var=no")
LIBS="$ac_save_LIBS"
])dnl
if eval "test \"`echo '$ac_cv_lbl_lib_'$ac_lib_var`\" = yes"; then
  AC_MSG_RESULT(yes)
  ifelse([$3], ,
[changequote(, )dnl
  ac_tr_lib=HAVE_LIB`echo $1 | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
changequote([, ])dnl
  AC_DEFINE_UNQUOTED($ac_tr_lib)
  LIBS="-l$1 $LIBS"
], [$3])
else
  AC_MSG_RESULT(no)
ifelse([$4], , , [$4
])dnl
fi
])

dnl
dnl AC_LBL_LIBRARY_NET
dnl
dnl This test is for network applications that need socket() and
dnl gethostbyname() -ish functions.  Under Solaris, those applications
dnl need to link with "-lsocket -lnsl".  Under IRIX, they need to link
dnl with "-lnsl" but should *not* link with "-lsocket" because
dnl libsocket.a breaks a number of things (for instance:
dnl gethostbyname() under IRIX 5.2, and snoop sockets under most
dnl versions of IRIX).
dnl
dnl Unfortunately, many application developers are not aware of this,
dnl and mistakenly write tests that cause -lsocket to be used under
dnl IRIX.  It is also easy to write tests that cause -lnsl to be used
dnl under operating systems where neither are necessary (or useful),
dnl such as SunOS 4.1.4, which uses -lnsl for TLI.
dnl
dnl This test exists so that every application developer does not test
dnl this in a different, and subtly broken fashion.

dnl It has been argued that this test should be broken up into two
dnl seperate tests, one for the resolver libraries, and one for the
dnl libraries necessary for using Sockets API. Unfortunately, the two
dnl are carefully intertwined and allowing the autoconf user to use
dnl them independantly potentially results in unfortunate ordering
dnl dependancies -- as such, such component macros would have to
dnl carefully use indirection and be aware if the other components were
dnl executed. Since other autoconf macros do not go to this trouble,
dnl and almost no applications use sockets without the resolver, this
dnl complexity has not been implemented.
dnl
dnl The check for libresolv is in case you are attempting to link
dnl statically and happen to have a libresolv.a lying around (and no
dnl libnsl.a).
dnl
AC_DEFUN(AC_LBL_LIBRARY_NET, [
    dnl Most operating systems have gethostbyname() in the default searched
    dnl libraries (i.e. libc):
    AC_CHECK_FUNC([gethostbyname])
    if test ${ac_cv_func_gethostbyname} = "no" ; then
	dnl Some OSes (eg. Solaris) place it in libnsl:
	AC_CHECK_LIB([nsl], [gethostbyname])
	if test ${ac_cv_lib_nsl_gethostbyname} = "no" ; then
	    dnl Some strange OSes [SINIX] have it in libsocket:
	    AC_CHECK_LIB([socket], [gethostbyname])
	    if test ${ac_cv_lib_socket_gethostbyname} = "no" ; then
		dnl Unfortunately libsocket sometimes depends on libnsl.
		dnl AC_CHECK_LIB's API is essentially broken so the
		dnl following ugliness is necessary:
		dnl (clear cache)
		unset ac_cv_lib_socket_gethostbyname
		AC_CHECK_LIB([socket], [gethostbyname],
		    LIBS="-lsocket -lnsl $LIBS", , -nsl)
		if test ${ac_cv_lib_socket_gethostbyname} = "no" ; then
		    AC_CHECK_LIB([resolv], [gethostbyname])
		fi
	    fi
	fi
	AC_CHECK_FUNC([socket])
	if test ${ac_cv_func_socket} = "no" ; then
	    AC_CHECK_LIB([socket], [socket])
	    if test ${ac_cv_lib_socket_socket} = "no" ; then
		dnl (clear cache)
		unset ac_cv_lib_socket_socket
		AC_CHECK_LIB([socket], [socket], LIBS="-lsocket -lnsl $LIBS", ,
		    -lnsl)
	    fi
	fi
	dnl DLPI needs putmsg under HPUX so test for -lstr while we're at it
	AC_CHECK_LIB(str, putmsg)
    fi])

dnl
dnl AC_LBL_RUN_PATH
dnl
dnl Extracts -L directories from LIBS; if any are found they are
dnl converted to a LD_RUN_PATH and put in V_ENVIRONMENT
dnl
dnl usage:
dnl
dnl	AC_LBL_RUN_PATH
dnl
dnl results:
dnl
dnl	V_ENVIRONMENT
dnl
AC_DEFUN(AC_LBL_LD_RUN_PATH, [
	AC_MSG_CHECKING(LD_RUN_PATH)
	AC_SUBST(V_ENVIRONMENT)
	dnl
	dnl Split out -L directories (once each)
	dnl
	ldirs=""
	for x in ${LIBS}; do
		case ${x} in

		-L*)
			key="${x##-L}"
			key="we_saw_lib`echo ${key} | sed -e 's,/,_,g'`"
			eval "val=\${${key}}"
			if test X${val} = X; then
				ldirs="${ldirs} ${x}"
			fi
			eval "${key}=1"
			;;

		*)
			;;
		esac
	done

	dnl
	dnl Build ld_run_path (put existing dirs first)
	dnl
	ld_run_path=""
	if test -n "${ldirs}"; then
		ld_run_path="`echo \"${ldirs}\" | sed -e 's,-L,,g' -e 's,^ *,,' -e 's, ,:,g'`"
		if test -n "${LD_RUN_PATH}"; then
			ld_run_path="${LD_RUN_PATH}:${ld_run_path}"
		fi
	elif test -n "${LD_RUN_PATH}"; then
		ld_run_path="${LD_RUN_PATH}"
	fi
	dnl
	dnl Build V_ENVIRONMENT
	dnl
	if test -n "${ld_run_path}"; then
		V_ENVIRONMENT="LD_RUN_PATH=\"${ld_run_path}\""
		AC_MSG_RESULT(${V_ENVIRONMENT})
	else
		AC_MSG_RESULT(empty)
	fi])

dnl
dnl AC_LBL_BROCCOLI
dnl
dnl Include Broccoli support
dnl
dnl usage:
dnl
dnl	AC_LBL_BROCCOLI(copt, incls, [min-vers])
dnl
dnl results:
dnl
dnl	$1 (copt variable appended)
dnl	$2 (incls variable appended)
dnl	$3 minimum version (optional)
dnl     HAVE_BROCCOLI defined
dnl
AC_DEFUN(AC_LBL_BROCCOLI, [
    AC_BEFORE([$0], [AC_LBL_LD_RUN_PATH])
    dnl
    dnl configure flags
    dnl
    AC_ARG_WITH([broccoli],
	[AS_HELP_STRING([--without-broccoli],
	    [disable Broccoli support @<:@default=check@:>@])],
	ac_cv_with_broccoli=${withval})
    dnl
    dnl Network application libraries
    dnl
    AC_LBL_LIBRARY_NET

    AC_MSG_CHECKING(for broccoli)
    if test "${ac_cv_with_broccoli}" = "" -o \
	"${ac_cv_with_broccoli}" = yes ; then
	    cflags=""
	    libs=""
	    dnl
	    dnl Our entire path
	    dnl
	    dirs="`echo ${PATH} | sed -e 's/:/ /g'`"
	    dnl
	    dnl Add in default Bro install bin directory
	    dnl
	    dirs="${dirs} /usr/local/bro/bin"
	    for d in ${dirs}; do
		    if test -x ${d}/broccoli-config ; then
			    broccoli_config_path="${d}/broccoli-config"
			    cflags="`${broccoli_config_path} --cflags`"
			    libs="`${broccoli_config_path} --libs`"
			    break
		    fi
	    done
	    if test -n "${cflags}" ; then
		    ac_cv_have_broccoli=yes
	    else
		    ac_cv_have_broccoli=no
	    fi
	    AC_MSG_RESULT($ac_cv_have_broccoli)
	    if test "${ac_cv_with_broccoli}" = yes -a \
		${ac_cv_have_broccoli} = "no" ; then
		    AC_MSG_ERROR(Broccoli explicitly enabled but not supported)
	    fi
    else
	    AC_MSG_RESULT([disabled])
    fi

    dnl
    dnl Optionally check for minimum Broccoli version
    dnl
    if test "$ac_cv_have_broccoli" = yes -a -n "$3"; then
	    AC_MSG_CHECKING(Broccoli >= $3)
	    BROCCOLI_VERSION="`${broccoli_config_path} --version`"
	    AC_MSG_RESULT(${BROCCOLI_VERSION})

	    AS_VERSION_COMPARE(${BROCCOLI_VERSION}, $3,
		broccoli_ok="no", broccoli_ok="yes", broccoli_ok="yes")

	    if test "${broccoli_ok}" != "yes"; then
		    if test "${ac_cv_with_broccoli}" = yes; then
			    AC_MSG_ERROR(Broccoli $3 or higher is required)
		    fi
		    AC_MSG_NOTICE(Broccoli support disabled)
		    ac_cv_have_broccoli="no"
	    fi
	    v="1.5.0"
	    AS_VERSION_COMPARE(${BROCCOLI_VERSION}, ${v},
		lexer_ok="no", lexer_ok="no", lexer_ok="yes")
	    if test "${lexer_ok}" != "yes"; then
		    AC_MSG_WARN([Broccoli ${BROCCOLI_VERSION} has a ssl empty passphrase bug])
		    AC_MSG_WARN([(See the INSTALL file for patching instructions)])
	    fi
    fi

    dnl
    dnl Broccoli ho!
    dnl
    if test "$ac_cv_have_broccoli" = yes ; then
	    AC_DEFINE(HAVE_BROCCOLI)
	    dnl
	    dnl Split out -I directories
	    dnl
	    for x in ${cflags}; do
		    case x${x} in

		    x-I*)
			    eval "$2=\"\$$2 ${x}\""
			    ;;

		    *)
			    eval "$1=\"\$$1 ${x}\""
			    ;;
		    esac
	    done

	    dnl
	    dnl Add in Broccoli libs
	    dnl
	    LIBS="$LIBS ${libs}"

	    dnl
	    dnl Look for the libs in DIR or DIR/lib
	    dnl
	    AC_ARG_WITH([openssl],
		[AS_HELP_STRING([--with-openssl=DIR],
		[Use OpenSSL installation in DIR])],
		[eval "$2=\"-I${withval}/include \$$2\""
		for x in ${withval}/lib ${withval}; do
			if test -r ${x}/libssl.a; then
				LIBS="-L${x} ${LIBS}"
				break
			fi
		done])

	    dnl
	    dnl -lssl needs to come first on some systems!
	    dnl
	    AC_CHECK_LIB(ssl, OPENSSL_add_all_algorithms_conf,
		[LIBS="${LIBS} -lssl -lcrypto"],,-lcrypto)
	    dnl
	    dnl We can SSL failures if we have bro_init()
	    dnl
	    AC_CHECK_FUNCS([bro_init])
	    if test "x$ac_cv_func_bro_init" != xyes; then
		AC_MSG_WARN(SSL failures will not be detected)
	    fi
    fi])

dnl
dnl usage:
dnl
dnl	AC_LBL_ELECTRICFENCE
dnl
dnl results:
dnl
dnl	LIBS updated
dnl
AC_DEFUN(AC_LBL_ELECTRICFENCE, [
    AC_ARG_ENABLE([electricfence],
	[AS_HELP_STRING([--enable-electricfence],
	    [disable electric fence support @<:@default=no@:>@])],
	ac_cv_enable_electricfence=${enableval})

    if test "${ac_cv_enable_electricfence}" = yes ; then
	    AC_CHECK_LIB(efence, EF_Abort)
	    ac_save_LDFLAGS="$LDFLAGS"
	    if test $ac_cv_lib_efence_EF_Abort = no ; then
		    AC_MSG_ERROR(electricfence requested not available)
		    LDFLAGS="${ac_save_LDFLAGS}"
	    fi
    fi])

dnl
dnl Check if struct sockaddr_un has sun_len
dnl
AC_DEFUN(AC_SOCKADDR_SUN_LEN,[
	AC_MSG_CHECKING(whether sockaddr_un has sun_len)
	AC_CACHE_VAL(sc_cv_sockaddr_sun_len,
	[AC_TRY_COMPILE([#include <sys/types.h>
	#include <sys/un.h>],
	[struct sockaddr_un s_un; s_un.sun_len=0;],
	sc_cv_sockaddr_sun_len=yes, sc_cv_sockaddr_sun_len=no)])
	if test "$sc_cv_sockaddr_sun_len" = "yes"; then
		AC_DEFINE(HAVE_SOCKADDR_SUN_LEN)
	fi
	AC_MSG_RESULT($sc_cv_sockaddr_sun_len)])

dnl
dnl Put just the -I CFLAGS in LINTCFLAGS
dnl
AC_DEFUN(AC_LBL_LINTCFLAGS,[
	AC_SUBST(LINTCFLAGS)
	for x in -I/usr/include -I/usr/local/include ${CFLAGS}; do
		case ${x} in

		-I*)
			key="${x##-I}"
			key="we_saw_include_dir`echo ${key} | sed -e 's,/,_,g'`"
			eval "val=\${${key}}"
			if test X${val} = X; then
				LINTCFLAGS="${LINTCFLAGS} ${x}"
			fi
			eval "${key}=1"
			;;

		*)
			continue
			;;
		esac
	done])
