
#ifdef WIN32_NO_CONFIG_H
#ifndef _WIN32_
#define _WIN32_
#endif
#define WIN32_LEAN_AND_MEAN
#include "../winconf.h"
#else
#include "../config.h"
#endif
#include <sys/types.h>
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#else
#ifdef HAVE_WINSOCK_H
#include <winsock.h>
#endif
#endif
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <string.h>
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#include <antinat.h>
#include "../server/an_serv.h"

#define threads 5
SOCKADDR_IN srv;

#ifdef _WIN32_
#define sleep(x) Sleep(x*1000)
#endif

void * child(void * ignored)
{
    int s;
    int ret;
    unsigned char ver;
    unsigned char cmd;
    unsigned short port;
    unsigned long ip;
    while (1) {
        s=socket(PF_INET, SOCK_STREAM, 0);
        ret=connect(s, (SOCKADDR*)&srv, sizeof(srv));
        if (ret<0) 
            fprintf(stderr, "Could not connect, errno %x\n", errno);
        switch (rand()%5) {
            case 0:
            case 1:
                ver=4;
            break;
            case 2:
            case 3:
                ver=5;
            break;
            case 4:
                ver=rand()%0xff;
        }
        cmd = rand()%5;
        if (cmd==0) cmd=rand()%0xff;
        port = htons((unsigned short)(rand()%0xffff));
        if (rand()%5==0)
            ip = htonl(rand()%0xffffffff);
        else
            ip = htonl(0x7f000001);
        sleep(1);
        closesocket(s);
    }
    return NULL;
}

int
main ()
{
    int i;
    os_thread_t tid[threads];
    srv.sin_family=AF_INET;
    srv.sin_port=htons(1080);
    srv.sin_addr.s_addr=htonl(0x7f000001);
    for (i=0;i<threads;i++) {
        os_thread_exec(&tid[i], child, NULL);
    }
    sleep(3600 * 12);
	return EXIT_SUCCESS;
}
