@echo off
echo Detecting Microsoft C version...

if %OS%.==Windows_NT. goto MicrosoftCDetect
echo Cannot detect on this OS, using defaults...
goto LaunchMake95

:MicrosoftCDetect

set MSC_VER=Undetected
set MSC_ARCH=Undetected
set MSC_ED=Undetected

SET CUSTOMARG1=
SET CUSTOMARG2=
SET CUSTOMARG3=

cl >NUL 2>COutput
for /f "tokens=2 delims=+." %%i in (COutput) do (

	if "%%i"==" Optimizing Compiler Version 8" (
		SET MSC_VER=800
	) else if "%%i"==" Optimizing Compiler Version 9" (
		SET MSC_VER=900
		SET MSC_ED=pro
	) else if "%%i"==" Optimizing Compiler Version 10" (
		SET MSC_VER=1000
		SET MSC_ED=pro
	) else if "%%i"==" Standard Compiler Version 10" (
		SET MSC_VER=1000
		SET MSC_ED=std
	) else if "%%i"==" Optimizing Compiler Version 11" (
		SET MSC_VER=1100
		SET MSC_ED=pro
	) else if "%%i"==" Standard Compiler Version 11" (
		SET MSC_VER=1100
		SET MSC_ED=std
	) else if "%%i"==" Optimizing Compiler Version 12" (
		SET MSC_VER=1200
		SET MSC_ED=pro
	) else if "%%i"==" Standard Compiler Version 12" (
		SET MSC_VER=1200
		SET MSC_ED=std
	) else if "%%i"==" Optimizing Compiler Version 13" (
		SET MSC_VER=1310
		SET MSC_ED=pro
	) else if "%%i"==" Standard Compiler Version 13" (
		SET MSC_VER=1310
		SET MSC_ED=std
	) else if "%%i"==" Optimizing Compiler Version 14" (
		SET MSC_VER=1400
	) else if "%%i"==" Optimizing Compiler Version 15" (
		SET MSC_VER=1500
	) else if "%%i"==" Optimizing Compiler Version 16" (
		SET MSC_VER=1600
	) else if "%%i"==" Optimizing Compiler Version 17" (
		SET MSC_VER=1700
	) else if "%%i"==" Optimizing Compiler Version 18" (
		SET MSC_VER=1800
	)
)

for /f "tokens=9*" %%i in (COutput) do (
	rem x86 compilers inconveniently include "32-bit" where 64 bit ones do not.
	rem we have to account for this, which is why we use %%j for x86 and %%i for others.

	if "%%j"=="80x86" (
		SET MSC_ARCH=i386
	) else if "%%i"=="x64" (
		SET MSC_ARCH=x64
	) else if "%%i"=="Itanium" (
		SET MSC_ARCH=ia64
	)
)

rem This is where we really start guessing.  If we don't really know what the
rem compiler is, assume i386.

if "%MSC_ARCH%"=="Undetected" (
	set MSC_ARCH=i386
)

erase COutput

if not "%MSC_VER%"=="Undetected" SET CUSTOMARG1=MSC_VER=%MSC_VER%
if not "%MSC_ARCH%"=="Undetected" SET CUSTOMARG2=MSC_ARCH=%MSC_ARCH%
if not "%MSC_ED%"=="Undetected" SET CUSTOMARG3=MSC_ED=%MSC_ED%

echo nmake /nologo /f makefile.w32 %CUSTOMARG1% %CUSTOMARG2% %CUSTOMARG3% %*
nmake /nologo /f makefile.w32 %CUSTOMARG1% %CUSTOMARG2% %CUSTOMARG3% %*

goto End

:LaunchMake95

set MSC_VER=1200
set MSC_ARCH=i386
set MSC_ED=pro

echo nmake /nologo /f makefile.w32 %1 %2 %3 %4 %5 %6 %7 %8 %9
nmake /nologo /f makefile.w32 %1 %2 %3 %4 %5 %6 %7 %8 %9

:End

set CUSTOMARG1=
set CUSTOMARG2=
set CUSTOMARG3=
set MSC_VER=
set MSC_ARCH=
set MSC_ED=


