# This file is designed to abstract out differences between versions of
# Microsoft Visual C++ and common compilation options for that
# environment.  It is designed to be independent of the package that it
# ships with.  Please don't attempt to introduce application-specific
# options here; keep these general.
#
# Currently supported minimum environment for this build system:
# Marketing release: Visual C++ 1.1 for Windows NT
# NMAKE: 1.4
# CL:    8.0

#
# Supported options:
# MSC_ARCH =    n - Specify the processor architecture for the compiler.
#               i386 for "typical" Win32, x64 for AMD64/EM64T, and ia64
#               for Itanium.  Mips, Alpha, and Ppc are not handled
#               explicitly.  If porting to those platforms, start with
#               i386 and work from there.
#
!IFNDEF MSC_ARCH
MSC_ARCH = i386
!ENDIF

#
# MSC_VER =     n - Specify the version of Microsoft C++ - NOT Visual C++.
#               1.1 is 800, 2.0 is 900, 4.0 is 1000, 5.0 is 1100, 6.0 is
#               1200, 2002 is 1300, 2003 is 1310, 2005 is 1400, 2008 is
#               1500, 2010 is 1600, 2012 is 1700, 2013 is 1800, etc.
#               Default is (currently) 1600.
!IFNDEF MSC_VER
MSC_VER = 1600
!ENDIF

# MSC_ED =      std,pro,free - Specify the edition of Microsoft Visual C++;
#               use std for Standard Edition, pro for Professional Edition,
#               and free for Visual C++ Toolkit (free download.)  Default
#               is pro for MSC_VER < 1310, free for MSC_VER >= 1310.
!IFNDEF MSC_ED
!IF $(MSC_VER) >= 1310
MSC_ED=free
!ELSE
MSC_ED=pro
!ENDIF # MSC_VER
!ENDIF # MSC_ED

# CLIB_SHARED = 0 - Link statically against your C library.  Generally not
#               a good idea, but you *must* have this to compile with the
#               free Visual C++ Toolkit; and if you have newer compilers,
#               your customers might not have that version of the shared
#               C library installed, so using it is a bad idea.  Default is
#               1 for MSC_VER >= 900 and < 1300;
#               otherwise.
!IFNDEF CLIB_SHARED
!IF $(MSC_VER) < 1300
!IF $(MSC_VER) >= 900
CLIB_SHARED = 1
!ELSE
CLIB_SHARED = 0
!ENDIF # MSC_VER >= 900
!ELSE
CLIB_SHARED = 0
!ENDIF # MSC_VER < 1300
!ENDIF # CLIB_SHARED

# DEBUG      = 1 - Enable debugging support.  Default is 0.
!IFNDEF DEBUG
DEBUG = 0
!ENDIF

# RELOC      = 1 - Enable relocation information in executables.  This
#              results in larger binaries, but they are Win32s (Windows
#              3.1) compatible.  Default is 0.
!IFNDEF RELOC
RELOC = 0
!ENDIF

# UNICODE    = 1 - Enable building a unicode application.  The default is 0.
#              This option may not be supported by all packages.
!IFNDEF UNICODE
UNICODE = 0
!IFDEF UNICODE_SUPPORT
!IF $(MSC_VER) >= 900
UNICODE = 1
!ENDIF # MSC_VER >= 900
!ENDIF # UNICODE_SUPPORT
!ENDIF # UNICODE

# WITH_3D    = 1 - Enable linking against ctl3d32.lib.  This is only used
#              on old versions of MSC to get 3D appearence; things already
#              look this way on newer versions.  The default is 0 except
#              on MSC 9 (Visual C++ 2.0).  This is the only version that
#              shipped with a default non-3D appearence.
!IFNDEF WITH_3D
!IF $(MSC_VER) >= 900
!IF $(MSC_VER) < 1000
WITH_3D = 1
!ELSE
WITH_3D = 0
!ENDIF # MSC_VER
!ENDIF # MSC_VER
!ENDIF # WITH_3D

# Sanity checking
!IF $(MSC_VER) < 800
!ERROR AutoWin supports Win32/Win64 compilers from version 8 or newer.
!ENDIF

!IFDEF MSC_MINIMUM_VER
!IF $(MSC_VER) < $(MSC_MINIMUM_VER)
!ERROR This package requires C version $(MSC_MINIMUM_VER) or greater.
!ENDIF
!ENDIF

!IF "$(UNICODE)" == "1"
!IFNDEF UNICODE_SUPPORT
!ERROR Attempting to compile with unicode, but package doesn't support it.
!ENDIF
!ENDIF


IMPLIB=lib.exe
LINK=link.exe

LDFLAGS=-nologo
LIBS=kernel32.lib
CFLAGS=-W3 -nologo -D_WIN32_
ILFLAGS=
RCFLAGS=

# Now we start generating everything.  Don't change lightly.

# CLIB_SHARED requires to pass a flag to the compiler according to the following matrix.
# Old versions of Visual C++ don't have debug libs, so don't use the -M?d syntax.
# Visual C++ Toolkit 2003 didn't have debug libs, so we don't use debug CRTs there.
#
#                          DEBUG<2    DEBUG=2
# <=MSVC4, CLIB_SHARED=1   -MD        -MD
# <=MSVC4, CLIB_SHARED=0   -MT        -MT
# TK 2003, CLIB_SHARED=1   -MD        -MD
# TK 2003, CLIB_SHARED=0   -MT        -MT
# CLIB_SHARED=1            -MD        -MDd
# CLIB_SHARED=0            -MT        -MTd
#
!IF "$(CLIB_SHARED)" == "1"

!IF ($(DEBUG) == 2 && $(MSC_VER) >= 1000 && ("$(MSC_ED)" != "free" || $(MSC_VER) >= 1400))
CFLAGS = $(CFLAGS) -MDd
!ELSE
CFLAGS = $(CFLAGS) -MD
!ENDIF 
CLIB_SHARED=1

!ELSE  # CLIB_SHARED

!IF ($(DEBUG) == 2 && $(MSC_VER) >= 1000 && ("$(MSC_ED)" != "free" || $(MSC_VER) >= 1400))
CFLAGS = $(CFLAGS) -MTd
!ELSE
CFLAGS = $(CFLAGS) -MT
!ENDIF 
CLIB_SHARED=0

!ENDIF # CLIB_SHARED


#
# Debug defines what debugging and optimization to use, according to the following.
# VC Standard editions prior to 2005 did not have an optimizer, so we have to work
# around that.  Note that free edition of 2003 *did* have an optimizer, so we only
# check for standard.
#                       DEBUG=0       DEBUG=1       DEBUG=2
# VC Std, <1400         !Opt, !Debug  !Opt, Debug   !Opt, Debug
# Everything else       Opt, !Debug   Opt, Debug    !Opt, Debug
#
!IF "$(DEBUG)" == "2"
CFLAGS = $(CFLAGS) -Zi -Od

!ELSEIF "$(DEBUG)" == "1"
!IF ("$(MSC_ED)" == "std" && $(MSC_VER) < 1400)
CFLAGS = $(CFLAGS) -Gy -Zi
!ELSE
CFLAGS = $(CFLAGS) -Ox -Gy -Zi
!ENDIF 

!ELSE # DEBUG (following is for DEBUG=0)
!IF ("$(MSC_ED)" == "std" && $(MSC_VER) < 1400)
CFLAGS = $(CFLAGS) -Gy
!ELSE
CFLAGS = $(CFLAGS) -Ox -Gy
!ENDIF 
DEBUG = 0

!ENDIF # DEBUG

#
# Debug defines which link options to use, based on the following.
# Visual C++ 1.1                Use old-style debug options, no PDB
# Visual C++ 2-4                Use old-style debug options, with PDB
# Everything else               Use new-style debug options
#
!IF $(DEBUG) > 0
!IF $(MSC_VER) < 900
LDFLAGS = $(LDFLAGS) -DEBUG:full -DEBUGTYPE:both
!ELSEIF $(MSC_VER) < 1100
PDBTARGET=
LDFLAGS = $(LDFLAGS) -DEBUG:full -DEBUGTYPE:CV -PDB:$$(PDBTARGET)
!ELSE
PDBTARGET=
LDFLAGS = $(LDFLAGS) -DEBUG -PDB:$$(PDBTARGET)
!ENDIF # MSC_VER
!ENDIF # DEBUG

#
# Compiler options that are version-specific.
#

!IF $(MSC_VER) < 1300
# Visual C++ 6 and earlier
CFLAGS = $(CFLAGS) -Gf
!ELSEIF $(MSC_VER) < 1400
# Visual C++ 2002/2003
CFLAGS = $(CFLAGS) -GF -Wp64
!ELSEIF $(MSC_VER) < 1500
# Visual C++ 2005
!IF "$(MSC_ED)" == "free"
# Visual Studio 2005 express edition has NO 64-bit support.  -GS is default.
CFLAGS = $(CFLAGS) -GF -D_CRT_SECURE_NO_DEPRECATE -D_CRT_NONSTDC_NO_DEPRECATE
!ELSE
CFLAGS = $(CFLAGS) -GF -Wp64 -D_CRT_SECURE_NO_DEPRECATE -D_CRT_NONSTDC_NO_DEPRECATE
LIBS = $(LIBS) bufferoverflowu.lib
!ENDIF # MSC_ED
!ELSE  # MSC_VER
# Visual C++ 2008, and whatever versions are released after this point.
# -Wp64 is deprecated, and -GS is the default.
CFLAGS = $(CFLAGS) -GF -D_CRT_SECURE_NO_DEPRECATE -D_CRT_NONSTDC_NO_DEPRECATE

!ENDIF # MSC_VER 

#
# Linker options that are version-specific.
#
!IF $(MSC_VER) < 900
LDFLAGS = $(LDFLAGS) -base:0x400000
!ELSE
!IF $(MSC_VER) == 1200
LDFLAGS = $(LDFLAGS) -opt:nowin98
!ENDIF
LDFLAGS = $(LDFLAGS) -incremental:no
ILFLAGS = $(ILFLAGS) /nologo
!ENDIF # MSC_VER

!IF "$(WITH_3D)" == "1"
LIBS = $(LIBS) ctl3d32.lib
CFLAGS = $(CFLAGS) -DWITH_3D
RCFLAGS = $(RCFLAGS) -d WITH_3D
!ENDIF

!IF "$(UNICODE)" == "1"
CFLAGS = $(CFLAGS) -DUNICODE -D_UNICODE
RCFLAGS = $(RCFLAGS) -d UNICODE -d _UNICODE
LD_CONSOLEAPP=-SUBSYSTEM:console -ENTRY:wmainCRTStartup
!ELSE
LD_CONSOLEAPP=-SUBSYSTEM:console
!ENDIF

#
# Relocation support according to the following matrix.  Note that this
# is completely ignored for DLLs, which must always be relocatable.
#            RELOC=0      RELOC=1
# <=MSVC4    -fixed       (default)
# >=MSVC5    (default)    -fixed:no
#
APP_LDFLAGS =
!IF "$(RELOC)" == "1"
!IF $(MSC_VER) >= 1100
APP_LDFLAGS = -fixed:no
!ENDIF
!ELSE
APP_LDFLAGS = -fixed
!ENDIF

BUILD=$(MAKE) -nologo -f Makefile.w32

all: w32bcfg.mak AutoWin-custom-all

clean: AutoWin-custom-clean
	@if exist w32bcfg.mak erase w32bcfg.mak

w32bcfg.mak: w32bcfg-real AutoWin-custom-config display-config

display-config:
	@echo Current build settings:
	@type w32bcfg.mak

w32bcfg-real:
	@echo Regenerating Win32 Build configuration settings...
	@echo BUILD=$(BUILD) >w32bcfg.mak
	@echo CFLAGS=$(CFLAGS) >>w32bcfg.mak
	@echo CLIB_SHARED=$(CLIB_SHARED) >>w32bcfg.mak
	@echo DEBUG=$(DEBUG) >>w32bcfg.mak
	@echo DLL_CFLAGS=$(CFLAGS) >>w32bcfg.mak
	@echo DLL_ILFLAGS=$(ILFLAGS) >>w32bcfg.mak
	@echo DLL_LDFLAGS=$(LDFLAGS) >>w32bcfg.mak
	@echo DLL_LIBS=$(LIBS) >>w32bcfg.mak
	@echo DLL_RCFLAGS=$(RCFLAGS) >>w32bcfg.mak
	@echo IMPLIB=$(IMPLIB) >>w32bcfg.mak
	@echo ILFLAGS=$(ILFLAGS) >>w32bcfg.mak
	@echo LD_CONSOLEAPP=$(LD_CONSOLEAPP) >>w32bcfg.mak
	@echo LDFLAGS=$(LDFLAGS) $(APP_LDFLAGS) >>w32bcfg.mak
	@echo LIBS=$(LIBS) >>w32bcfg.mak
	@echo LINK=$(LINK) >>w32bcfg.mak
	@echo MSC_ARCH=$(MSC_ARCH) >>w32bcfg.mak
	@echo MSC_VER=$(MSC_VER) >>w32bcfg.mak
	@echo MSC_ED=$(MSC_ED) >>w32bcfg.mak
	@echo PDBTARGET=$$(*).pdb >>w32bcfg.mak
	@echo RCFLAGS=$(RCFLAGS) >>w32bcfg.mak
	@echo UNICODE=$(UNICODE) >>w32bcfg.mak
	@echo WITH_3D=$(WITH_3D) >>w32bcfg.mak

#
# It's over folks.  Below is just help.  You've missed all the guts of everything.
#

help: help-intro brief-clib-shared brief-debug brief-msc-arch brief-msc-ed brief-msc-ver brief-reloc brief-unicode brief-with-3d AutoWin-custom-help

help-intro:
	@echo "Summary of Windows configuration options."
	@echo.

brief-clib-shared:
	@echo "CLIB_SHARED=[0|1] - Defines whether to use a shared C library; default 1 for"
	@echo "Win32 MSC_VER 1100 or 1200 (use MSVCRT.DLL), 0 for everything else."
	@echo.

brief-debug:
	@echo "DEBUG=[0|1|2] - Defines whether to perform a debug build.  0 - No"
	@echo "debugging, 1 - hybrid (optimized with debug), 2 - full debug.  Default 0."
	@echo.

brief-msc-arch:
	@echo "MSC_ARCH=[i386|x64|ia64] - Defines which processor the compiler targets."
  	@echo "Default is i386."
	@echo.

brief-msc-ed:
	@echo "MSC_ED=[free|std|pro] - Defines Visual C++ edition.  Default pro, except for"
  	@echo "MSC_VER 1310 or newer, which is free."
	@echo.

brief-msc-ver:
	@echo "MSC_VER=[800|900|1000|1100|1200|1300|1310|1400|1500|1600|1700] - Version of"
	@echo "Microsoft C. Use cl /? to determine which version you have, or build.bat to"
	@echo "guess."
!IFDEF MSC_MINIMUM_VER
	@echo "This package requires $(MSC_MINIMUM_VER) or newer."
!ENDIF
	@echo.

brief-reloc:
	@echo "RELOC=[0|1] - Produce relocatable executables.  DLLs are always relocatable."
	@echo "Default 0."
	@echo.

brief-unicode:
!IFDEF UNICODE_SUPPORT
	@echo "UNICODE=[0|1] - Produce a unicode executable.  Default is 0."
	@echo.
!ENDIF

brief-with-3d:
!IF $(MSC_VER) < 1000
	@echo "WITH_3D=[0|1] - Link against ctl3d*.lib.  Default 0.  Only useful on old Win32"
	@echo "compilers (MSC_VER>=1000 produce 3D widgets without this.)"
	@echo.
!ENDIF


