/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.Log;
import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.EventValueDescription;
import com.android.ddmlib.log.InvalidTypeException;
import com.android.ddmuilib.log.event.DisplayFilteredLog;
import com.android.ddmuilib.log.event.DisplayGraph;
import com.android.ddmuilib.log.event.DisplayLog;
import com.android.ddmuilib.log.event.DisplaySync;
import com.android.ddmuilib.log.event.DisplaySyncHistogram;
import com.android.ddmuilib.log.event.DisplaySyncPerf;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.experimental.swt.SWTUtils;

abstract class EventDisplay {
    private static final String DISPLAY_DATA_STORAGE_SEPARATOR = ":";
    private static final String PID_STORAGE_SEPARATOR = ",";
    private static final String DESCRIPTOR_STORAGE_SEPARATOR = "$";
    private static final String DESCRIPTOR_DATA_STORAGE_SEPARATOR = "!";
    private static final String FILTER_VALUE_NULL = "<null>";
    public static final int DISPLAY_TYPE_LOG_ALL = 0;
    public static final int DISPLAY_TYPE_FILTERED_LOG = 1;
    public static final int DISPLAY_TYPE_GRAPH = 2;
    public static final int DISPLAY_TYPE_SYNC = 3;
    public static final int DISPLAY_TYPE_SYNC_HIST = 4;
    public static final int DISPLAY_TYPE_SYNC_PERF = 5;
    private static final int EVENT_CHECK_FAILED = 0;
    protected static final int EVENT_CHECK_SAME_TAG = 1;
    protected static final int EVENT_CHECK_SAME_VALUE = 2;
    protected String mName;
    private boolean mPidFiltering = false;
    private ArrayList<Integer> mPidFilterList = null;
    protected final ArrayList<ValueDisplayDescriptor> mValueDescriptors = new ArrayList();
    private final ArrayList<OccurrenceDisplayDescriptor> mOccurrenceDescriptors = new ArrayList();
    protected final HashMap<ValueDisplayDescriptor, HashMap<Integer, TimeSeries>> mValueDescriptorSeriesMap = new HashMap();
    protected final HashMap<OccurrenceDisplayDescriptor, HashMap<Integer, TimeSeries>> mOcurrenceDescriptorSeriesMap = new HashMap();
    protected final HashMap<EventValueDescription.ValueType, TimeSeriesCollection> mValueTypeDataSetMap = new HashMap();
    protected JFreeChart mChart;
    protected TimeSeriesCollection mOccurrenceDataSet;
    protected int mDataSetCount;
    private ChartComposite mChartComposite;
    protected long mMaximumChartItemAge = -1L;
    protected long mHistWidth = 1L;
    protected Table mLogTable;
    protected int mValueDescriptorCheck = 0;

    public static EventDisplay eventDisplayFactory(int type, String name) {
        switch (type) {
            case 0: {
                return new DisplayLog(name);
            }
            case 1: {
                return new DisplayFilteredLog(name);
            }
            case 3: {
                return new DisplaySync(name);
            }
            case 4: {
                return new DisplaySyncHistogram(name);
            }
            case 2: {
                return new DisplayGraph(name);
            }
            case 5: {
                return new DisplaySyncPerf(name);
            }
        }
        throw new InvalidParameterException("Unknown Display Type " + type);
    }

    abstract void newEvent(EventContainer var1, EventLogParser var2);

    abstract void resetUI();

    abstract int getDisplayType();

    abstract Control createComposite(Composite var1, EventLogParser var2, ILogColumnListener var3);

    EventDisplay(String name) {
        this.mName = name;
    }

    static EventDisplay clone(EventDisplay from) {
        EventDisplay ed = EventDisplay.eventDisplayFactory(from.getDisplayType(), from.getName());
        ed.mName = from.mName;
        ed.mPidFiltering = from.mPidFiltering;
        ed.mMaximumChartItemAge = from.mMaximumChartItemAge;
        ed.mHistWidth = from.mHistWidth;
        if (from.mPidFilterList != null) {
            ed.mPidFilterList = new ArrayList();
            ed.mPidFilterList.addAll(from.mPidFilterList);
        }
        for (ValueDisplayDescriptor valueDisplayDescriptor : from.mValueDescriptors) {
            ed.mValueDescriptors.add(new ValueDisplayDescriptor(valueDisplayDescriptor));
        }
        ed.mValueDescriptorCheck = from.mValueDescriptorCheck;
        for (OccurrenceDisplayDescriptor occurrenceDisplayDescriptor : from.mOccurrenceDescriptors) {
            ed.mOccurrenceDescriptors.add(new OccurrenceDisplayDescriptor(occurrenceDisplayDescriptor));
        }
        return ed;
    }

    String getStorageString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mName);
        sb.append(DISPLAY_DATA_STORAGE_SEPARATOR);
        sb.append(this.getDisplayType());
        sb.append(DISPLAY_DATA_STORAGE_SEPARATOR);
        sb.append(Boolean.toString(this.mPidFiltering));
        sb.append(DISPLAY_DATA_STORAGE_SEPARATOR);
        sb.append(this.getPidStorageString());
        sb.append(DISPLAY_DATA_STORAGE_SEPARATOR);
        sb.append(this.getDescriptorStorageString(this.mValueDescriptors));
        sb.append(DISPLAY_DATA_STORAGE_SEPARATOR);
        sb.append(this.getDescriptorStorageString(this.mOccurrenceDescriptors));
        sb.append(DISPLAY_DATA_STORAGE_SEPARATOR);
        sb.append(this.mMaximumChartItemAge);
        sb.append(DISPLAY_DATA_STORAGE_SEPARATOR);
        sb.append(this.mHistWidth);
        sb.append(DISPLAY_DATA_STORAGE_SEPARATOR);
        return sb.toString();
    }

    void setName(String name) {
        this.mName = name;
    }

    String getName() {
        return this.mName;
    }

    void setPidFiltering(boolean filterByPid) {
        this.mPidFiltering = filterByPid;
    }

    boolean getPidFiltering() {
        return this.mPidFiltering;
    }

    void setPidFilterList(ArrayList<Integer> pids) {
        if (!this.mPidFiltering) {
            throw new InvalidParameterException();
        }
        this.mPidFilterList = pids;
    }

    ArrayList<Integer> getPidFilterList() {
        return this.mPidFilterList;
    }

    void addPidFiler(int pid) {
        if (!this.mPidFiltering) {
            throw new InvalidParameterException();
        }
        if (this.mPidFilterList == null) {
            this.mPidFilterList = new ArrayList();
        }
        this.mPidFilterList.add(pid);
    }

    Iterator<ValueDisplayDescriptor> getValueDescriptors() {
        return this.mValueDescriptors.iterator();
    }

    void updateValueDescriptorCheck() {
        this.mValueDescriptorCheck = this.checkDescriptors();
    }

    Iterator<OccurrenceDisplayDescriptor> getOccurrenceDescriptors() {
        return this.mOccurrenceDescriptors.iterator();
    }

    void addDescriptor(OccurrenceDisplayDescriptor descriptor) {
        if (descriptor instanceof ValueDisplayDescriptor) {
            this.mValueDescriptors.add((ValueDisplayDescriptor)descriptor);
            this.mValueDescriptorCheck = this.checkDescriptors();
        } else {
            this.mOccurrenceDescriptors.add(descriptor);
        }
    }

    OccurrenceDisplayDescriptor getDescriptor(Class<? extends OccurrenceDisplayDescriptor> descriptorClass, int index) {
        if (descriptorClass == OccurrenceDisplayDescriptor.class) {
            return this.mOccurrenceDescriptors.get(index);
        }
        if (descriptorClass == ValueDisplayDescriptor.class) {
            return this.mValueDescriptors.get(index);
        }
        return null;
    }

    void removeDescriptor(Class<? extends OccurrenceDisplayDescriptor> descriptorClass, int index) {
        if (descriptorClass == OccurrenceDisplayDescriptor.class) {
            this.mOccurrenceDescriptors.remove(index);
        } else if (descriptorClass == ValueDisplayDescriptor.class) {
            this.mValueDescriptors.remove(index);
            this.mValueDescriptorCheck = this.checkDescriptors();
        }
    }

    Control createCompositeChart(final Composite parent, EventLogParser logParser, String title) {
        this.mChart = ChartFactory.createTimeSeriesChart(null, null, null, null, (boolean)true, (boolean)false, (boolean)false);
        Font f = parent.getFont();
        FontData[] fData = f.getFontData();
        FontData firstFontData = fData[0];
        java.awt.Font awtFont = SWTUtils.toAwtFont((Device)parent.getDisplay(), (FontData)firstFontData, (boolean)true);
        this.mChart.setTitle(new TextTitle(title, awtFont));
        final XYPlot xyPlot = this.mChart.getXYPlot();
        xyPlot.setRangeCrosshairVisible(true);
        xyPlot.setRangeCrosshairLockedOnData(true);
        xyPlot.setDomainCrosshairVisible(true);
        xyPlot.setDomainCrosshairLockedOnData(true);
        this.mChart.addChangeListener(new ChartChangeListener(){

            public void chartChanged(ChartChangeEvent event) {
                ChartChangeEventType type = event.getType();
                if (type == ChartChangeEventType.GENERAL) {
                    parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            EventDisplay.this.processClick(xyPlot);
                        }
                    });
                }
            }
        });
        this.mChartComposite = new ChartComposite(parent, 2048, this.mChart, 680, 420, 300, 200, 3000, 3000, true, true, true, true, true, true);
        this.mChartComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EventDisplay.this.mValueTypeDataSetMap.clear();
                EventDisplay.this.mDataSetCount = 0;
                EventDisplay.this.mOccurrenceDataSet = null;
                EventDisplay.this.mChart = null;
                EventDisplay.this.mChartComposite = null;
                EventDisplay.this.mValueDescriptorSeriesMap.clear();
                EventDisplay.this.mOcurrenceDescriptorSeriesMap.clear();
            }
        });
        return this.mChartComposite;
    }

    private void processClick(XYPlot xyPlot) {
        double rangeValue = xyPlot.getRangeCrosshairValue();
        if (rangeValue != 0.0) {
            double domainValue = xyPlot.getDomainCrosshairValue();
            Millisecond msec = new Millisecond(new Date((long)domainValue));
            Set<ValueDisplayDescriptor> descKeys = this.mValueDescriptorSeriesMap.keySet();
            for (ValueDisplayDescriptor descKey : descKeys) {
                HashMap<Integer, TimeSeries> map = this.mValueDescriptorSeriesMap.get(descKey);
                Set<Integer> pidKeys = map.keySet();
                for (Integer pidKey : pidKeys) {
                    TimeSeries series = map.get(pidKey);
                    Number value = series.getValue((RegularTimePeriod)msec);
                    if (value == null || value.doubleValue() != rangeValue) continue;
                    return;
                }
            }
        }
    }

    void resizeColumn(int index, TableColumn sourceColumn) {
    }

    protected void setNewLogParser(EventLogParser logParser) {
    }

    void startMultiEventDisplay() {
        if (this.mLogTable != null) {
            this.mLogTable.setRedraw(false);
        }
    }

    void endMultiEventDisplay() {
        if (this.mLogTable != null) {
            this.mLogTable.setRedraw(true);
        }
    }

    Table getTable() {
        return this.mLogTable;
    }

    static EventDisplay load(String storageString) {
        if (storageString.length() > 0) {
            String[] values = storageString.split(Pattern.quote(DISPLAY_DATA_STORAGE_SEPARATOR));
            try {
                int index = 0;
                String name = values[index++];
                int displayType = Integer.parseInt(values[index++]);
                boolean pidFiltering = Boolean.parseBoolean(values[index++]);
                EventDisplay ed = EventDisplay.eventDisplayFactory(displayType, name);
                ed.setPidFiltering(pidFiltering);
                if (index < values.length) {
                    ed.loadPidFilters(values[index++]);
                }
                if (index < values.length) {
                    ed.loadValueDescriptors(values[index++]);
                }
                if (index < values.length) {
                    ed.loadOccurrenceDescriptors(values[index++]);
                }
                ed.updateValueDescriptorCheck();
                if (index < values.length) {
                    ed.mMaximumChartItemAge = Long.parseLong(values[index++]);
                }
                if (index < values.length) {
                    ed.mHistWidth = Long.parseLong(values[index++]);
                }
                return ed;
            }
            catch (RuntimeException re) {
                Log.e("ddms", re);
            }
        }
        return null;
    }

    private String getPidStorageString() {
        if (this.mPidFilterList != null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Integer i : this.mPidFilterList) {
                if (!first) {
                    sb.append(PID_STORAGE_SEPARATOR);
                } else {
                    first = false;
                }
                sb.append(i);
            }
            return sb.toString();
        }
        return "";
    }

    private void loadPidFilters(String storageString) {
        if (storageString.length() > 0) {
            String[] values;
            for (String value : values = storageString.split(Pattern.quote(PID_STORAGE_SEPARATOR))) {
                if (this.mPidFilterList == null) {
                    this.mPidFilterList = new ArrayList();
                }
                this.mPidFilterList.add(Integer.parseInt(value));
            }
        }
    }

    private String getDescriptorStorageString(ArrayList<? extends OccurrenceDisplayDescriptor> descriptorList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (OccurrenceDisplayDescriptor occurrenceDisplayDescriptor : descriptorList) {
            if (!first) {
                sb.append(DESCRIPTOR_STORAGE_SEPARATOR);
            } else {
                first = false;
            }
            sb.append(occurrenceDisplayDescriptor.getStorageString());
        }
        return sb.toString();
    }

    private void loadOccurrenceDescriptors(String storageString) {
        String[] values;
        if (storageString.length() == 0) {
            return;
        }
        for (String value : values = storageString.split(Pattern.quote(DESCRIPTOR_STORAGE_SEPARATOR))) {
            OccurrenceDisplayDescriptor desc = new OccurrenceDisplayDescriptor();
            desc.loadFrom(value);
            this.mOccurrenceDescriptors.add(desc);
        }
    }

    private void loadValueDescriptors(String storageString) {
        String[] values;
        if (storageString.length() == 0) {
            return;
        }
        for (String value : values = storageString.split(Pattern.quote(DESCRIPTOR_STORAGE_SEPARATOR))) {
            ValueDisplayDescriptor desc = new ValueDisplayDescriptor();
            desc.loadFrom(value);
            this.mValueDescriptors.add(desc);
        }
    }

    private void getDescriptors(EventContainer event, ArrayList<? extends OccurrenceDisplayDescriptor> fullList, ArrayList outList) {
        for (OccurrenceDisplayDescriptor occurrenceDisplayDescriptor : fullList) {
            try {
                if (occurrenceDisplayDescriptor.eventTag != event.mTag || occurrenceDisplayDescriptor.filterValueIndex != -1 && !event.testValue(occurrenceDisplayDescriptor.filterValueIndex, occurrenceDisplayDescriptor.filterValue, occurrenceDisplayDescriptor.filterCompareMethod)) continue;
                outList.add(occurrenceDisplayDescriptor);
            }
            catch (InvalidTypeException ite) {
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                Log.e("Event Log", String.format("ArrayIndexOutOfBoundsException occured when checking %1$d-th value of event %2$d", occurrenceDisplayDescriptor.filterValueIndex, occurrenceDisplayDescriptor.eventTag));
            }
        }
    }

    protected boolean filterEvent(EventContainer event, ArrayList<ValueDisplayDescriptor> valueDescriptors, ArrayList<OccurrenceDisplayDescriptor> occurrenceDescriptors) {
        if (this.mPidFiltering && this.mPidFilterList != null) {
            boolean found = false;
            for (int pid : this.mPidFilterList) {
                if (pid != event.pid) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        this.getDescriptors(event, this.mValueDescriptors, valueDescriptors);
        this.getDescriptors(event, this.mOccurrenceDescriptors, occurrenceDescriptors);
        return valueDescriptors.size() > 0 || occurrenceDescriptors.size() > 0;
    }

    private int checkDescriptors() {
        if (this.mValueDescriptors.size() < 2) {
            return 2;
        }
        int tag = -1;
        int index = -1;
        for (ValueDisplayDescriptor display : this.mValueDescriptors) {
            if (tag == -1) {
                tag = display.eventTag;
                index = display.valueIndex;
                continue;
            }
            if (tag != display.eventTag) {
                return 0;
            }
            if (index == -1 || index == display.valueIndex) continue;
            index = -1;
        }
        if (index == -1) {
            return 1;
        }
        return 2;
    }

    void resetChartTimeLimit() {
        this.mMaximumChartItemAge = -1L;
    }

    void setChartTimeLimit(long timeLimit) {
        this.mMaximumChartItemAge = timeLimit;
    }

    long getChartTimeLimit() {
        return this.mMaximumChartItemAge;
    }

    void resetHistWidth() {
        this.mHistWidth = 1L;
    }

    void setHistWidth(long histWidth) {
        this.mHistWidth = histWidth;
    }

    long getHistWidth() {
        return this.mHistWidth;
    }

    static final class ValueDisplayDescriptor
    extends OccurrenceDisplayDescriptor {
        String valueName;
        int valueIndex = -1;

        ValueDisplayDescriptor() {
        }

        ValueDisplayDescriptor(ValueDisplayDescriptor descriptor) {
            this.replaceWith(descriptor);
        }

        ValueDisplayDescriptor(int eventTag, String valueName, int valueIndex) {
            super(eventTag);
            this.valueName = valueName;
            this.valueIndex = valueIndex;
        }

        ValueDisplayDescriptor(int eventTag, String valueName, int valueIndex, int seriesValueIndex) {
            super(eventTag, seriesValueIndex);
            this.valueName = valueName;
            this.valueIndex = valueIndex;
        }

        @Override
        void replaceWith(OccurrenceDisplayDescriptor descriptor) {
            super.replaceWith(descriptor);
            if (descriptor instanceof ValueDisplayDescriptor) {
                ValueDisplayDescriptor valueDescriptor = (ValueDisplayDescriptor)descriptor;
                this.valueName = valueDescriptor.valueName;
                this.valueIndex = valueDescriptor.valueIndex;
            }
        }

        @Override
        protected int loadFrom(String[] storageStrings, int index) {
            index = super.loadFrom(storageStrings, index);
            this.valueName = storageStrings[index++];
            this.valueIndex = Integer.parseInt(storageStrings[index++]);
            return index;
        }

        @Override
        String getStorageString() {
            String superStorage = super.getStorageString();
            StringBuilder sb = new StringBuilder();
            sb.append(superStorage);
            sb.append(EventDisplay.DESCRIPTOR_DATA_STORAGE_SEPARATOR);
            sb.append(this.valueName);
            sb.append(EventDisplay.DESCRIPTOR_DATA_STORAGE_SEPARATOR);
            sb.append(this.valueIndex);
            return sb.toString();
        }
    }

    static class OccurrenceDisplayDescriptor {
        int eventTag = -1;
        int seriesValueIndex = -1;
        boolean includePid = false;
        int filterValueIndex = -1;
        EventContainer.CompareMethod filterCompareMethod = EventContainer.CompareMethod.EQUAL_TO;
        Object filterValue = null;

        OccurrenceDisplayDescriptor() {
        }

        OccurrenceDisplayDescriptor(OccurrenceDisplayDescriptor descriptor) {
            this.replaceWith(descriptor);
        }

        OccurrenceDisplayDescriptor(int eventTag) {
            this.eventTag = eventTag;
        }

        OccurrenceDisplayDescriptor(int eventTag, int seriesValueIndex) {
            this.eventTag = eventTag;
            this.seriesValueIndex = seriesValueIndex;
        }

        void replaceWith(OccurrenceDisplayDescriptor descriptor) {
            this.eventTag = descriptor.eventTag;
            this.seriesValueIndex = descriptor.seriesValueIndex;
            this.includePid = descriptor.includePid;
            this.filterValueIndex = descriptor.filterValueIndex;
            this.filterCompareMethod = descriptor.filterCompareMethod;
            this.filterValue = descriptor.filterValue;
        }

        final void loadFrom(String storageString) {
            String[] values = storageString.split(Pattern.quote(EventDisplay.DESCRIPTOR_DATA_STORAGE_SEPARATOR));
            this.loadFrom(values, 0);
        }

        protected int loadFrom(String[] storageStrings, int index) {
            this.eventTag = Integer.parseInt(storageStrings[index++]);
            this.seriesValueIndex = Integer.parseInt(storageStrings[index++]);
            this.includePid = Boolean.parseBoolean(storageStrings[index++]);
            this.filterValueIndex = Integer.parseInt(storageStrings[index++]);
            try {
                this.filterCompareMethod = EventContainer.CompareMethod.valueOf(storageStrings[index++]);
            }
            catch (IllegalArgumentException e) {
                this.filterCompareMethod = EventContainer.CompareMethod.EQUAL_TO;
            }
            String value = storageStrings[index++];
            if (this.filterValueIndex != -1 && !EventDisplay.FILTER_VALUE_NULL.equals(value)) {
                this.filterValue = EventContainer.EventValueType.getObjectFromStorageString(value);
            }
            return index;
        }

        String getStorageString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.eventTag);
            sb.append(EventDisplay.DESCRIPTOR_DATA_STORAGE_SEPARATOR);
            sb.append(this.seriesValueIndex);
            sb.append(EventDisplay.DESCRIPTOR_DATA_STORAGE_SEPARATOR);
            sb.append(Boolean.toString(this.includePid));
            sb.append(EventDisplay.DESCRIPTOR_DATA_STORAGE_SEPARATOR);
            sb.append(this.filterValueIndex);
            sb.append(EventDisplay.DESCRIPTOR_DATA_STORAGE_SEPARATOR);
            sb.append(this.filterCompareMethod.name());
            sb.append(EventDisplay.DESCRIPTOR_DATA_STORAGE_SEPARATOR);
            if (this.filterValue != null) {
                String value = EventContainer.EventValueType.getStorageString(this.filterValue);
                if (value != null) {
                    sb.append(value);
                } else {
                    sb.append(EventDisplay.FILTER_VALUE_NULL);
                }
            } else {
                sb.append(EventDisplay.FILTER_VALUE_NULL);
            }
            return sb.toString();
        }
    }

    static interface ILogColumnListener {
        public void columnResized(int var1, TableColumn var2);
    }
}

