/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public abstract class Device
implements Drawable {
    protected long xDisplay;
    long shellHandle;
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    GdkColor[] gdkColors;
    int[] colorRefCount;
    boolean disposed;
    long logProc;
    Callback logCallback;
    String[] log_domains = new String[]{"GLib-GObject", "GLib", "GObject", "Pango", "ATK", "GdkPixbuf", "Gdk", "Gtk", "GnomeVFS"};
    int[] handler_ids = new int[this.log_domains.length];
    int warningLevel;
    static Callback XErrorCallback;
    static Callback XIOErrorCallback;
    static long XErrorProc;
    static long XIOErrorProc;
    static long XNullErrorProc;
    static long XNullIOErrorProc;
    static Device[] Devices;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    long emptyTab;
    boolean useXRender;
    static boolean CAIRO_LOADED;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;
    static /* synthetic */ Class class$0;

    static {
        Devices = new Device[4];
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(deviceData);
            this.init();
            Device.register(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void checkCairo() {
        if (CAIRO_LOADED) {
            return;
        }
        try {
            byte[] byArray = Converter.wcsToMbcs(null, "libcairo.so.2", true);
            long l = OS.dlopen(byArray, 1);
            if (l != 0L) {
                OS.dlclose(l);
            } else {
                try {
                    System.loadLibrary("cairo-swt");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            }
            Class.forName("org.eclipse.swt.internal.cairo.Cairo");
            CAIRO_LOADED = true;
        }
        catch (Throwable throwable) {
            SWT.error(16, throwable, " [Cairo is required]");
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData deviceData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            Device.deregister(this);
            this.xDisplay = 0L;
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] == object) {
                    this.objects[n] = null;
                    this.errors[n] = null;
                    return;
                }
                ++n;
            }
        }
    }

    static synchronized Device findDevice(long l) {
        int n = 0;
        while (n < Devices.length) {
            Device device = Devices[n];
            if (device != null && device.xDisplay == l) {
                return device;
            }
            ++n;
        }
        return null;
    }

    static synchronized void deregister(Device device) {
        int n = 0;
        while (n < Devices.length) {
            if (device == Devices[n]) {
                Device.Devices[n] = null;
            }
            ++n;
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n = 0;
                int n2 = this.objects.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.objects[n3] != null) {
                        ++n;
                    }
                    ++n3;
                }
                n3 = 0;
                deviceData.objects = new Object[n];
                deviceData.errors = new Error[n];
                int n4 = 0;
                while (n4 < n2) {
                    if (this.objects[n4] != null) {
                        deviceData.objects[n3] = this.objects[n4];
                        deviceData.errors[n3] = this.errors[n4];
                        ++n3;
                    }
                    ++n4;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return 0;
    }

    public Point getDPI() {
        this.checkDevice();
        return new Point(72, 72);
    }

    public FontData[] getFontList(String string, boolean bl) {
        this.checkDevice();
        if (!bl) {
            return new FontData[0];
        }
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long[] lArray3 = new long[1];
        int[] nArray = new int[1];
        long[] lArray4 = new long[1];
        int[] nArray2 = new int[1];
        long l = OS.gdk_pango_context_get();
        OS.pango_context_list_families(l, lArray3, nArray);
        int n = 0;
        FontData[] fontDataArray = new FontData[string != null ? 4 : nArray[0]];
        int n2 = 0;
        while (n2 < nArray[0]) {
            Object object;
            Object object2;
            OS.memmove(lArray, lArray3[0] + (long)(n2 * OS.PTR_SIZEOF), (long)OS.PTR_SIZEOF);
            boolean bl2 = true;
            if (string != null) {
                long l2 = OS.pango_font_family_get_name(lArray[0]);
                int n3 = OS.strlen(l2);
                object2 = new byte[n3];
                OS.memmove((byte[])object2, l2, (long)n3);
                object = new String(Converter.mbcsToWcs(null, (byte[])object2));
                bl2 = Compatibility.equalsIgnoreCase(string, (String)object);
            }
            if (bl2) {
                OS.pango_font_family_list_faces(lArray[0], lArray4, nArray2);
                int n4 = 0;
                while (n4 < nArray2[0]) {
                    OS.memmove(lArray2, lArray4[0] + (long)(n4 * OS.PTR_SIZEOF), (long)OS.PTR_SIZEOF);
                    long l3 = OS.pango_font_face_describe(lArray2[0]);
                    object2 = Font.gtk_new(this, l3);
                    object = ((Font)object2).getFontData()[0];
                    if (n == fontDataArray.length) {
                        FontData[] fontDataArray2 = new FontData[fontDataArray.length + nArray[0]];
                        System.arraycopy(fontDataArray, 0, fontDataArray2, 0, n);
                        fontDataArray = fontDataArray2;
                    }
                    fontDataArray[n++] = object;
                    OS.pango_font_description_free(l3);
                    ++n4;
                }
                OS.g_free(lArray4[0]);
                if (string != null) break;
            }
            ++n2;
        }
        OS.g_free(lArray3[0]);
        OS.g_object_unref(l);
        if (n == fontDataArray.length) {
            return fontDataArray;
        }
        FontData[] fontDataArray3 = new FontData[n];
        System.arraycopy(fontDataArray, 0, fontDataArray3, 0, n);
        return fontDataArray3;
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        switch (n) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warningLevel == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void init() {
        Object[] objectArray;
        int[] nArray;
        Object object;
        if (this.xDisplay != 0L && OS.XRenderQueryExtension(this.xDisplay, object = new int[1], nArray = new int[1])) {
            objectArray = new int[1];
            int[] nArray2 = new int[1];
            OS.XRenderQueryVersion(this.xDisplay, objectArray, nArray2);
            boolean bl = this.useXRender = objectArray[0] > 0 || objectArray[0] == 0 && nArray2[0] >= 8;
        }
        if (this.debug && this.xDisplay != 0L) {
            object = this.getClass();
            nArray = object;
            // MONITORENTER : object
            int n = 0;
            while (n < Devices.length && Devices[n] == null) {
                ++n;
            }
            if (n == Devices.length) {
                XErrorCallback = new Callback(object, "XErrorProc", 2);
                XNullErrorProc = XErrorCallback.getAddress();
                if (XNullErrorProc == 0L) {
                    SWT.error(3);
                }
                if ((XNullIOErrorProc = (XIOErrorCallback = new Callback(object, "XIOErrorProc", 1)).getAddress()) == 0L) {
                    SWT.error(3);
                }
                XErrorProc = OS.XSetErrorHandler(XNullErrorProc);
                XIOErrorProc = OS.XSetIOErrorHandler(XNullIOErrorProc);
            }
            // MONITOREXIT : nArray
            OS.XSynchronize(this.xDisplay, true);
        }
        if (this.xDisplay != 0L) {
            this.logCallback = new Callback(this, "logProc", 4);
            this.logProc = this.logCallback.getAddress();
            if (this.logProc == 0L) {
                SWT.error(3);
            }
            if (this.debug) {
                int n = -1;
                int n2 = 0;
                while (n2 < this.log_domains.length) {
                    objectArray = Converter.wcsToMbcs(null, this.log_domains[n2], true);
                    this.handler_ids[n2] = OS.g_log_set_handler((byte[])objectArray, n, this.logProc, 0L);
                    ++n2;
                }
            }
        }
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        this.emptyTab = OS.pango_tab_array_new(1, false);
        if (this.emptyTab == 0L) {
            SWT.error(2);
        }
        OS.pango_tab_array_set_tab(this.emptyTab, 0, 0L, 1);
        this.shellHandle = OS.gtk_window_new(0);
        if (this.shellHandle == 0L) {
            SWT.error(2);
        }
        OS.gtk_widget_realize(this.shellHandle);
        this.systemFont = this.getSystemFont();
    }

    public abstract long internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(long var1, GCData var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String string) {
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        return OS.FcConfigAppFontAddFile(0L, byArray);
    }

    long logProc(long l, long l2, long l3, long l4) {
        if (this.warningLevel == 0) {
            if (DEBUG || this.debug) {
                new Error().printStackTrace();
            }
            OS.g_log_default_handler(l, (int)l2, l3, 0L);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] == null) {
                    this.objects[n] = object;
                    this.errors[n] = new Error();
                    return;
                }
                ++n;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    static synchronized void register(Device device) {
        int n = 0;
        while (n < Devices.length) {
            if (Devices[n] == null) {
                Device.Devices[n] = device;
                return;
            }
            ++n;
        }
        Device[] deviceArray = new Device[Devices.length + 4];
        System.arraycopy(Devices, 0, deviceArray, 0, Devices.length);
        deviceArray[Device.Devices.length] = device;
        Devices = deviceArray;
    }

    protected void release() {
        if (this.shellHandle != 0L) {
            OS.gtk_widget_destroy(this.shellHandle);
        }
        this.shellHandle = 0L;
        if (this.gdkColors != null) {
            long l = OS.gdk_colormap_get_system();
            int n = 0;
            while (n < this.gdkColors.length) {
                GdkColor gdkColor = this.gdkColors[n];
                if (gdkColor != null) {
                    while (this.colorRefCount[n] > 0) {
                        OS.gdk_colormap_free_colors(l, gdkColor, 1);
                        int n2 = n;
                        this.colorRefCount[n2] = this.colorRefCount[n2] - 1;
                    }
                }
                ++n;
            }
        }
        this.gdkColors = null;
        this.colorRefCount = null;
        if (this.COLOR_BLACK != null) {
            this.COLOR_BLACK.dispose();
        }
        if (this.COLOR_DARK_RED != null) {
            this.COLOR_DARK_RED.dispose();
        }
        if (this.COLOR_DARK_GREEN != null) {
            this.COLOR_DARK_GREEN.dispose();
        }
        if (this.COLOR_DARK_YELLOW != null) {
            this.COLOR_DARK_YELLOW.dispose();
        }
        if (this.COLOR_DARK_BLUE != null) {
            this.COLOR_DARK_BLUE.dispose();
        }
        if (this.COLOR_DARK_MAGENTA != null) {
            this.COLOR_DARK_MAGENTA.dispose();
        }
        if (this.COLOR_DARK_CYAN != null) {
            this.COLOR_DARK_CYAN.dispose();
        }
        if (this.COLOR_GRAY != null) {
            this.COLOR_GRAY.dispose();
        }
        if (this.COLOR_DARK_GRAY != null) {
            this.COLOR_DARK_GRAY.dispose();
        }
        if (this.COLOR_RED != null) {
            this.COLOR_RED.dispose();
        }
        if (this.COLOR_GREEN != null) {
            this.COLOR_GREEN.dispose();
        }
        if (this.COLOR_YELLOW != null) {
            this.COLOR_YELLOW.dispose();
        }
        if (this.COLOR_BLUE != null) {
            this.COLOR_BLUE.dispose();
        }
        if (this.COLOR_MAGENTA != null) {
            this.COLOR_MAGENTA.dispose();
        }
        if (this.COLOR_CYAN != null) {
            this.COLOR_CYAN.dispose();
        }
        if (this.COLOR_WHITE != null) {
            this.COLOR_WHITE.dispose();
        }
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
        if (this.emptyTab != 0L) {
            OS.pango_tab_array_free(this.emptyTab);
        }
        this.emptyTab = 0L;
        if (this.xDisplay != 0L) {
            int n = 0;
            while (n < this.handler_ids.length) {
                if (this.handler_ids[n] != 0) {
                    byte[] byArray = Converter.wcsToMbcs(null, this.log_domains[n], true);
                    OS.g_log_remove_handler(byArray, this.handler_ids[n]);
                    this.handler_ids[n] = 0;
                }
                ++n;
            }
            this.logCallback.dispose();
            this.logCallback = null;
            this.handler_ids = null;
            this.log_domains = null;
            this.logProc = 0L;
        }
    }

    public void setWarnings(boolean bl) {
        block9: {
            block8: {
                this.checkDevice();
                if (!bl) break block8;
                if (--this.warningLevel != 0) break block9;
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0L) {
                    int n = 0;
                    while (n < this.handler_ids.length) {
                        if (this.handler_ids[n] != 0) {
                            byte[] byArray = Converter.wcsToMbcs(null, this.log_domains[n], true);
                            OS.g_log_remove_handler(byArray, this.handler_ids[n]);
                            this.handler_ids[n] = 0;
                        }
                        ++n;
                    }
                }
                break block9;
            }
            if (this.warningLevel++ == 0) {
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0L) {
                    int n = -1;
                    int n2 = 0;
                    while (n2 < this.log_domains.length) {
                        byte[] byArray = Converter.wcsToMbcs(null, this.log_domains[n2], true);
                        this.handler_ids[n2] = OS.g_log_set_handler(byArray, n, this.logProc, 0L);
                        ++n2;
                    }
                }
            }
        }
    }

    static long XErrorProc(long l, long l2) {
        Device device = Device.findDevice(l);
        if (device != null) {
            if (device.warningLevel == 0) {
                if (DEBUG || device.debug) {
                    new SWTError().printStackTrace();
                }
                OS.Call(XErrorProc, l, l2);
            }
        } else {
            if (DEBUG) {
                new SWTError().printStackTrace();
            }
            OS.Call(XErrorProc, l, l2);
        }
        return 0L;
    }

    static long XIOErrorProc(long l) {
        Device device = Device.findDevice(l);
        if (device != null) {
            if (DEBUG || device.debug) {
                new SWTError().printStackTrace();
            }
        } else if (DEBUG) {
            new SWTError().printStackTrace();
        }
        OS.Call(XIOErrorProc, l, 0L);
        return 0L;
    }
}

