/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.model;

import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.ProtoBufUtils;
import com.android.ide.eclipse.gltrace.TraceFileInfo;
import com.android.ide.eclipse.gltrace.TraceFileReader;
import com.android.ide.eclipse.gltrace.model.GLCall;
import com.android.ide.eclipse.gltrace.model.GLFrame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class GLTrace {
    private static final TraceFileReader sTraceFileReader = new TraceFileReader();
    private final TraceFileInfo mTraceFileInfo;
    private final List<GLFrame> mGLFrames;
    private final List<GLCall> mGLCalls;
    private List<Integer> mContextIds;

    public GLTrace(TraceFileInfo traceFileInfo, List<GLFrame> list, List<GLCall> list2, List<Integer> list3) {
        this.mTraceFileInfo = traceFileInfo;
        this.mGLFrames = list;
        this.mGLCalls = list2;
        this.mContextIds = list3;
    }

    public List<GLFrame> getFrames() {
        return this.mGLFrames;
    }

    public GLFrame getFrame(int n) {
        return this.mGLFrames.get(n);
    }

    public List<GLCall> getGLCalls() {
        return this.mGLCalls;
    }

    public List<GLCall> getGLCallsForFrame(int n) {
        if (n >= this.mGLFrames.size()) {
            return Collections.emptyList();
        }
        GLFrame gLFrame = this.mGLFrames.get(n);
        return this.mGLCalls.subList(gLFrame.getStartIndex(), gLFrame.getEndIndex());
    }

    public Image getImage(GLCall gLCall) {
        RandomAccessFile randomAccessFile;
        if (!gLCall.hasFb()) {
            return null;
        }
        if (this.isTraceFileModified()) {
            return null;
        }
        try {
            randomAccessFile = new RandomAccessFile(this.mTraceFileInfo.getPath(), "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        GLProtoBuf.GLMessage gLMessage = null;
        try {
            try {
                gLMessage = sTraceFileReader.getMessageAtOffset(randomAccessFile, gLCall.getOffsetInTraceFile());
            }
            catch (Exception exception) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {}
        return ProtoBufUtils.getImage(Display.getCurrent(), gLMessage);
    }

    private boolean isTraceFileModified() {
        File file = new File(this.mTraceFileInfo.getPath());
        return file.length() != this.mTraceFileInfo.getSize() || file.lastModified() != this.mTraceFileInfo.getLastModificationTime();
    }

    public List<Integer> getContexts() {
        return this.mContextIds;
    }
}

