/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.escape;

import com.google.clearsilver.jsilver.functions.TextFilter;
import java.io.IOException;

public class StyleEscapeFunction
implements TextFilter {
    private static final boolean[] UNQUOTED_VALID_CHARS;
    private static final boolean[] VALID_CHARS;
    private static final int MAX_CHARS = 128;
    private final boolean[] validChars;

    public StyleEscapeFunction(boolean isUnquoted) {
        this.validChars = isUnquoted ? UNQUOTED_VALID_CHARS : VALID_CHARS;
    }

    public void filter(String in, Appendable out) throws IOException {
        for (char c : in.toCharArray()) {
            if (c < '\u0080' && this.validChars[c]) {
                out.append(c);
                continue;
            }
            if (c < '\u0080') continue;
            out.append(c);
        }
    }

    public void dumpInfo() {
        for (int i = 0; i < 128; ++i) {
            System.out.println(i + "(" + (char)i + ")" + " :" + VALID_CHARS[i]);
        }
    }

    static {
        String SPECIAL_CHARS = "_.,!#%- ";
        String UNQUOTED_SPECIAL_CHARS = "_.,!#%-";
        VALID_CHARS = new boolean[128];
        UNQUOTED_VALID_CHARS = new boolean[128];
        for (int n = 0; n < 128; ++n) {
            StyleEscapeFunction.VALID_CHARS[n] = false;
            StyleEscapeFunction.UNQUOTED_VALID_CHARS[n] = false;
            if (Character.isLetterOrDigit(n)) {
                StyleEscapeFunction.VALID_CHARS[n] = true;
                StyleEscapeFunction.UNQUOTED_VALID_CHARS[n] = true;
                continue;
            }
            if (SPECIAL_CHARS.indexOf(n) != -1) {
                StyleEscapeFunction.VALID_CHARS[n] = true;
            }
            if (UNQUOTED_SPECIAL_CHARS.indexOf(n) == -1) continue;
            StyleEscapeFunction.UNQUOTED_VALID_CHARS[n] = true;
        }
    }
}

