/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;

public class Utf8Detector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("EnforceUTF8", "Encoding used in resource files is not UTF-8", "Checks that all XML resource files are using UTF-8 as the file encoding", "XML supports encoding in a wide variety of character sets. However, not all tools handle the XML encoding attribute correctly, and nearly all Android apps use UTF-8, so by using UTF-8 you can protect yourself against subtle bugs when using non-ASCII characters.", Category.I18N, 2, Severity.WARNING, new Implementation(Utf8Detector.class, Scope.RESOURCE_FILE_SCOPE));
    private static final Pattern ENCODING_PATTERN = Pattern.compile("encoding=['\"](\\S*)['\"]");

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public void visitDocument(@NonNull XmlContext context, @NonNull Document document) {
        Matcher matcher;
        char c;
        int lineEnd;
        String xml = context.getContents();
        if (xml == null) {
            return;
        }
        int max = xml.length();
        for (lineEnd = 0; lineEnd < max && (c = xml.charAt(lineEnd)) != '\n' && c != '\r'; ++lineEnd) {
        }
        for (int i = 16; i < lineEnd - 5; ++i) {
            if (xml.charAt(i) != 'u' && xml.charAt(i) != 'U' || xml.charAt(i + 1) != 't' && xml.charAt(i + 1) != 'T' || xml.charAt(i + 2) != 'f' && xml.charAt(i + 2) != 'F' || xml.charAt(i + 3) != '-' && xml.charAt(i + 3) != '_' || xml.charAt(i + 4) != '8') continue;
            return;
        }
        int encodingIndex = xml.lastIndexOf("encoding", lineEnd);
        if (encodingIndex != -1 && (matcher = ENCODING_PATTERN.matcher(xml)).find(encodingIndex)) {
            String encoding = matcher.group(1);
            Location location = Location.create(context.file, xml, matcher.start(1), matcher.end(1));
            context.report(ISSUE, null, location, String.format("%1$s: Not using UTF-8 as the file encoding. This can lead to subtle bugs with non-ascii characters", encoding), null);
        }
    }
}

