/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.VariableReference;
import org.w3c.dom.Element;

public class RequiredAttributeDetector
extends LayoutDetector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("RequiredSize", "Missing `layout_width` or `layout_height` attributes", "Ensures that the `layout_width` and `layout_height` are specified for all views", "All views must specify an explicit `layout_width` and `layout_height` attribute. There is a runtime check for this, so if you fail to specify a size, an exception is thrown at runtime.\n\nIt's possible to specify these widths via styles as well. GridLayout, as a special case, does not require you to specify a size.", Category.CORRECTNESS, 4, Severity.ERROR, new Implementation(RequiredAttributeDetector.class, EnumSet.of(Scope.JAVA_FILE, Scope.ALL_RESOURCE_FILES)));
    @Nullable
    private Map<String, String> mStyleParents;
    @Nullable
    private Set<String> mWidthStyles;
    @Nullable
    private Set<String> mHeightStyles;
    @Nullable
    private Set<String> mIncludedWidths;
    @Nullable
    private Set<String> mIncludedHeights;
    @Nullable
    private Set<String> mNotIncludedWidths;
    @Nullable
    private Set<String> mNotIncludedHeights;
    private boolean mSetWidthInTheme;
    private boolean mSetHeightInTheme;

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (context.getPhase() == 1) {
            this.checkSizeSetInTheme();
            context.requestRepeat(this, Scope.RESOURCE_FILE_SCOPE);
        }
    }

    private boolean isWidthStyle(String style) {
        return this.isSizeStyle(style, this.mWidthStyles);
    }

    private boolean isHeightStyle(String style) {
        return this.isSizeStyle(style, this.mHeightStyles);
    }

    private boolean isSizeStyle(String style, Set<String> sizeStyles) {
        if (RequiredAttributeDetector.isFrameworkSizeStyle(style)) {
            return true;
        }
        if (sizeStyles == null) {
            return false;
        }
        return this.isSizeStyle(RequiredAttributeDetector.stripStylePrefix(style), sizeStyles, 0);
    }

    private static boolean isFrameworkSizeStyle(String style) {
        if (style.equals("?android:attr/listSeparatorTextViewStyle") || style.equals("?android/listSeparatorTextViewStyle")) {
            return true;
        }
        return style.startsWith("?android:attr/quickContactBadgeStyle");
    }

    private boolean isSizeStyle(@NonNull String style, @NonNull Set<String> sizeStyles, int depth) {
        String parentStyle;
        if (depth == 30) {
            return false;
        }
        assert (!style.startsWith("@style/") && !style.startsWith("@android:style/"));
        if (sizeStyles.contains(style)) {
            return true;
        }
        if (this.mStyleParents != null && (parentStyle = this.mStyleParents.get(style)) != null && this.isSizeStyle(parentStyle = RequiredAttributeDetector.stripStylePrefix(parentStyle), sizeStyles, depth + 1)) {
            return true;
        }
        int index = style.lastIndexOf(46);
        if (index > 0) {
            return this.isSizeStyle(style.substring(0, index), sizeStyles, depth + 1);
        }
        return false;
    }

    private void checkSizeSetInTheme() {
        if (this.mStyleParents == null) {
            return;
        }
        HashMap isTheme = Maps.newHashMap();
        for (String style : this.mStyleParents.keySet()) {
            if (!this.isTheme(RequiredAttributeDetector.stripStylePrefix(style), isTheme, 0)) continue;
            this.mSetWidthInTheme = true;
            this.mSetHeightInTheme = true;
            break;
        }
    }

    private boolean isTheme(String style, Map<String, Boolean> isTheme, int depth) {
        String parentStyle;
        if (depth == 30) {
            return false;
        }
        assert (!style.startsWith("@style/") && !style.startsWith("@android:style/"));
        Boolean known = isTheme.get(style);
        if (known != null) {
            return known;
        }
        if (style.contains("Theme")) {
            isTheme.put(style, true);
            return true;
        }
        if (this.mStyleParents != null && (parentStyle = this.mStyleParents.get(style)) != null && this.isTheme(parentStyle = RequiredAttributeDetector.stripStylePrefix(parentStyle), isTheme, depth + 1)) {
            isTheme.put(style, true);
            return true;
        }
        int index = style.lastIndexOf(46);
        if (index > 0) {
            String parentStyle2 = style.substring(0, index);
            boolean result = this.isTheme(parentStyle2, isTheme, depth + 1);
            isTheme.put(style, result);
            return result;
        }
        return false;
    }

    private static boolean hasLayoutVariations(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        File res = file.getParentFile();
        if (res == null) {
            return false;
        }
        String name = file.getName();
        File[] folders = res.listFiles();
        if (folders == null) {
            return false;
        }
        for (File folder : folders) {
            File other;
            if (!folder.getName().startsWith("layout") || folder.equals(parent) || !(other = new File(folder, name)).exists()) continue;
            return true;
        }
        return false;
    }

    private static String stripStylePrefix(@NonNull String style) {
        if (style.startsWith("@style/")) {
            style = style.substring("@style/".length());
        } else if (style.startsWith("@android:style/")) {
            style = style.substring("@android:style/".length());
        }
        return style;
    }

    private static boolean isRootElement(@NonNull org.w3c.dom.Node node) {
        return node == node.getOwnerDocument().getDocumentElement();
    }

    @Override
    public Collection<String> getApplicableElements() {
        return ALL;
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        ResourceFolderType folderType = context.getResourceFolderType();
        int phase = context.getPhase();
        if (phase == 1 && folderType == ResourceFolderType.VALUES) {
            String tag = element.getTagName();
            if ("style".equals(tag)) {
                String name;
                String parent = element.getAttribute("parent");
                if (parent != null && !parent.isEmpty() && (name = element.getAttribute("name")) != null && !name.isEmpty()) {
                    if (this.mStyleParents == null) {
                        this.mStyleParents = Maps.newHashMap();
                    }
                    this.mStyleParents.put(name, parent);
                }
            } else if ("item".equals(tag) && "style".equals(element.getParentNode().getNodeName())) {
                String styleName;
                String name = element.getAttribute("name");
                if (name.endsWith("layout_width") && name.equals("android:layout_width")) {
                    if (this.mWidthStyles == null) {
                        this.mWidthStyles = Sets.newHashSet();
                    }
                    styleName = ((Element)element.getParentNode()).getAttribute("name");
                    this.mWidthStyles.add(styleName);
                }
                if (name.endsWith("layout_height") && name.equals("android:layout_height")) {
                    if (this.mHeightStyles == null) {
                        this.mHeightStyles = Sets.newHashSet();
                    }
                    styleName = ((Element)element.getParentNode()).getAttribute("name");
                    this.mHeightStyles.add(styleName);
                }
            }
        } else if (folderType == ResourceFolderType.LAYOUT) {
            if (phase == 1) {
                String layout;
                if (element.getTagName().equals("include") && (layout = element.getAttribute("layout")) != null && !layout.isEmpty()) {
                    this.recordIncludeWidth(layout, element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_width"));
                    this.recordIncludeHeight(layout, element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_height"));
                }
            } else {
                String message;
                String parentTag;
                assert (phase == 2);
                boolean hasWidth = element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_width");
                boolean hasHeight = element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_height");
                if (this.mSetWidthInTheme) {
                    hasWidth = true;
                }
                if (this.mSetHeightInTheme) {
                    hasHeight = true;
                }
                if (hasWidth && hasHeight) {
                    return;
                }
                String tag = element.getTagName();
                if ("merge".equals(tag) || "include".equals(tag) || "requestFocus".equals(tag)) {
                    return;
                }
                String string = parentTag = element.getParentNode() != null ? element.getParentNode().getNodeName() : "";
                if ("TableLayout".equals(parentTag) || "TableRow".equals(parentTag) || "GridLayout".equals(parentTag) || "android.support.v7.widget.GridLayout".equals(parentTag)) {
                    return;
                }
                if (!context.getProject().getReportIssues()) {
                    return;
                }
                boolean certain = true;
                boolean isRoot = RequiredAttributeDetector.isRootElement(element);
                if (isRoot || RequiredAttributeDetector.isRootElement(element.getParentNode()) && "merge".equals(parentTag)) {
                    String name = "@layout/" + LintUtils.getLayoutName(context.file);
                    if (!hasWidth && this.mIncludedWidths != null) {
                        hasWidth = this.mIncludedWidths.contains(name);
                        if (this.mNotIncludedWidths != null && this.mNotIncludedWidths.contains(name)) {
                            hasWidth = false;
                            boolean bl = certain = !RequiredAttributeDetector.hasLayoutVariations(context.file);
                        }
                    }
                    if (!hasHeight && this.mIncludedHeights != null) {
                        hasHeight = this.mIncludedHeights.contains(name);
                        if (this.mNotIncludedHeights != null && this.mNotIncludedHeights.contains(name)) {
                            hasHeight = false;
                            boolean bl = certain = !RequiredAttributeDetector.hasLayoutVariations(context.file);
                        }
                    }
                    if (hasWidth && hasHeight) {
                        return;
                    }
                }
                if (!hasWidth || !hasHeight) {
                    String style = element.getAttribute("style");
                    if (style != null && !style.isEmpty()) {
                        if (!hasWidth) {
                            hasWidth = this.isWidthStyle(style);
                        }
                        if (!hasHeight) {
                            hasHeight = this.isHeightStyle(style);
                        }
                    }
                    if (hasWidth && hasHeight) {
                        return;
                    }
                }
                if (!hasWidth && !hasHeight) {
                    message = certain ? "The required layout_width and layout_height attributes are missing" : "The required layout_width and layout_height attributes *may* be missing";
                } else {
                    String attribute = hasWidth ? "layout_height" : "layout_width";
                    message = certain ? String.format("The required %1$s attribute is missing", attribute) : String.format("The required %1$s attribute *may* be missing", attribute);
                }
                context.report(ISSUE, element, context.getLocation(element), message, null);
            }
        }
    }

    private void recordIncludeWidth(String layout, boolean providesWidth) {
        if (providesWidth) {
            if (this.mIncludedWidths == null) {
                this.mIncludedWidths = Sets.newHashSet();
            }
            this.mIncludedWidths.add(layout);
        } else {
            if (this.mNotIncludedWidths == null) {
                this.mNotIncludedWidths = Sets.newHashSet();
            }
            this.mNotIncludedWidths.add(layout);
        }
    }

    private void recordIncludeHeight(String layout, boolean providesHeight) {
        if (providesHeight) {
            if (this.mIncludedHeights == null) {
                this.mIncludedHeights = Sets.newHashSet();
            }
            this.mIncludedHeights.add(layout);
        } else {
            if (this.mNotIncludedHeights == null) {
                this.mNotIncludedHeights = Sets.newHashSet();
            }
            this.mNotIncludedHeights.add(layout);
        }
    }

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("inflate");
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation call) {
        int viewRootPos;
        StrictListAccessor args = call.astArguments();
        String layout = null;
        int index = 0;
        for (Expression expression : args) {
            VariableReference reference;
            Select inner;
            Select outer;
            Expression operand;
            if (expression instanceof Select && (operand = (outer = (Select)expression).astOperand()) instanceof Select && (inner = (Select)operand).astOperand() instanceof VariableReference && "R".equals((reference = (VariableReference)inner.astOperand()).astIdentifier().astValue()) && "layout".equals(inner.astIdentifier().astValue())) {
                layout = "@layout/" + outer.astIdentifier().astValue();
                break;
            }
            ++index;
        }
        if (layout == null) {
            Node method = StringFormatDetector.getParentMethod((Node)call);
            if (method != null) {
                index = 0;
                String name = StringFormatDetector.getResourceArg(method, (Node)call, index);
                if (name == null) {
                    index = 1;
                    name = StringFormatDetector.getResourceArg(method, (Node)call, index);
                }
                if (name != null) {
                    layout = "@layout/" + name;
                }
            }
            if (layout == null) {
                return;
            }
        }
        if ((viewRootPos = index + 1) < args.size()) {
            Expression viewRoot;
            Iterator iterator = args.iterator();
            for (int i = 0; iterator.hasNext() && i < viewRootPos; ++i) {
                iterator.next();
            }
            if (iterator.hasNext() && (viewRoot = (Expression)iterator.next()) instanceof NullLiteral) {
                this.recordIncludeWidth(layout, true);
                this.recordIncludeHeight(layout, true);
            }
        }
    }
}

