/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.peephole.ClassMerger;

public class RetargetedInnerClassAttributeRemover
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
ConstantVisitor {
    private boolean retargeted;

    public void visitProgramClass(ProgramClass programClass) {
        int n = programClass.u2attributesCount;
        Object[] objectArray = programClass.attributes;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Attribute attribute = objectArray[i];
            this.retargeted = false;
            attribute.accept(programClass, this);
            if (this.retargeted) continue;
            objectArray[n2++] = attribute;
        }
        Arrays.fill(objectArray, n2, n, null);
        programClass.u2attributesCount = n2;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        this.checkTarget(clazz);
        if (!this.retargeted) {
            innerClassesAttribute.innerClassEntriesAccept(clazz, this);
            int n = innerClassesAttribute.u2classesCount;
            Object[] objectArray = innerClassesAttribute.classes;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                InnerClassesInfo innerClassesInfo = objectArray[i];
                this.retargeted = false;
                innerClassesInfo.outerClassConstantAccept(clazz, this);
                innerClassesInfo.innerClassConstantAccept(clazz, this);
                if (this.retargeted) continue;
                objectArray[n2++] = innerClassesInfo;
            }
            Arrays.fill(objectArray, n2, n, null);
            innerClassesAttribute.u2classesCount = n2;
            this.retargeted = n2 == 0;
        }
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        this.checkTarget(clazz);
        this.checkTarget(enclosingMethodAttribute.referencedClass);
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        innerClassesInfo.innerClassConstantAccept(clazz, this);
        innerClassesInfo.outerClassConstantAccept(clazz, this);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.checkTarget(classConstant.referencedClass);
    }

    private void checkTarget(Clazz clazz) {
        if (clazz != null && ClassMerger.getTargetClass(clazz) != null) {
            this.retargeted = true;
        }
    }
}

