/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.SdkConstants;
import com.android.annotations.Nullable;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.Warning;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.SdkUtils;
import com.google.common.annotations.Beta;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Beta
public abstract class Reporter {
    protected final LintCliClient mClient;
    protected final File mOutput;
    protected String mTitle = "Lint Report";
    protected boolean mSimpleFormat;
    protected boolean mBundleResources;
    protected Map<String, String> mUrlMap;
    protected File mResources;
    protected final Map<File, String> mResourceUrl = new HashMap<File, String>();
    protected final Map<String, File> mNameToFile = new HashMap<String, File>();

    public abstract void write(int var1, int var2, List<Warning> var3) throws IOException;

    protected Reporter(LintCliClient client, File output) {
        this.mClient = client;
        this.mOutput = output;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setBundleResources(boolean bundleResources) {
        this.mBundleResources = bundleResources;
        this.mSimpleFormat = false;
    }

    public void setSimpleFormat(boolean simpleFormat) {
        this.mSimpleFormat = simpleFormat;
    }

    public boolean isSimpleFormat() {
        return this.mSimpleFormat;
    }

    String getUrl(File file) {
        String relativePath;
        String url;
        if (this.mBundleResources && !this.mSimpleFormat && (url = this.getRelativeResourceUrl(file)) != null) {
            return url;
        }
        if (this.mUrlMap != null) {
            String path = file.getAbsolutePath();
            String pathUrl = Reporter.encodeUrl(path);
            for (Map.Entry<String, String> entry : this.mUrlMap.entrySet()) {
                String prefix = entry.getKey();
                String prefixUrl = Reporter.encodeUrl(prefix);
                if (!pathUrl.startsWith(prefixUrl)) continue;
                String relative = pathUrl.substring(prefixUrl.length());
                return entry.getValue() + relative;
            }
        }
        if (file.isAbsolute() && (relativePath = Reporter.getRelativePath(this.mOutput.getParentFile(), file)) != null) {
            relativePath = relativePath.replace(File.separatorChar, '/');
            return Reporter.encodeUrl(relativePath);
        }
        try {
            return SdkUtils.fileToUrlString((File)file);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    static String encodeUrl(String url) {
        try {
            url = url.replace('\\', '/');
            return URLEncoder.encode(url, "UTF-8").replace("%2F", "/");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Invalid string " + e.getLocalizedMessage());
            return url;
        }
    }

    public void setUrlMap(@Nullable Map<String, String> urlMap) {
        this.mUrlMap = urlMap;
    }

    File getResourceDir() {
        if (this.mResources == null && this.mBundleResources) {
            this.mResources = this.computeResourceDir();
            if (this.mResources == null) {
                this.mBundleResources = false;
            }
        }
        return this.mResources;
    }

    File computeResourceDir() {
        File resources;
        String fileName = this.mOutput.getName();
        int dot = fileName.indexOf(46);
        if (dot != -1) {
            fileName = fileName.substring(0, dot);
        }
        if (!(resources = new File(this.mOutput.getParentFile(), fileName + "_files")).exists() && !resources.mkdir()) {
            resources = null;
        }
        return resources;
    }

    protected String getRelativeResourceUrl(File file) {
        String resource = this.mResourceUrl.get(file);
        if (resource != null) {
            return resource;
        }
        String name = file.getName();
        if (!LintUtils.endsWith(name, ".png") || LintUtils.endsWith(name, ".9.png")) {
            return null;
        }
        File resourceDir = this.getResourceDir();
        if (resourceDir != null) {
            String base = file.getName();
            File path = this.mNameToFile.get(base);
            if (path != null && !path.equals(file)) {
                for (int i = 0; i < 100 && (path = this.mNameToFile.get(base = '_' + base)) != null && !path.equals(file); ++i) {
                }
            }
            File target = new File(resourceDir, base);
            try {
                Files.copy((File)file, (File)target);
            }
            catch (IOException e) {
                return null;
            }
            return resourceDir.getName() + '/' + Reporter.encodeUrl(base);
        }
        return null;
    }

    protected String addLocalResources(URL url) {
        File resourceDir = this.computeResourceDir();
        if (resourceDir != null) {
            String base = url.getFile();
            base = base.substring(base.lastIndexOf(47) + 1);
            this.mNameToFile.put(base, new File(url.toExternalForm()));
            File target = new File(resourceDir, base);
            try {
                FileOutputStream output = new FileOutputStream(target);
                InputStream input = url.openStream();
                ByteStreams.copy((InputStream)input, (OutputStream)output);
                Closeables.closeQuietly((Closeable)output);
                Closeables.closeQuietly((Closeable)input);
            }
            catch (IOException e) {
                return null;
            }
            return resourceDir.getName() + '/' + Reporter.encodeUrl(base);
        }
        return null;
    }

    @Nullable
    static String getRelativePath(File base, File file) {
        int len;
        String filePathToCompare;
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        basePath = !basePath.isEmpty() && basePath.charAt(basePath.length() - 1) == File.separatorChar ? basePath : basePath + File.separatorChar;
        boolean caseSensitive = SdkConstants.CURRENT_PLATFORM == 1;
        Locale l = Locale.getDefault();
        String basePathToCompare = caseSensitive ? basePath : basePath.toLowerCase(l);
        if (basePathToCompare.equals(!(filePathToCompare = caseSensitive ? filePath : filePath.toLowerCase(l)).isEmpty() && filePathToCompare.charAt(filePathToCompare.length() - 1) == File.separatorChar ? filePathToCompare : filePathToCompare + File.separatorChar)) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        for (len = 0; len < filePath.length() && len < basePath.length() && filePathToCompare.charAt(len) == basePathToCompare.charAt(len); ++len) {
            if (basePath.charAt(len) != File.separatorChar) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != File.separatorChar) continue;
            relativePath.append("..");
            relativePath.append(File.separatorChar);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }
}

