/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.descriptors;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IPkgDescExtra;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;

public final class PkgDescExtra
extends PkgDesc
implements IPkgDescExtra {
    private final NoPreviewRevision mRevision;
    private final String mVendorId;
    private final String mPath;
    private final String[] mOldPaths;

    PkgDescExtra(@NonNull String vendorId, @NonNull String path, @Nullable String[] oldPaths, @NonNull NoPreviewRevision revision) {
        this.mVendorId = vendorId;
        this.mPath = path;
        this.mOldPaths = oldPaths != null ? oldPaths : new String[]{};
        this.mRevision = revision;
    }

    @Override
    @NonNull
    public PkgType getType() {
        return PkgType.PKG_EXTRAS;
    }

    @Override
    @NonNull
    public FullRevision getFullRevision() {
        return this.mRevision;
    }

    @Override
    @NonNull
    public String getPath() {
        return this.mPath;
    }

    @Override
    @NonNull
    public String[] getOldPaths() {
        return this.mOldPaths;
    }

    @Override
    @NonNull
    public String getVendorId() {
        return this.mVendorId;
    }

    @Override
    public boolean isUpdateFor(@NonNull IPkgDesc existingDesc) {
        return this.isGenericUpdateFor(existingDesc);
    }

    @NonNull
    public static String[] convertOldPaths(@Nullable String oldPathsProperty) {
        if (oldPathsProperty == null || oldPathsProperty.length() == 0) {
            return new String[0];
        }
        return oldPathsProperty.split(";");
    }

    public static boolean compatibleVendorAndPath(@NonNull IPkgDescExtra lhs, @NonNull IPkgDescExtra rhs) {
        String[] epOldPaths = rhs.getOldPaths();
        int lenEpOldPaths = epOldPaths.length;
        for (int indexEp = -1; indexEp < lenEpOldPaths; ++indexEp) {
            if (!PkgDescExtra.sameVendorAndPath(lhs.getVendorId(), lhs.getPath(), rhs.getVendorId(), indexEp < 0 ? rhs.getPath() : epOldPaths[indexEp])) continue;
            return true;
        }
        String[] thisOldPaths = lhs.getOldPaths();
        int lenThisOldPaths = thisOldPaths.length;
        for (int indexThis = -1; indexThis < lenThisOldPaths; ++indexThis) {
            if (!PkgDescExtra.sameVendorAndPath(lhs.getVendorId(), indexThis < 0 ? lhs.getPath() : thisOldPaths[indexThis], rhs.getVendorId(), rhs.getPath())) continue;
            return true;
        }
        return false;
    }

    private static boolean sameVendorAndPath(@Nullable String thisVendor, @Nullable String thisPath, @Nullable String otherVendor, @Nullable String otherPath) {
        if (otherPath != null && thisPath != null && thisVendor != null && otherPath.equals(thisVendor + '-' + thisPath) && (otherVendor == null || otherVendor.length() == 0 || otherVendor.equals(thisVendor))) {
            return true;
        }
        if (thisPath != null && otherPath != null && otherVendor != null && thisPath.equals(otherVendor + '-' + otherPath) && (thisVendor == null || thisVendor.length() == 0 || thisVendor.equals(otherVendor))) {
            return true;
        }
        return thisPath != null && thisPath.equals(otherPath) && (thisVendor == null && otherVendor == null || thisVendor != null && thisVendor.equals(otherVendor));
    }
}

