/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.descriptors;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.descriptors.IAddonDesc;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IPkgDescExtra;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDescAddon;
import com.android.sdklib.repository.descriptors.PkgDescExtra;
import com.android.sdklib.repository.descriptors.PkgType;
import java.util.Locale;

public abstract class PkgDesc
implements IPkgDesc {
    @Override
    @NonNull
    public abstract PkgType getType();

    @Override
    public final boolean hasFullRevision() {
        return this.getType().hasFullRevision();
    }

    @Override
    public final boolean hasMajorRevision() {
        return this.getType().hasMajorRevision();
    }

    @Override
    public final boolean hasAndroidVersion() {
        return this.getType().hasAndroidVersion();
    }

    @Override
    public final boolean hasPath() {
        return this.getType().hasPath();
    }

    @Override
    public final boolean hasTag() {
        return this.getType().hasTag();
    }

    @Override
    public boolean hasVendorId() {
        return this.getType().hasVendorId();
    }

    @Override
    public final boolean hasMinToolsRev() {
        return this.getType().hasMinToolsRev();
    }

    @Override
    public final boolean hasMinPlatformToolsRev() {
        return this.getType().hasMinPlatformToolsRev();
    }

    @Override
    @Nullable
    public FullRevision getFullRevision() {
        return null;
    }

    @Override
    @Nullable
    public MajorRevision getMajorRevision() {
        return null;
    }

    @Override
    @Nullable
    public AndroidVersion getAndroidVersion() {
        return null;
    }

    @Override
    @Nullable
    public String getPath() {
        return null;
    }

    @Override
    @Nullable
    public IdDisplay getTag() {
        return null;
    }

    @Override
    @Nullable
    public String getVendorId() {
        return null;
    }

    @Override
    @Nullable
    public FullRevision getMinToolsRev() {
        return null;
    }

    @Override
    @Nullable
    public FullRevision getMinPlatformToolsRev() {
        return null;
    }

    protected final boolean isGenericUpdateFor(@NonNull IPkgDesc existingDesc) {
        if (existingDesc == null || !this.getType().equals(existingDesc.getType())) {
            return false;
        }
        if (this.hasAndroidVersion() && !this.getAndroidVersion().equals(existingDesc.getAndroidVersion())) {
            return false;
        }
        if (this.hasVendorId() && !this.getVendorId().equals(existingDesc.getVendorId())) {
            return false;
        }
        if (this.hasTag() && !this.getTag().getId().equals(existingDesc.getTag().getId())) {
            return false;
        }
        if (this.hasPath() && (this instanceof IPkgDescExtra ? !PkgDescExtra.compatibleVendorAndPath((IPkgDescExtra)((Object)this), (IPkgDescExtra)existingDesc) : !this.getPath().equals(existingDesc.getPath()))) {
            return false;
        }
        if (this.hasMajorRevision() && this.getMajorRevision().compareTo(existingDesc.getMajorRevision()) > 0) {
            return true;
        }
        if (this.hasFullRevision() && this.getFullRevision().isPreview() == existingDesc.getFullRevision().isPreview()) {
            return this.getFullRevision().compareTo(existingDesc.getFullRevision(), FullRevision.PreviewComparison.COMPARE_NUMBER) > 0;
        }
        return false;
    }

    @Override
    public int compareTo(@NonNull IPkgDesc o) {
        int t2;
        int t1 = this.getType().getIntValue();
        if (t1 != (t2 = o.getType().getIntValue())) {
            return t1 - t2;
        }
        if (this.hasAndroidVersion() && o.hasAndroidVersion() && (t1 = this.getAndroidVersion().compareTo(o.getAndroidVersion())) != 0) {
            return t1;
        }
        if (this.hasVendorId() && o.hasVendorId() && (t1 = this.getVendorId().compareTo(o.getVendorId())) != 0) {
            return t1;
        }
        if (this.hasTag() && o.hasTag() && (t1 = this.getTag().compareTo(o.getTag())) != 0) {
            return t1;
        }
        if (this.hasPath() && o.hasPath() && (t1 = this.getPath().compareTo(o.getPath())) != 0) {
            return t1;
        }
        if (this.hasFullRevision() && o.hasFullRevision() && (t1 = this.getFullRevision().compareTo(o.getFullRevision())) != 0) {
            return t1;
        }
        if (this.hasMajorRevision() && o.hasMajorRevision() && (t1 = this.getMajorRevision().compareTo(o.getMajorRevision())) != 0) {
            return t1;
        }
        if (this.hasMinToolsRev() && o.hasMinToolsRev() && (t1 = this.getMinToolsRev().compareTo(o.getMinToolsRev())) != 0) {
            return t1;
        }
        if (this.hasMinPlatformToolsRev() && o.hasMinPlatformToolsRev() && (t1 = this.getMinPlatformToolsRev().compareTo(o.getMinPlatformToolsRev())) != 0) {
            return t1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<PkgDesc");
        builder.append(" Type=");
        builder.append(this.getType().toString().toLowerCase(Locale.US).replace("pkg_", ""));
        if (this.hasAndroidVersion()) {
            builder.append(" Android=").append(this.getAndroidVersion());
        }
        if (this.hasVendorId()) {
            builder.append(" Vendor=").append(this.getVendorId());
        }
        if (this.hasTag()) {
            builder.append(" Tag=").append(this.getTag());
        }
        if (this.hasPath()) {
            builder.append(" Path=").append(this.getPath());
        }
        if (this.hasFullRevision()) {
            builder.append(" FullRev=").append(this.getFullRevision());
        }
        if (this.hasMajorRevision()) {
            builder.append(" MajorRev=").append(this.getMajorRevision());
        }
        if (this.hasMinToolsRev()) {
            builder.append(" MinToolsRev=").append(this.getMinToolsRev());
        }
        if (this.hasMinPlatformToolsRev()) {
            builder.append(" MinPlatToolsRev=").append(this.getMinPlatformToolsRev());
        }
        builder.append('>');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hasAndroidVersion() ? this.getAndroidVersion().hashCode() : 0);
        result = 31 * result + (this.hasVendorId() ? this.getVendorId().hashCode() : 0);
        result = 31 * result + (this.hasTag() ? this.getTag().hashCode() : 0);
        result = 31 * result + (this.hasPath() ? this.getPath().hashCode() : 0);
        result = 31 * result + (this.hasFullRevision() ? this.getFullRevision().hashCode() : 0);
        result = 31 * result + (this.hasMajorRevision() ? this.getMajorRevision().hashCode() : 0);
        result = 31 * result + (this.hasMinToolsRev() ? this.getMinToolsRev().hashCode() : 0);
        result = 31 * result + (this.hasMinPlatformToolsRev() ? this.getMinPlatformToolsRev().hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IPkgDesc)) {
            return false;
        }
        IPkgDesc rhs = (IPkgDesc)obj;
        if (this.hasAndroidVersion() != rhs.hasAndroidVersion()) {
            return false;
        }
        if (this.hasAndroidVersion() && !this.getAndroidVersion().equals(rhs.getAndroidVersion())) {
            return false;
        }
        if (this.hasTag() != rhs.hasTag()) {
            return false;
        }
        if (this.hasTag() && !this.getTag().equals(rhs.getTag())) {
            return false;
        }
        if (this.hasPath() != rhs.hasPath()) {
            return false;
        }
        if (this.hasPath() && !this.getPath().equals(rhs.getPath())) {
            return false;
        }
        if (this.hasFullRevision() != rhs.hasFullRevision()) {
            return false;
        }
        if (this.hasFullRevision() && !this.getFullRevision().equals(rhs.getFullRevision())) {
            return false;
        }
        if (this.hasMajorRevision() != rhs.hasMajorRevision()) {
            return false;
        }
        if (this.hasMajorRevision() && !this.getMajorRevision().equals(rhs.getMajorRevision())) {
            return false;
        }
        if (this.hasMinToolsRev() != rhs.hasMinToolsRev()) {
            return false;
        }
        if (this.hasMinToolsRev() && !this.getMinToolsRev().equals(rhs.getMinToolsRev())) {
            return false;
        }
        if (this.hasMinPlatformToolsRev() != rhs.hasMinPlatformToolsRev()) {
            return false;
        }
        return !this.hasMinPlatformToolsRev() || this.getMinPlatformToolsRev().equals(rhs.getMinPlatformToolsRev());
    }

    @NonNull
    public static IPkgDesc newTool(final @NonNull FullRevision revision, final @NonNull FullRevision minPlatformToolsRev) {
        return new PkgDesc(){

            @Override
            public PkgType getType() {
                return PkgType.PKG_TOOLS;
            }

            @Override
            public FullRevision getFullRevision() {
                return revision;
            }

            @Override
            public FullRevision getMinPlatformToolsRev() {
                return minPlatformToolsRev;
            }

            @Override
            public boolean isUpdateFor(@NonNull IPkgDesc existingDesc) {
                return this.isGenericUpdateFor(existingDesc);
            }
        };
    }

    @NonNull
    public static IPkgDesc newPlatformTool(final @NonNull FullRevision revision) {
        return new PkgDesc(){

            @Override
            public PkgType getType() {
                return PkgType.PKG_PLATFORM_TOOLS;
            }

            @Override
            public FullRevision getFullRevision() {
                return revision;
            }

            @Override
            public boolean isUpdateFor(@NonNull IPkgDesc existingDesc) {
                return this.isGenericUpdateFor(existingDesc);
            }
        };
    }

    @NonNull
    public static IPkgDesc newBuildTool(final @NonNull FullRevision revision) {
        return new PkgDesc(){

            @Override
            public PkgType getType() {
                return PkgType.PKG_BUILD_TOOLS;
            }

            @Override
            public FullRevision getFullRevision() {
                return revision;
            }

            @Override
            public boolean isUpdateFor(@NonNull IPkgDesc existingDesc) {
                return this.isGenericUpdateFor(existingDesc) && revision.compareTo(existingDesc.getFullRevision(), FullRevision.PreviewComparison.COMPARE_TYPE) == 0;
            }
        };
    }

    @NonNull
    public static IPkgDesc newDoc(final @NonNull AndroidVersion version, final @NonNull MajorRevision revision) {
        return new PkgDesc(){

            @Override
            public PkgType getType() {
                return PkgType.PKG_DOCS;
            }

            @Override
            public MajorRevision getMajorRevision() {
                return revision;
            }

            @Override
            public AndroidVersion getAndroidVersion() {
                return version;
            }

            @Override
            public boolean isUpdateFor(@NonNull IPkgDesc existingDesc) {
                if (existingDesc == null || !this.getType().equals(existingDesc.getType())) {
                    return false;
                }
                int diff = version.compareTo(existingDesc.getAndroidVersion());
                return diff > 0 || diff == 0 && revision.compareTo(existingDesc.getMajorRevision()) > 0;
            }
        };
    }

    @NonNull
    public static IPkgDescExtra newExtra(@NonNull String vendorId, @NonNull String path, @Nullable String[] oldPaths, @NonNull NoPreviewRevision revision) {
        return new PkgDescExtra(vendorId, path, oldPaths, revision);
    }

    @NonNull
    public static IPkgDesc newPlatform(final @NonNull AndroidVersion version, final @NonNull MajorRevision revision, final @NonNull FullRevision minToolsRev) {
        return new PkgDesc(){

            @Override
            public PkgType getType() {
                return PkgType.PKG_PLATFORMS;
            }

            @Override
            public MajorRevision getMajorRevision() {
                return revision;
            }

            @Override
            public AndroidVersion getAndroidVersion() {
                return version;
            }

            @Override
            public FullRevision getMinToolsRev() {
                return minToolsRev;
            }

            @Override
            public String getPath() {
                return AndroidTargetHash.getPlatformHashString(this.getAndroidVersion());
            }

            @Override
            public boolean isUpdateFor(@NonNull IPkgDesc existingDesc) {
                return this.isGenericUpdateFor(existingDesc);
            }
        };
    }

    @NonNull
    public static IPkgDesc newAddon(@NonNull AndroidVersion version, @NonNull MajorRevision revision, @NonNull String addonVendor, @NonNull String addonName) {
        return new PkgDescAddon(version, revision, addonVendor, addonName);
    }

    @NonNull
    public static IPkgDesc newAddon(@NonNull AndroidVersion version, @NonNull MajorRevision revision, @NonNull IAddonDesc targetHashProvider) {
        return new PkgDescAddon(version, revision, targetHashProvider);
    }

    @NonNull
    public static IPkgDesc newSysImg(final @NonNull AndroidVersion version, final @NonNull IdDisplay tag, final @NonNull String abi, final @NonNull MajorRevision revision) {
        return new PkgDesc(){

            @Override
            public PkgType getType() {
                return PkgType.PKG_SYS_IMAGES;
            }

            @Override
            public MajorRevision getMajorRevision() {
                return revision;
            }

            @Override
            public AndroidVersion getAndroidVersion() {
                return version;
            }

            @Override
            public IdDisplay getTag() {
                return tag;
            }

            @Override
            public String getPath() {
                return abi;
            }

            @Override
            public boolean isUpdateFor(@NonNull IPkgDesc existingDesc) {
                return this.isGenericUpdateFor(existingDesc);
            }
        };
    }

    @NonNull
    public static IPkgDesc newSource(final @NonNull AndroidVersion version, final @NonNull MajorRevision revision) {
        return new PkgDesc(){

            @Override
            public PkgType getType() {
                return PkgType.PKG_SOURCES;
            }

            @Override
            public MajorRevision getMajorRevision() {
                return revision;
            }

            @Override
            public AndroidVersion getAndroidVersion() {
                return version;
            }

            @Override
            public boolean isUpdateFor(@NonNull IPkgDesc existingDesc) {
                return this.isGenericUpdateFor(existingDesc);
            }
        };
    }

    @NonNull
    public static IPkgDesc newSample(final @NonNull AndroidVersion version, final @NonNull MajorRevision revision, final @NonNull FullRevision minToolsRev) {
        return new PkgDesc(){

            @Override
            public PkgType getType() {
                return PkgType.PKG_SAMPLES;
            }

            @Override
            public MajorRevision getMajorRevision() {
                return revision;
            }

            @Override
            public AndroidVersion getAndroidVersion() {
                return version;
            }

            @Override
            public FullRevision getMinToolsRev() {
                return minToolsRev;
            }

            @Override
            public boolean isUpdateFor(@NonNull IPkgDesc existingDesc) {
                return this.isGenericUpdateFor(existingDesc);
            }
        };
    }
}

