/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.project;

import com.android.SdkConstants;
import com.android.io.FileWrapper;
import com.android.io.FolderWrapper;
import com.android.io.IAbstractFolder;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import com.android.utils.ILogger;
import com.android.xml.AndroidManifest;
import com.android.xml.AndroidXPathFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ProjectCreator {
    private static final int MIN_BUILD_VERSION_TAG = 1;
    private static final String PH_PACKAGE_PATH = "PACKAGE_PATH";
    private static final String PH_PACKAGE = "PACKAGE";
    @Deprecated
    private static final String PH_ACTIVITY_NAME = "ACTIVITY_NAME";
    private static final String PH_ACTIVITY_ENTRY_NAME = "ACTIVITY_ENTRY_NAME";
    private static final String PH_ACTIVITY_CLASS_NAME = "ACTIVITY_CLASS_NAME";
    private static final String PH_ACTIVITY_FQ_NAME = "ACTIVITY_FQ_NAME";
    private static final String PH_ACTIVITY_TESTED_CLASS_NAME = "ACTIVITY_TESTED_CLASS_NAME";
    public static final String PH_PROJECT_NAME = "PROJECT_NAME";
    private static final String PH_ICON = "ICON";
    private static final String PH_VERSION_TAG = "VERSION_TAG";
    private static final String PH_TARGET = "TARGET";
    private static final String PH_PLUGIN = "PLUGIN";
    private static final String PH_ARTIFACT_VERSION = "ARTIFACT_VERSION";
    private static final String PH_BUILD_TOOL_REV = "BUILD_TOOL_REV";
    private static final String XPATH_PROJECT_NAME = "/project/@name";
    public static final Pattern RE_PROJECT_NAME = Pattern.compile("[a-zA-Z0-9_]+");
    public static final String CHARS_PROJECT_NAME = "a-z A-Z 0-9 _";
    public static final Pattern RE_PACKAGE_NAME = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+");
    public static final String CHARS_PACKAGE_NAME = "a-z A-Z 0-9 _";
    public static final Pattern RE_ACTIVITY_NAME = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    public static final String CHARS_ACTIVITY_NAME = "a-z A-Z 0-9 _";
    private static final String PLUGIN_PROJECT = "android";
    private static final String PLUGIN_LIB_PROJECT = "android-library";
    private final OutputLevel mLevel;
    private final ILogger mLog;
    private final String mSdkFolder;
    private final SdkManager mSdkManager;

    public ProjectCreator(SdkManager sdkManager, String sdkFolder, OutputLevel level, ILogger log) {
        this.mSdkManager = sdkManager;
        this.mSdkFolder = sdkFolder;
        this.mLevel = level;
        this.mLog = log;
    }

    public void createProject(String folderPath, String projectName, String packageName, String activityEntry, IAndroidTarget target, boolean library, String pathToMainProject) {
        File projectFolder = this.checkNewProjectLocation(folderPath);
        if (projectFolder == null) {
            return;
        }
        try {
            boolean isTestProject = pathToMainProject != null;
            ProjectPropertiesWorkingCopy localProperties = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.LOCAL);
            localProperties.setProperty("sdk.dir", this.mSdkFolder);
            localProperties.save();
            ProjectPropertiesWorkingCopy projectProperties = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.PROJECT);
            projectProperties.setProperty("target", target.hashString());
            if (library) {
                projectProperties.setProperty("android.library", "true");
            }
            projectProperties.save();
            ProjectPropertiesWorkingCopy antProperties = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.ANT);
            if (isTestProject) {
                antProperties.setProperty("tested.project.dir", pathToMainProject);
            }
            antProperties.save();
            HashMap<String, String> keywords = new HashMap<String, String>();
            String packagePath = ProjectCreator.stripString(packageName.replace(".", File.separator), File.separatorChar);
            keywords.put(PH_PACKAGE_PATH, packagePath);
            keywords.put(PH_PACKAGE, packageName);
            keywords.put(PH_VERSION_TAG, Integer.toString(1));
            String fqActivityName = null;
            String activityPath = null;
            String activityClassName = null;
            String originalActivityEntry = activityEntry;
            String originalActivityClassName = null;
            if (activityEntry != null) {
                if (isTestProject) {
                    activityEntry = activityEntry + "Test";
                    int pos = originalActivityEntry.lastIndexOf(46);
                    originalActivityClassName = pos != -1 ? originalActivityEntry.substring(pos + 1) : originalActivityEntry;
                }
                fqActivityName = AndroidManifest.combinePackageAndClassName((String)packageName, (String)activityEntry);
                activityPath = ProjectCreator.stripString(fqActivityName.replace(".", File.separator), File.separatorChar);
                activityPath = activityPath.substring(0, activityPath.lastIndexOf(File.separatorChar));
                activityClassName = fqActivityName.substring(fqActivityName.lastIndexOf(46) + 1);
            }
            if (target.getVersion().getApiLevel() < 4) {
                if (originalActivityEntry != null) {
                    keywords.put(PH_ACTIVITY_NAME, originalActivityEntry);
                }
            } else if (activityEntry != null) {
                keywords.put(PH_ACTIVITY_ENTRY_NAME, activityEntry);
                keywords.put(PH_ACTIVITY_CLASS_NAME, activityClassName);
                keywords.put(PH_ACTIVITY_FQ_NAME, fqActivityName);
                if (originalActivityClassName != null) {
                    keywords.put(PH_ACTIVITY_TESTED_CLASS_NAME, originalActivityClassName);
                }
            }
            if (projectName != null) {
                keywords.put(PH_PROJECT_NAME, projectName);
            } else if (activityClassName != null) {
                keywords.put(PH_PROJECT_NAME, activityClassName);
            } else {
                projectName = projectFolder.getName();
                keywords.put(PH_PROJECT_NAME, projectName);
            }
            if (activityClassName != null) {
                String srcActivityFolderPath = "src" + File.separator + activityPath;
                File sourceFolder = this.createDirs(projectFolder, srcActivityFolderPath);
                String javaTemplate = isTestProject ? "java_tests_file.template" : "java_file.template";
                String activityFileName = activityClassName + ".java";
                this.installTargetTemplate(javaTemplate, new File(sourceFolder, activityFileName), keywords, target);
            } else {
                this.createDirs(projectFolder, "src");
            }
            File resourceFolder = this.createDirs(projectFolder, "res");
            this.createDirs(projectFolder, "bin");
            this.createDirs(projectFolder, "libs");
            if (!isTestProject) {
                File valueFolder = this.createDirs(resourceFolder, "values");
                this.installTargetTemplate("strings.template", new File(valueFolder, "strings.xml"), keywords, target);
                File layoutFolder = this.createDirs(resourceFolder, "layout");
                this.installTargetTemplate("layout.template", new File(layoutFolder, "main.xml"), keywords, target);
                if (this.installIcons(resourceFolder, target)) {
                    keywords.put(PH_ICON, "android:icon=\"@drawable/ic_launcher\"");
                } else {
                    keywords.put(PH_ICON, "");
                }
            }
            String manifestTemplate = "AndroidManifest.template";
            if (isTestProject) {
                manifestTemplate = "AndroidManifest.tests.template";
            }
            this.installTargetTemplate(manifestTemplate, new File(projectFolder, "AndroidManifest.xml"), keywords, target);
            this.installTemplate("build.template", new File(projectFolder, "build.xml"), keywords);
            this.installTemplate("proguard-project.txt", new File(projectFolder, "proguard-project.txt"), null);
        }
        catch (Exception e) {
            this.mLog.error((Throwable)e, null, new Object[0]);
        }
    }

    public void createGradleProject(String folderPath, String projectName, String packageName, String activityEntry, IAndroidTarget target, boolean library, String artifactVersion) {
        File projectFolder = this.checkNewProjectLocation(folderPath);
        if (projectFolder == null) {
            return;
        }
        try {
            ProjectPropertiesWorkingCopy localProperties = ProjectProperties.create(folderPath, ProjectProperties.PropertyType.LOCAL);
            localProperties.setProperty("sdk.dir", this.mSdkFolder);
            localProperties.save();
            HashMap<String, String> keywords = new HashMap<String, String>();
            HashMap<String, String> testKeywords = new HashMap<String, String>();
            String packagePath = ProjectCreator.stripString(packageName.replace(".", File.separator), File.separatorChar);
            keywords.put(PH_PACKAGE_PATH, packagePath);
            keywords.put(PH_PACKAGE, packageName);
            testKeywords.put(PH_PACKAGE_PATH, packagePath);
            testKeywords.put(PH_PACKAGE, packageName);
            String activityPath = null;
            String activityClassName = null;
            String testActivityPath = null;
            String testActivityClassName = null;
            if (activityEntry != null) {
                String fqActivityName = AndroidManifest.combinePackageAndClassName((String)packageName, (String)activityEntry);
                activityPath = ProjectCreator.stripString(fqActivityName.replace(".", File.separator), File.separatorChar);
                activityPath = activityPath.substring(0, activityPath.lastIndexOf(File.separatorChar));
                activityClassName = fqActivityName.substring(fqActivityName.lastIndexOf(46) + 1);
                String testActivityEntry = activityEntry + "Test";
                String testFqActivityName = AndroidManifest.combinePackageAndClassName((String)packageName, (String)testActivityEntry);
                testActivityPath = ProjectCreator.stripString(testFqActivityName.replace(".", File.separator), File.separatorChar);
                testActivityPath = testActivityPath.substring(0, testActivityPath.lastIndexOf(File.separatorChar));
                testActivityClassName = testFqActivityName.substring(testFqActivityName.lastIndexOf(46) + 1);
                if (target.getVersion().getApiLevel() < 4) {
                    keywords.put(PH_ACTIVITY_NAME, activityEntry);
                    testKeywords.put(PH_ACTIVITY_NAME, activityEntry);
                } else {
                    keywords.put(PH_ACTIVITY_ENTRY_NAME, activityEntry);
                    keywords.put(PH_ACTIVITY_CLASS_NAME, activityClassName);
                    keywords.put(PH_ACTIVITY_FQ_NAME, fqActivityName);
                    testKeywords.put(PH_ACTIVITY_ENTRY_NAME, testActivityEntry);
                    testKeywords.put(PH_ACTIVITY_CLASS_NAME, testActivityClassName);
                    testKeywords.put(PH_ACTIVITY_FQ_NAME, testFqActivityName);
                    testKeywords.put(PH_ACTIVITY_TESTED_CLASS_NAME, activityClassName);
                }
            }
            if (projectName != null) {
                keywords.put(PH_PROJECT_NAME, projectName);
                testKeywords.put(PH_PROJECT_NAME, projectName);
            } else {
                keywords.put(PH_PROJECT_NAME, activityClassName != null ? activityClassName : projectFolder.getName());
                testKeywords.put(PH_PROJECT_NAME, testActivityClassName != null ? testActivityClassName : projectFolder.getName());
            }
            String srcMainPath = "src" + File.separator + "main";
            String srcTestPath = "src" + File.separator + "instrumentTest";
            String srcMainCodePath = srcMainPath + File.separator + "java";
            this.createDirs(projectFolder, srcMainCodePath);
            if (activityClassName != null) {
                String srcActivityFolderPath = srcMainCodePath + File.separator + activityPath;
                File sourceFolder = this.createDirs(projectFolder, srcActivityFolderPath);
                String activityFileName = activityClassName + ".java";
                this.installTargetTemplate("java_file.template", new File(sourceFolder, activityFileName), keywords, target);
            }
            String srcTestCodePath = srcTestPath + File.separator + "java";
            this.createDirs(projectFolder, srcTestCodePath);
            if (testActivityClassName != null) {
                String srcActivityFolderPath = srcTestCodePath + File.separator + testActivityPath;
                File sourceFolder = this.createDirs(projectFolder, srcActivityFolderPath);
                String activityFileName = testActivityClassName + ".java";
                this.installTargetTemplate("java_tests_file.template", new File(sourceFolder, activityFileName), testKeywords, target);
            }
            String srcMainResPath = srcMainPath + File.separator + "res";
            File resourceFolder = this.createDirs(projectFolder, srcMainResPath);
            File valueFolder = this.createDirs(resourceFolder, "values");
            this.installTargetTemplate("strings.template", new File(valueFolder, "strings.xml"), keywords, target);
            File layoutFolder = this.createDirs(resourceFolder, "layout");
            this.installTargetTemplate("layout.template", new File(layoutFolder, "main.xml"), keywords, target);
            if (this.installIcons(resourceFolder, target)) {
                keywords.put(PH_ICON, "android:icon=\"@drawable/ic_launcher\"");
            } else {
                keywords.put(PH_ICON, "");
            }
            this.installTargetTemplate("AndroidManifest.template", new File(projectFolder, srcMainPath + File.separator + "AndroidManifest.xml"), keywords, target);
            String buildToolRev = this.mSdkManager.getLatestBuildTool().getRevision().toString();
            keywords.put(PH_BUILD_TOOL_REV, buildToolRev);
            keywords.put(PH_ARTIFACT_VERSION, artifactVersion);
            keywords.put(PH_TARGET, target.hashString());
            keywords.put(PH_PLUGIN, library ? PLUGIN_LIB_PROJECT : PLUGIN_PROJECT);
            this.installTemplate("build_gradle.template", new File(projectFolder, "build.gradle"), keywords);
            this.createDirs(projectFolder, "gradle/wrapper");
            this.installGradleWrapperFile("gradle/wrapper/gradle-wrapper.jar", projectFolder);
            this.installGradleWrapperFile("gradle/wrapper/gradle-wrapper.properties", projectFolder);
            this.installGradleWrapperFile("gradlew.bat", projectFolder);
            this.installGradleWrapperFile("gradlew", projectFolder);
            new File(projectFolder, "gradlew").setExecutable(true, false);
        }
        catch (Exception e) {
            this.mLog.error((Throwable)e, null, new Object[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File checkNewProjectLocation(String folderPath) {
        File projectFolder = new File(folderPath);
        if (!projectFolder.exists()) {
            boolean created = false;
            Exception t = null;
            try {
                created = projectFolder.mkdirs();
            }
            catch (Exception e) {
                t = e;
            }
            if (created) {
                this.println("Created project directory: %1$s", projectFolder);
                return projectFolder;
            }
            this.mLog.error((Throwable)t, "Could not create directory: %1$s", new Object[]{projectFolder});
            return null;
        }
        Exception e = null;
        String error = null;
        try {
            String[] content = projectFolder.list();
            if (content == null) {
                error = "Project folder '%1$s' is not a directory.";
            } else if (content.length != 0) {
                error = "Project folder '%1$s' is not empty. Please consider using '%2$s update' instead.";
            }
        }
        catch (Exception e1) {
            e = e1;
        }
        if (e == null && error == null) return projectFolder;
        this.mLog.error((Throwable)e, error, new Object[]{projectFolder, SdkConstants.androidCmdName()});
        return projectFolder;
    }

    public boolean updateProject(String folderPath, IAndroidTarget target, String projectName, String libraryPath) {
        boolean needsBuildXml;
        FileWrapper androidManifest = this.checkProjectFolder(folderPath, "AndroidManifest.xml");
        if (androidManifest == null) {
            return false;
        }
        FolderWrapper projectFolder = (FolderWrapper)androidManifest.getParentFolder();
        boolean hasProguard = false;
        IAndroidTarget originalTarget = null;
        boolean writeProjectProp = false;
        ProjectProperties props = ProjectProperties.load((IAbstractFolder)projectFolder, ProjectProperties.PropertyType.PROJECT);
        if (props == null) {
            props = ProjectProperties.load((IAbstractFolder)projectFolder, ProjectProperties.PropertyType.LEGACY_DEFAULT);
            writeProjectProp = true;
        }
        if (props != null) {
            String targetHash = props.getProperty("target");
            originalTarget = this.mSdkManager.getTargetFromHashString(targetHash);
            boolean bl = hasProguard = props.getProperty("proguard.config") != null;
        }
        if (originalTarget == null && target == null) {
            this.mLog.error(null, "The project either has no target set or the target is invalid.\nPlease provide a --target to the '%1$s update' command.", new Object[]{SdkConstants.androidCmdName()});
            return false;
        }
        boolean saveProjectProps = false;
        ProjectPropertiesWorkingCopy propsWC = null;
        if (target != null || writeProjectProp) {
            propsWC = props == null ? ProjectProperties.create((IAbstractFolder)projectFolder, ProjectProperties.PropertyType.PROJECT) : props.makeWorkingCopy(ProjectProperties.PropertyType.PROJECT);
            if (target != null) {
                propsWC.setProperty("target", target.hashString());
            }
            saveProjectProps = true;
        }
        if (libraryPath != null) {
            String propName;
            String resolvedPath;
            File libProject;
            if (propsWC == null) {
                assert (props != null);
                propsWC = props.makeWorkingCopy();
            }
            if (!(libProject = new File(libraryPath)).isAbsolute()) {
                libProject = new File((File)projectFolder, libraryPath);
                try {
                    resolvedPath = libProject.getCanonicalPath();
                }
                catch (IOException e) {
                    this.mLog.error((Throwable)e, "Unable to resolve path to library project: %1$s", new Object[]{libraryPath});
                    return false;
                }
            } else {
                resolvedPath = libProject.getAbsolutePath();
            }
            this.println("Resolved location of library project to: %1$s", resolvedPath);
            if (this.checkProjectFolder(resolvedPath, "AndroidManifest.xml") == null) {
                this.mLog.error(null, "No Android Manifest at: %1$s", new Object[]{resolvedPath});
                return false;
            }
            int index = 1;
            while (true) {
                String ref;
                propName = "android.library.reference." + Integer.toString(index);
                assert (props != null);
                if (props == null || (ref = props.getProperty(propName)) == null) break;
                ++index;
            }
            propName = "android.library.reference." + Integer.toString(index);
            propsWC.setProperty(propName, libraryPath);
            saveProjectProps = true;
        }
        if (saveProjectProps) {
            try {
                assert (propsWC != null);
                propsWC.save();
                if (writeProjectProp) {
                    this.println("Updated and renamed %1$s to %2$s", ProjectProperties.PropertyType.LEGACY_DEFAULT.getFilename(), ProjectProperties.PropertyType.PROJECT.getFilename());
                } else {
                    this.println("Updated %1$s", ProjectProperties.PropertyType.PROJECT.getFilename());
                }
            }
            catch (Exception e) {
                this.mLog.error((Throwable)e, "Failed to write %1$s file in '%2$s'", new Object[]{ProjectProperties.PropertyType.PROJECT.getFilename(), folderPath});
                return false;
            }
            if (writeProjectProp) {
                ProjectProperties.delete((IAbstractFolder)projectFolder, ProjectProperties.PropertyType.LEGACY_DEFAULT);
            }
        }
        propsWC = (props = ProjectProperties.load((IAbstractFolder)projectFolder, ProjectProperties.PropertyType.LOCAL)) == null ? ProjectProperties.create((IAbstractFolder)projectFolder, ProjectProperties.PropertyType.LOCAL) : props.makeWorkingCopy();
        propsWC.setProperty("sdk.dir", this.mSdkFolder);
        try {
            propsWC.save();
            this.println("Updated %1$s", ProjectProperties.PropertyType.LOCAL.getFilename());
        }
        catch (Exception e) {
            this.mLog.error((Throwable)e, "Failed to write %1$s file in '%2$s'", new Object[]{ProjectProperties.PropertyType.LOCAL.getFilename(), folderPath});
            return false;
        }
        props = ProjectProperties.load((IAbstractFolder)projectFolder, ProjectProperties.PropertyType.ANT);
        if (props == null && (props = ProjectProperties.load((IAbstractFolder)projectFolder, ProjectProperties.PropertyType.LEGACY_BUILD)) != null) {
            try {
                propsWC = props.makeWorkingCopy(ProjectProperties.PropertyType.ANT);
                propsWC.save();
                ProjectProperties.delete((IAbstractFolder)projectFolder, ProjectProperties.PropertyType.LEGACY_BUILD);
                this.println("Renamed %1$s to %2$s", ProjectProperties.PropertyType.LEGACY_BUILD.getFilename(), ProjectProperties.PropertyType.ANT.getFilename());
            }
            catch (Exception e) {
                this.mLog.error((Throwable)e, "Failed to write %1$s file in '%2$s'", new Object[]{ProjectProperties.PropertyType.ANT.getFilename(), folderPath});
                return false;
            }
        }
        File buildXml = new File((File)projectFolder, "build.xml");
        boolean bl = needsBuildXml = projectName != null || !buildXml.exists();
        if (!needsBuildXml) {
            if (this.checkFileContainsRegexp(buildXml, "version-tag:\\s*custom") != null) {
                this.println("%1$s: Found version-tag: custom. File will not be updated.", "build.xml");
            } else {
                Matcher m = this.checkFileContainsRegexp(buildXml, "version-tag:\\s*(\\d+)");
                if (m == null) {
                    this.println("----------\n%1$s: Failed to find version-tag string. File must be updated.\nIn order to not erase potential customizations, the file will not be automatically regenerated.\nIf no changes have been made to the file, delete it manually and run the command again.\nIf you have made customizations to the build process, the file must be manually updated.\nIt is recommended to:\n\t* Copy current file to a safe location.\n\t* Delete original file.\n\t* Run command again to generate a new file.\n\t* Port customizations to the new file, by looking at the new rules file\n\t  located at <SDK>/tools/ant/build.xml\n\t* Update file to contain\n\t      version-tag: custom\n\t  to prevent file from being rewritten automatically by the SDK tools.\n----------\n", "build.xml");
                } else {
                    int version;
                    String versionStr = m.group(1);
                    if (versionStr != null && (version = Integer.parseInt(versionStr)) < 1) {
                        this.println("%1$s: Found version-tag: %2$d. Expected version-tag: %3$d: file must be updated.", "build.xml", version, 1);
                        needsBuildXml = true;
                    }
                }
            }
        }
        if (needsBuildXml) {
            HashMap<String, String> keywords = new HashMap<String, String>();
            keywords.put(PH_VERSION_TAG, Integer.toString(1));
            if (projectName == null) {
                if (buildXml.exists()) {
                    try {
                        XPathFactory factory = XPathFactory.newInstance();
                        XPath xpath = factory.newXPath();
                        projectName = xpath.evaluate(XPATH_PROJECT_NAME, new InputSource(new FileInputStream(buildXml)));
                    }
                    catch (XPathExpressionException e) {
                        this.mLog.error((Throwable)e, "Unable to find existing project name from %1$s", new Object[]{"build.xml"});
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                }
                if (projectName == null) {
                    this.extractPackageFromManifest((File)androidManifest, keywords);
                    if (keywords.containsKey(PH_ACTIVITY_ENTRY_NAME)) {
                        String activity = keywords.get(PH_ACTIVITY_ENTRY_NAME);
                        int pos = activity.lastIndexOf(46);
                        if (pos != -1) {
                            activity = activity.substring(pos + 1);
                        }
                        projectName = activity;
                        this.println("No project name specified, using Activity name '%1$s'.\nIf you wish to change it, edit the first line of %2$s.", activity, "build.xml");
                    } else {
                        Object projectCanonicalFolder = projectFolder;
                        try {
                            projectCanonicalFolder = ((File)projectCanonicalFolder).getCanonicalFile();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        projectName = ((File)projectCanonicalFolder).getName();
                        this.println("No project name specified, using project folder name '%1$s'.\nIf you wish to change it, edit the first line of %2$s.", projectName, "build.xml");
                    }
                }
            }
            keywords.put(PH_PROJECT_NAME, projectName);
            if (this.mLevel == OutputLevel.VERBOSE) {
                this.println("Regenerating %1$s with project name %2$s", "build.xml", keywords.get(PH_PROJECT_NAME));
            }
            try {
                this.installTemplate("build.template", buildXml, keywords);
            }
            catch (ProjectCreateException e) {
                this.mLog.error((Throwable)e, null, new Object[0]);
                return false;
            }
        }
        if (!hasProguard) {
            try {
                this.installTemplate("proguard-project.txt", new File((File)projectFolder, "proguard-project.txt"), null);
            }
            catch (ProjectCreateException e) {
                this.mLog.error((Throwable)e, null, new Object[0]);
                return false;
            }
        }
        return true;
    }

    public void updateTestProject(String folderPath, String pathToMainProject, SdkManager sdkManager) {
        File mainBuildXml;
        String resolvedPath;
        if (this.checkProjectFolder(folderPath, "AndroidManifest.xml") == null) {
            return;
        }
        File mainProject = new File(pathToMainProject);
        if (!mainProject.isAbsolute()) {
            mainProject = new File(folderPath, pathToMainProject);
            try {
                resolvedPath = mainProject.getCanonicalPath();
            }
            catch (IOException e) {
                this.mLog.error((Throwable)e, "Unable to resolve path to main project: %1$s", new Object[]{pathToMainProject});
                return;
            }
        } else {
            resolvedPath = mainProject.getAbsolutePath();
        }
        this.println("Resolved location of main project to: %1$s", resolvedPath);
        if (this.checkProjectFolder(resolvedPath, "AndroidManifest.xml") == null) {
            this.mLog.error(null, "No Android Manifest at: %1$s", new Object[]{resolvedPath});
            return;
        }
        ProjectProperties projectProp = ProjectProperties.load(resolvedPath, ProjectProperties.PropertyType.PROJECT);
        if (projectProp == null && (projectProp = ProjectProperties.load(resolvedPath, ProjectProperties.PropertyType.LEGACY_DEFAULT)) == null) {
            this.mLog.error(null, "No %1$s at: %2$s", new Object[]{ProjectProperties.PropertyType.PROJECT.getFilename(), resolvedPath});
            return;
        }
        String targetHash = projectProp.getProperty("target");
        if (targetHash == null) {
            this.mLog.error(null, "%1$s in the main project has no target property.", new Object[]{ProjectProperties.PropertyType.PROJECT.getFilename()});
            return;
        }
        IAndroidTarget target = sdkManager.getTargetFromHashString(targetHash);
        if (target == null) {
            this.mLog.error(null, "Main project target %1$s is not a valid target.", new Object[]{targetHash});
            return;
        }
        String projectName = null;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        File testBuildXml = new File(folderPath, "build.xml");
        if (!testBuildXml.isFile() && (mainBuildXml = new File(resolvedPath, "build.xml")).isFile()) {
            try {
                String mainProjectName = xpath.evaluate(XPATH_PROJECT_NAME, new InputSource(new FileInputStream(mainBuildXml)));
                projectName = mainProjectName + "Test";
            }
            catch (XPathExpressionException e) {
                this.mLog.warning("Failed to parse %1$s.\nFile may not be valid. Consider running 'android update project' on the main project.", new Object[]{mainBuildXml.getPath()});
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if (!this.updateProject(folderPath, target, projectName, null)) {
            return;
        }
        ProjectProperties antProps = ProjectProperties.load(folderPath, ProjectProperties.PropertyType.ANT);
        ProjectPropertiesWorkingCopy antWorkingCopy = antProps == null ? ProjectProperties.create(folderPath, ProjectProperties.PropertyType.ANT) : antProps.makeWorkingCopy();
        antWorkingCopy.setProperty("tested.project.dir", pathToMainProject);
        try {
            antWorkingCopy.save();
            this.println("Updated %1$s", ProjectProperties.PropertyType.ANT.getFilename());
        }
        catch (Exception e) {
            this.mLog.error((Throwable)e, "Failed to write %1$s file in '%2$s'", new Object[]{ProjectProperties.PropertyType.ANT.getFilename(), folderPath});
            return;
        }
    }

    private FileWrapper checkProjectFolder(String folderPath, String requiredFilename) {
        FolderWrapper projectFolder = new FolderWrapper(folderPath);
        if (!projectFolder.isDirectory()) {
            this.mLog.error(null, "Project folder '%1$s' is not a valid directory.", new Object[]{projectFolder});
            return null;
        }
        FileWrapper requireFile = new FileWrapper((File)projectFolder, requiredFilename);
        if (!requireFile.isFile()) {
            this.mLog.error(null, "%1$s is not a valid project (%2$s not found).", new Object[]{folderPath, requiredFilename});
            return null;
        }
        return requireFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Matcher checkFileContainsRegexp(File file, String regexp) {
        Pattern p = Pattern.compile(regexp);
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (!m.find()) continue;
                Matcher matcher = m;
                return matcher;
            }
            in.close();
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private boolean extractPackageFromManifest(File manifestFile, Map<String, String> outKeywords) {
        try {
            XPath xpath = AndroidXPathFactory.newXPath();
            InputSource source = new InputSource(new FileReader(manifestFile));
            String packageName = xpath.evaluate("/manifest/@package", source);
            source = new InputSource(new FileReader(manifestFile));
            String expression = String.format("/manifest/application/activity[intent-filter/action/@%1$s:name='android.intent.action.MAIN' and intent-filter/category/@%1$s:name='android.intent.category.LAUNCHER']/@%1$s:name", PLUGIN_PROJECT);
            NodeList activityNames = (NodeList)xpath.evaluate(expression, source, XPathConstants.NODESET);
            if (packageName == null || packageName.length() == 0) {
                this.mLog.error(null, "Missing <manifest package=\"...\"> in '%1$s'", new Object[]{manifestFile.getName()});
                return false;
            }
            String activityName = "";
            if (activityNames.getLength() > 0) {
                activityName = activityNames.item(0).getNodeValue();
            }
            if (this.mLevel == OutputLevel.VERBOSE && activityNames.getLength() > 1) {
                this.println("WARNING: There is more than one activity defined in '%1$s'.\nOnly the first one will be used. If this is not appropriate, you need\nto specify one of these values manually instead:", manifestFile.getName());
                for (int i = 0; i < activityNames.getLength(); ++i) {
                    String name = activityNames.item(i).getNodeValue();
                    name = this.combinePackageActivityNames(packageName, name);
                    this.println("- %1$s", name);
                }
            }
            if (activityName.length() == 0) {
                this.mLog.warning("Missing <activity %1$s:name=\"...\"> in '%2$s'.\nNo activity will be generated.", new Object[]{PLUGIN_PROJECT, manifestFile.getName()});
            } else {
                outKeywords.put(PH_ACTIVITY_ENTRY_NAME, activityName);
            }
            outKeywords.put(PH_PACKAGE, packageName);
            return true;
        }
        catch (IOException e) {
            this.mLog.error((Throwable)e, "Failed to read %1$s", new Object[]{manifestFile.getName()});
        }
        catch (XPathExpressionException e) {
            Throwable t = e.getCause();
            this.mLog.error(t == null ? e : t, "Failed to parse %1$s", new Object[]{manifestFile.getName()});
        }
        return false;
    }

    private String combinePackageActivityNames(String packageName, String activityName) {
        int pos = activityName.indexOf(46);
        if (pos == 0) {
            return packageName + activityName;
        }
        if (pos > 0) {
            return activityName;
        }
        return packageName + "." + activityName;
    }

    private void installTargetTemplate(String templateName, File destFile, Map<String, String> placeholderMap, IAndroidTarget target) throws ProjectCreateException {
        String templateFolder = target.getPath(6);
        String sourcePath = templateFolder + File.separator + templateName;
        this.installFullPathTemplate(sourcePath, destFile, placeholderMap);
    }

    public void installGradleWrapperFile(String templateName, File projectFolder) throws ProjectCreateException {
        String templateFolder = this.mSdkFolder + File.separator + SdkConstants.OS_SDK_TOOLS_TEMPLATES_GRADLE_WRAPPER_FOLDER;
        this.installBinaryFile(new File(templateFolder, templateName), new File(projectFolder, templateName));
    }

    public void installTemplate(String templateName, File destFile, Map<String, String> placeholderMap) throws ProjectCreateException {
        String templateFolder = this.mSdkFolder + File.separator + SdkConstants.OS_SDK_TOOLS_LIB_FOLDER;
        String sourcePath = templateFolder + File.separator + templateName;
        this.installFullPathTemplate(sourcePath, destFile, placeholderMap);
    }

    private void installFullPathTemplate(String sourcePath, File destFile, Map<String, String> placeholderMap) throws ProjectCreateException {
        boolean existed = destFile.exists();
        try {
            String line;
            BufferedWriter out = new BufferedWriter(new FileWriter(destFile));
            BufferedReader in = new BufferedReader(new FileReader(sourcePath));
            while ((line = in.readLine()) != null) {
                if (placeholderMap != null) {
                    for (Map.Entry<String, String> entry : placeholderMap.entrySet()) {
                        line = line.replace(entry.getKey(), entry.getValue());
                    }
                }
                out.write(line);
                out.newLine();
            }
            out.close();
            in.close();
        }
        catch (Exception e) {
            throw new ProjectCreateException(e, "Could not access %1$s: %2$s", destFile, e.getMessage());
        }
        this.println("%1$s file %2$s", existed ? "Updated" : "Added", destFile);
    }

    private boolean installIcons(File resourceFolder, IAndroidTarget target) throws ProjectCreateException {
        String templateFolder = target.getPath(6);
        boolean installedIcon = false;
        installedIcon |= this.installIcon(templateFolder, "ic_launcher_xhdpi.png", resourceFolder, "drawable-xhdpi");
        installedIcon |= this.installIcon(templateFolder, "ic_launcher_hdpi.png", resourceFolder, "drawable-hdpi");
        installedIcon |= this.installIcon(templateFolder, "ic_launcher_mdpi.png", resourceFolder, "drawable-mdpi");
        return installedIcon |= this.installIcon(templateFolder, "ic_launcher_ldpi.png", resourceFolder, "drawable-ldpi");
    }

    private boolean installIcon(String templateFolder, String iconName, File resourceFolder, String folderName) throws ProjectCreateException {
        File icon = new File(templateFolder, iconName);
        if (icon.exists()) {
            File drawable = this.createDirs(resourceFolder, folderName);
            this.installBinaryFile(icon, new File(drawable, "ic_launcher.png"));
            return true;
        }
        return false;
    }

    private void installBinaryFile(File source, File destination) throws ProjectCreateException {
        byte[] buffer = new byte[8192];
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int read;
            fis = new FileInputStream(source);
            fos = new FileOutputStream(destination);
            while ((read = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, read);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new ProjectCreateException(e, "Failed to read binary file: %1$s", source.getAbsolutePath());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void println(String format, Object ... args) {
        if (this.mLevel != OutputLevel.SILENT) {
            if (!format.endsWith("\n")) {
                format = format + "\n";
            }
            this.mLog.info(format, args);
        }
    }

    private File createDirs(File parent, String name) throws ProjectCreateException {
        File newFolder = new File(parent, name);
        boolean existedBefore = true;
        if (!newFolder.exists()) {
            if (!newFolder.mkdirs()) {
                throw new ProjectCreateException("Could not create directory: %1$s", newFolder);
            }
            existedBefore = false;
        }
        if (newFolder.isDirectory()) {
            if (!newFolder.canWrite()) {
                throw new ProjectCreateException("Path is not writable: %1$s", newFolder);
            }
        } else {
            throw new ProjectCreateException("Path is not a directory: %1$s", newFolder);
        }
        if (!existedBefore) {
            try {
                this.println("Created directory %1$s", newFolder.getCanonicalPath());
            }
            catch (IOException e) {
                throw new ProjectCreateException("Could not determine canonical path of created directory", new Object[]{e});
            }
        }
        return newFolder;
    }

    private static String stripString(String s, char strip) {
        int newStart;
        int sLen = s.length();
        int newEnd = sLen - 1;
        for (newStart = 0; newStart < sLen && s.charAt(newStart) == strip; ++newStart) {
        }
        while (newEnd >= 0 && s.charAt(newEnd) == strip) {
            --newEnd;
        }
        if (newStart >= sLen || ++newEnd < 0) {
            return "";
        }
        return s.substring(newStart, newEnd);
    }

    private static class ProjectCreateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ProjectCreateException(String message) {
            super(message);
        }

        ProjectCreateException(Throwable t, String format, Object ... args) {
            super(format != null ? String.format(format, args) : format, t);
        }

        ProjectCreateException(String format, Object ... args) {
            super(String.format(format, args));
        }
    }

    public static enum OutputLevel {
        SILENT,
        NORMAL,
        VERBOSE;

    }
}

