/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.gradle.eclipse;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.gradle.eclipse.EclipseImportModule;
import com.android.tools.gradle.eclipse.GradleImport;
import com.android.tools.gradle.eclipse.ImportModule;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class EclipseProject
implements Comparable<EclipseProject> {
    static final String DEFAULT_LANGUAGE_LEVEL = "1.6";
    private final GradleImport mImporter;
    private final File mDir;
    private final File mCanonicalDir;
    private boolean mLibrary;
    private boolean mAndroidProject;
    private boolean mNdkProject;
    private int mMinSdkVersion;
    private int mTargetSdkVersion;
    private Document mProjectDoc;
    private Document mManifestDoc;
    private Properties mProjectProperties;
    private AndroidVersion mVersion;
    private String mName;
    private String mLanguageLevel;
    private List<EclipseProject> mDirectLibraries;
    private List<File> mSourcePaths;
    private List<File> mJarPaths;
    private List<File> mInstrumentationJarPaths;
    private List<File> mNativeLibs;
    private File mNativeSources;
    private String mNativeModuleName;
    private File mOutputDir;
    private String mPackage;
    private List<File> mLocalProguardFiles;
    private List<File> mSdkProguardFiles;
    private List<EclipseProject> mAllLibraries;
    private EclipseImportModule mModule;
    private Map<String, String> mProjectVariableMap;
    private Map<String, String> mLinkedResourceMap;
    private File mInstrumentationDir;
    private static final String HOME_PROPERTY = "user.home";
    private static final String HOME_PROPERTY_REF = "${user.home}";
    private static final String SDK_PROPERTY_REF = "${sdk.dir}";

    private EclipseProject(@NonNull GradleImport importer, @NonNull File dir) throws IOException {
        this.mImporter = importer;
        this.mDir = dir;
        this.mCanonicalDir = dir.getCanonicalFile();
        this.mImporter.registerProject(this);
        this.initProjectName();
        this.initAndroidProject();
        this.initLanguageLevel();
        if (this.isAndroidProject()) {
            Properties properties = this.getProjectProperties();
            this.initProguard(properties);
            this.initVersion(properties);
            this.initLibraries(properties);
            this.initLibrary(properties);
            this.initPackage();
            this.initMinSdkVersion();
            this.initInstrumentation();
        } else {
            this.mDirectLibraries = new ArrayList<EclipseProject>(4);
        }
        this.initClassPathEntries();
        this.initJni();
    }

    @NonNull
    public static EclipseProject getProject(@NonNull GradleImport importer, @NonNull File dir) throws IOException {
        Map<File, EclipseProject> mProjectMap = importer.getProjectMap();
        EclipseProject project = mProjectMap.get(dir);
        if (project == null) {
            project = EclipseProject.createProject(importer, dir);
            assert (mProjectMap.get(dir) != null);
        }
        return project;
    }

    @NonNull
    private static EclipseProject createProject(@NonNull GradleImport importer, @NonNull File dir) throws IOException {
        return new EclipseProject(importer, dir);
    }

    private void initVersion(Properties properties) {
        String target = properties.getProperty("target");
        if (target != null) {
            this.mVersion = AndroidTargetHash.getPlatformVersion(target);
        }
    }

    private void initLibraries(Properties properties) throws IOException {
        String key;
        String library;
        this.mDirectLibraries = new ArrayList<EclipseProject>(4);
        for (int i = 1; i < 1000 && (library = properties.getProperty(key = String.format("android.library.reference.%1$d", i))) != null && !library.isEmpty(); ++i) {
            File libraryDir = new File(this.mDir, library).getCanonicalFile();
            EclipseProject libraryPrj = EclipseProject.getProject(this.mImporter, libraryDir);
            this.mDirectLibraries.add(libraryPrj);
        }
    }

    private void initLibrary(Properties properties) throws IOException {
        boolean mergeManifests;
        assert (this.mDirectLibraries != null);
        String value = properties.getProperty("android.library");
        this.mLibrary = "true".equals(value);
        if (!this.mLibrary && !(mergeManifests = "true".equals(properties.getProperty("manifestmerger.enabled")))) {
            for (EclipseProject library : this.getAllLibraries()) {
                if (!library.isAndroidProject() || !library.isLibrary() || !library.getManifestFile().exists() || library.getManifestDoc().getDocumentElement() == null || !XmlUtils.hasElementChildren((Node)library.getManifestDoc().getDocumentElement())) continue;
                this.mImporter.getSummary().reportManifestsMayDiffer();
                break;
            }
        }
    }

    private void initPackage() throws IOException {
        this.mPackage = this.getManifestDoc().getDocumentElement().getAttribute("package");
    }

    private void initMinSdkVersion() throws IOException {
        NodeList usesSdks = this.getManifestDoc().getDocumentElement().getElementsByTagName("uses-sdk");
        if (usesSdks.getLength() > 0) {
            Element usesSdk = (Element)usesSdks.item(0);
            this.mMinSdkVersion = EclipseProject.getApiVersion(usesSdk, "minSdkVersion", 1);
            this.mTargetSdkVersion = EclipseProject.getApiVersion(usesSdk, "targetSdkVersion", this.mMinSdkVersion);
        } else {
            this.mMinSdkVersion = -1;
            this.mTargetSdkVersion = -1;
        }
    }

    private void initProjectName() throws IOException {
        Document document = this.getProjectDocument();
        if (document == null) {
            return;
        }
        NodeList names = document.getElementsByTagName("name");
        for (int i = 0; i < names.getLength(); ++i) {
            Node element = names.item(i);
            this.mName = EclipseProject.getStringValue((Element)element);
            if (this.mName != null) break;
        }
        if (this.mName == null) {
            this.mName = this.mDir.getName();
        }
    }

    private static int getApiVersion(Element usesSdk, String attribute, int defaultApiLevel) {
        String valueString = null;
        if (usesSdk.hasAttributeNS("http://schemas.android.com/apk/res/android", attribute)) {
            valueString = usesSdk.getAttributeNS("http://schemas.android.com/apk/res/android", attribute);
        }
        if (valueString != null) {
            int apiLevel = -1;
            try {
                apiLevel = Integer.valueOf(valueString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return apiLevel;
        }
        return defaultApiLevel;
    }

    private void initJni() throws IOException {
        File jniDir = new File(this.mDir, "jni");
        if (!jniDir.exists()) {
            return;
        }
        if (this.mNdkProject) {
            this.mNativeSources = jniDir;
            File makefile = new File(jniDir, "Android.mk");
            if (makefile.exists()) {
                Pattern pattern = Pattern.compile("\\s*LOCAL_MODULE\\s*:=\\s*(\\S+)\\s*");
                for (String line : Files.readLines((File)makefile, (Charset)Charsets.UTF_8)) {
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.matches()) continue;
                    this.mNativeModuleName = matcher.group(1);
                    if (this.mNativeLibs == null) break;
                    String libName = "lib" + this.mNativeModuleName + ".so";
                    ListIterator<File> iterator = this.mNativeLibs.listIterator();
                    while (iterator.hasNext()) {
                        File lib = iterator.next();
                        if (!libName.equals(lib.getName())) continue;
                        iterator.remove();
                    }
                    if (!this.mNativeLibs.isEmpty()) break;
                    this.mNativeLibs = null;
                    break;
                }
            }
        }
    }

    private void initInstrumentation() throws IOException {
        File projectDir = this.findInstrumentationTests(this.mDir);
        if (projectDir == null && this.mDir.getParentFile() != null) {
            projectDir = this.findInstrumentationTests(this.mDir.getParentFile());
        }
        if (projectDir != null && !projectDir.equals(this.mDir)) {
            File[] files;
            this.mInstrumentationDir = projectDir;
            File libs = new File(this.mInstrumentationDir, "libs");
            if (libs.exists() && (files = libs.listFiles()) != null) {
                for (File file : files) {
                    if (!file.isFile() || !SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)".jar")) continue;
                    if (this.mInstrumentationJarPaths == null) {
                        this.mInstrumentationJarPaths = Lists.newArrayList();
                    }
                    this.mInstrumentationJarPaths.add(file);
                }
            }
        }
    }

    private File findInstrumentationTests(File parent) {
        File[] files = parent.listFiles();
        if (files != null) {
            for (File file : files) {
                File manifest;
                if (!file.isDirectory() || !(manifest = new File(file, "AndroidManifest.xml")).exists()) continue;
                try {
                    String target = EclipseProject.getInstrumentationTarget(this.mImporter, manifest);
                    if (target != null && target.equals(this.mPackage)) {
                        return file;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Nullable
    private static String getInstrumentationTarget(@NonNull GradleImport importer, @NonNull File manifest) throws IOException {
        Document doc = importer.getXmlDocument(manifest, true);
        NodeList list = doc.getElementsByTagName("instrumentation");
        for (int i = 0; i < list.getLength(); ++i) {
            Element tag = (Element)list.item(i);
            String target = tag.getAttributeNS("http://schemas.android.com/apk/res/android", "targetPackage");
            if (target == null || target.isEmpty()) continue;
            return target;
        }
        return null;
    }

    private void initClassPathEntries() throws IOException {
        File[] libs;
        assert (this.mSourcePaths == null && this.mJarPaths == null);
        this.mSourcePaths = Lists.newArrayList();
        this.mJarPaths = Lists.newArrayList();
        Document document = null;
        File classPathFile = this.getClassPathFile();
        if (!classPathFile.exists()) {
            File src = new File(this.mDir, "src");
            if (src.exists()) {
                this.mSourcePaths.add(src);
            }
        } else {
            document = this.mImporter.getXmlDocument(classPathFile, false);
        }
        if (document != null) {
            NodeList entries = document.getElementsByTagName("classpathentry");
            for (int i = 0; i < entries.getLength(); ++i) {
                String relative;
                File file;
                File resolved;
                Node entry = entries.item(i);
                assert (entry.getNodeType() == 1);
                Element element = (Element)entry;
                String kind = element.getAttribute("kind");
                String path = element.getAttribute("path");
                if (kind.equals("var")) {
                    resolved = this.resolveVariableExpression(path);
                    if (resolved != null) {
                        this.mSourcePaths.add(resolved);
                        continue;
                    }
                    this.mImporter.reportWarning(this, this.getClassPathFile(), "Could not resolve path variable " + path);
                    continue;
                }
                if (kind.equals("src") && !path.isEmpty()) {
                    if (path.equals("gen")) continue;
                    resolved = this.resolveVariableExpression(path);
                    if (resolved != null) {
                        if (path.startsWith("/") && GradleImport.isEclipseProjectDir(resolved)) {
                            EclipseProject lib = EclipseProject.getProject(this.mImporter, resolved);
                            if (this.mDirectLibraries.contains(lib)) continue;
                            this.mDirectLibraries.add(lib);
                            this.mAllLibraries = null;
                            continue;
                        }
                        this.mSourcePaths.add(resolved);
                        continue;
                    }
                    this.mImporter.reportWarning(this, this.getClassPathFile(), "Could not resolve source path " + path + " in project " + this.getName() + ": ignored. The project may not " + "compile if the given source path provided " + "source code.");
                    continue;
                }
                if (kind.equals("lib") && !path.isEmpty()) {
                    if (this.isAndroidProject()) continue;
                    resolved = this.resolveVariableExpression(path);
                    if (resolved != null) {
                        this.mJarPaths.add(resolved);
                        continue;
                    }
                    this.mImporter.reportWarning(this, this.getClassPathFile(), "Absolute path in the path entry: If outside project, may not work correctly: " + path);
                    continue;
                }
                if (!kind.equals("output") || path.isEmpty() || (file = new File(relative = path.replace('/', File.separatorChar))).isAbsolute()) continue;
                this.mOutputDir = file;
            }
        }
        if ((libs = new File(this.mDir, "libs").listFiles()) != null) {
            for (File lib : libs) {
                File relative;
                if (!lib.isFile()) {
                    File[] libraries = lib.listFiles();
                    if (libraries == null) continue;
                    for (File library : libraries) {
                        String name = library.getName();
                        if (!library.isFile() || !name.startsWith("lib") || !name.contains(".so")) continue;
                        if (this.mNativeLibs == null) {
                            this.mNativeLibs = Lists.newArrayList();
                        }
                        File relative2 = new File("libs", lib.getName() + File.separator + library.getName());
                        this.mNativeLibs.add(relative2);
                    }
                    continue;
                }
                assert (lib.isFile());
                if (!SdkUtils.endsWithIgnoreCase((String)lib.getPath(), (String)".jar") || this.mJarPaths.contains(relative = new File("libs", lib.getName())) || this.mJarPaths.contains(lib)) continue;
                boolean isLibraryJar = false;
                for (EclipseProject project : this.getAllLibraries()) {
                    String jarName;
                    String pkg;
                    if (!project.isAndroidProject() || (pkg = project.getPackage()) == null || !(jarName = pkg.replace('.', '-') + ".jar").equals(lib.getName())) continue;
                    isLibraryJar = true;
                    break;
                }
                if (isLibraryJar) continue;
                this.mJarPaths.add(relative);
            }
        }
    }

    private Map<String, String> getProjectVariableMap() {
        if (this.mProjectVariableMap == null) {
            Document document;
            this.mProjectVariableMap = Maps.newHashMap();
            try {
                document = this.getProjectDocument();
                if (document == null) {
                    return this.mProjectVariableMap;
                }
            }
            catch (IOException e) {
                return this.mProjectVariableMap;
            }
            assert (document != null);
            NodeList variables = document.getElementsByTagName("variable");
            int n = variables.getLength();
            for (int i = 0; i < n; ++i) {
                Element variable = (Element)variables.item(i);
                NodeList names = variable.getElementsByTagName("name");
                NodeList values = variable.getElementsByTagName("value");
                if (names.getLength() != 1 || values.getLength() != 1) continue;
                String value = EclipseProject.getStringValue((Element)values.item(0));
                String key = EclipseProject.getStringValue((Element)names.item(0));
                this.mProjectVariableMap.put(key, value);
            }
        }
        return this.mProjectVariableMap;
    }

    private Map<String, String> getLinkedResourceMap() {
        if (this.mLinkedResourceMap == null) {
            Document document;
            this.mLinkedResourceMap = Maps.newHashMap();
            try {
                document = this.getProjectDocument();
                if (document == null) {
                    return this.mProjectVariableMap;
                }
            }
            catch (IOException e) {
                return this.mLinkedResourceMap;
            }
            assert (document != null);
            NodeList links = document.getElementsByTagName("link");
            int n = links.getLength();
            for (int i = 0; i < n; ++i) {
                Element variable = (Element)links.item(i);
                NodeList names = variable.getElementsByTagName("name");
                NodeList values = variable.getElementsByTagName("locationURI");
                if (names.getLength() != 1 || values.getLength() != 1) continue;
                String value = EclipseProject.getStringValue((Element)values.item(0));
                String key = EclipseProject.getStringValue((Element)names.item(0));
                this.mLinkedResourceMap.put(key, value);
            }
        }
        return this.mLinkedResourceMap;
    }

    @Nullable
    File resolveVariableExpression(@NonNull String path) throws IOException {
        File file = this.resolveVariableExpression(path, true, 0);
        if (file != null && this.mImporter.getPathMap().containsKey(path)) {
            this.mImporter.getPathMap().put(path, file);
        }
        return file;
    }

    @Nullable
    private File resolveVariableExpression(@NonNull String path, boolean record, int depth) throws IOException {
        Pattern pattern;
        Matcher matcher;
        if (depth > 50) {
            return null;
        }
        if (path.equals("PROJECT_LOC")) {
            return this.mDir;
        }
        if (path.equals("PARENT_LOC")) {
            return this.mDir.getParentFile();
        }
        if (path.equals("WORKSPACE_LOC")) {
            return this.mImporter.getEclipseWorkspace();
        }
        if (path.startsWith("PARENT-") && (matcher = (pattern = Pattern.compile("PARENT-(\\d+)-(.+)")).matcher(path)).matches()) {
            String var;
            File file;
            int count = Integer.parseInt(matcher.group(1));
            String target = matcher.group(2);
            int index = target.indexOf(47);
            if (index == -1) {
                index = target.indexOf(92);
            }
            if ((file = this.resolveVariableExpression(var = index == -1 ? target : target.substring(0, index), false, depth + 1)) != null) {
                int i;
                File original = file;
                for (i = 0; i < count && file != null; file = file.getParentFile(), ++i) {
                }
                if (file == null) {
                    file = original.getCanonicalFile();
                    for (i = 0; i < count && file != null; file = file.getParentFile(), ++i) {
                    }
                }
            }
            if (file != null && index != -1) {
                file = new File(file, target.substring(index + 1));
            }
            return file;
        }
        String filePath = path.replace('/', File.separatorChar);
        File resolved = new File(filePath);
        if (resolved.exists()) {
            return resolved;
        }
        resolved = new File(this.mDir, filePath);
        if (resolved.exists()) {
            return resolved;
        }
        resolved = this.mImporter.getPathMap().get(path);
        if (resolved != null) {
            return resolved;
        }
        if (record) {
            this.mImporter.getPathMap().put(path, null);
        }
        if (path.startsWith("/")) {
            resolved = this.mImporter.resolveWorkspacePath(this, path, record);
            if (resolved != null) {
                return resolved;
            }
            if (path.indexOf(47, 1) == -1 && path.indexOf(92, 1) == -1) {
                File sibling;
                String name = path.substring(1);
                File parent = this.mDir.getParentFile();
                if (parent != null && (sibling = new File(parent, name)).exists()) {
                    return sibling;
                }
                File child = new File(this.mDir, name);
                if (child.exists()) {
                    return child;
                }
            }
        } else if (path.startsWith("$%7B")) {
            String sub;
            File expression;
            int start = 4;
            int end = path.indexOf("%7D", 4);
            if (end != -1 && (expression = this.resolveVariableExpression(sub = path.substring(start, end), false, depth + 1)) != null) {
                String suffix = path.substring(end + 3);
                if (suffix.isEmpty()) {
                    return expression;
                }
                resolved = new File(expression, suffix.replace('/', File.separatorChar));
                if (resolved.exists()) {
                    return resolved;
                }
            }
        } else {
            int index = path.indexOf(47);
            if (index == -1) {
                index = path.indexOf(92);
            }
            String var = index == -1 ? path : path.substring(0, index);
            Map<String, String> map = this.getLinkedResourceMap();
            String expression = map.get(var);
            if (expression == null || expression.equals(var)) {
                map = this.getProjectVariableMap();
                expression = map.get(var);
            }
            File file = expression != null ? (expression.startsWith("file:") ? SdkUtils.urlToFile((String)expression) : this.resolveVariableExpression(expression, false, depth + 1)) : this.mImporter.resolvePathVariable(this, var, false);
            if (file != null) {
                if (index == -1) {
                    return file;
                }
                resolved = new File(file, path.substring(index + 1));
                if (resolved.exists()) {
                    return resolved;
                }
            }
        }
        return null;
    }

    private void initAndroidProject() throws IOException {
        this.mAndroidProject = this.hasNature("com.android.ide.eclipse.adt.AndroidNature");
        if (!this.mAndroidProject && this.getProjectDocument() == null) {
            this.mAndroidProject = GradleImport.isAdtProjectDir(this.mDir);
        }
        this.mNdkProject = this.mAndroidProject && (this.hasNature("org.eclipse.cdt.core.cnature") || this.hasNature("org.eclipse.cdt.core.ccnature") || new File(this.mDir, "jni" + File.separator + "Android.mk").exists());
    }

    private boolean hasNature(String nature) throws IOException {
        Document document = this.getProjectDocument();
        if (document != null) {
            NodeList natures = document.getElementsByTagName("nature");
            for (int i = 0; i < natures.getLength(); ++i) {
                Node element = natures.item(i);
                String value = EclipseProject.getStringValue((Element)element);
                if (!nature.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void initLanguageLevel() throws IOException {
        if (this.mLanguageLevel == null) {
            String source;
            Properties properties;
            this.mLanguageLevel = DEFAULT_LANGUAGE_LEVEL;
            File file = new File(this.mDir, ".settings" + File.separator + "org.eclipse.jdt.core.prefs");
            if (file.exists() && (properties = GradleImport.getProperties(file)) != null && (source = properties.getProperty("org.eclipse.jdt.core.compiler.source")) != null) {
                this.mLanguageLevel = source;
            }
        }
    }

    private void initProguard(Properties properties) {
        this.mLocalProguardFiles = Lists.newArrayList();
        this.mSdkProguardFiles = Lists.newArrayList();
        String proguardConfig = properties.getProperty("proguard.config");
        if (proguardConfig != null && !proguardConfig.isEmpty()) {
            if (File.separatorChar != '/' && proguardConfig.indexOf(47) != -1) {
                proguardConfig = proguardConfig.replace('/', File.separatorChar);
            }
            Iterable<String> paths = LintUtils.splitPath(proguardConfig);
            for (String path : paths) {
                if (path.startsWith(SDK_PROPERTY_REF)) {
                    this.mSdkProguardFiles.add(new File(path.substring(SDK_PROPERTY_REF.length()).replace('/', File.separatorChar)));
                    continue;
                }
                if (path.startsWith(HOME_PROPERTY_REF)) {
                    this.mImporter.getSummary().reportIgnoredUserHomeProGuardFile(path);
                    continue;
                }
                File proguardConfigFile = new File(path.replace('/', File.separatorChar));
                if (!proguardConfigFile.isAbsolute()) {
                    proguardConfigFile = new File(this.mDir, proguardConfigFile.getPath());
                }
                if (!proguardConfigFile.isFile()) continue;
                this.mLocalProguardFiles.add(proguardConfigFile);
            }
        }
    }

    @NonNull
    public File getDir() {
        return this.mDir;
    }

    @NonNull
    public File getCanonicalDir() {
        return this.mCanonicalDir;
    }

    public boolean isLibrary() {
        return this.mLibrary;
    }

    @NonNull
    public List<File> getLocalProguardFiles() {
        assert (this.isAndroidProject());
        return this.mLocalProguardFiles;
    }

    @NonNull
    public List<File> getSdkProguardFiles() {
        assert (this.isAndroidProject());
        return this.mSdkProguardFiles;
    }

    @NonNull
    public File getResourceDir() {
        assert (this.isAndroidProject());
        return new File(this.mDir, "res");
    }

    @NonNull
    public File getAssetsDir() {
        assert (this.isAndroidProject());
        return new File(this.mDir, "assets");
    }

    @NonNull
    private File getClassPathFile() {
        return new File(this.mDir, ".classpath");
    }

    @NonNull
    public Document getManifestDoc() throws IOException {
        assert (this.isAndroidProject());
        if (this.mManifestDoc == null) {
            File file = this.getManifestFile();
            this.mManifestDoc = this.mImporter.getXmlDocument(file, true);
        }
        return this.mManifestDoc;
    }

    @NonNull
    File getManifestFile() {
        assert (this.isAndroidProject());
        return new File(this.mDir, "AndroidManifest.xml");
    }

    @Nullable
    public Properties getProjectProperties() throws IOException {
        if (this.mProjectProperties == null) {
            assert (this.isAndroidProject());
            File file = this.getProjectPropertiesFile();
            this.mProjectProperties = file.exists() ? GradleImport.getProperties(file) : new Properties();
        }
        return this.mProjectProperties;
    }

    private File getProjectPropertiesFile() {
        return new File(this.mDir, "project.properties");
    }

    @Nullable
    private Document getProjectDocument() throws IOException {
        File file;
        if (this.mProjectDoc == null && (file = new File(this.mDir, ".project")).exists()) {
            this.mProjectDoc = this.mImporter.getXmlDocument(file, false);
        }
        return this.mProjectDoc;
    }

    public boolean isAndroidProject() {
        return this.mAndroidProject;
    }

    public boolean isNdkProject() {
        return this.mNdkProject;
    }

    @Nullable
    public File getInstrumentationDir() {
        return this.mInstrumentationDir;
    }

    @Nullable
    private static String getStringValue(@NonNull Element element) {
        NodeList children = element.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue().trim();
        }
        return null;
    }

    @Nullable
    public String getPackage() {
        assert (this.isAndroidProject());
        return this.mPackage;
    }

    @NonNull
    public List<File> getSourcePaths() {
        return this.mSourcePaths;
    }

    @NonNull
    public List<File> getJarPaths() {
        return this.mJarPaths;
    }

    @NonNull
    public List<File> getTestJarPaths() {
        return this.mInstrumentationJarPaths != null ? this.mInstrumentationJarPaths : Collections.emptyList();
    }

    @NonNull
    public List<File> getNativeLibs() {
        return this.mNativeLibs != null ? this.mNativeLibs : Collections.emptyList();
    }

    @Nullable
    public File getNativeSources() {
        return this.mNativeSources;
    }

    @Nullable
    public String getNativeModuleName() {
        return this.mNativeModuleName;
    }

    @Nullable
    public File getOutputDir() {
        return this.mOutputDir;
    }

    @NonNull
    public String getLanguageLevel() {
        return this.mLanguageLevel;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public int getMinSdkVersion() {
        assert (this.isAndroidProject());
        return this.mMinSdkVersion;
    }

    public int getTargetSdkVersion() {
        assert (this.isAndroidProject());
        return this.mTargetSdkVersion;
    }

    public int getCompileSdkVersion() {
        assert (this.isAndroidProject());
        return this.mVersion != null ? this.mVersion.getApiLevel() : 19;
    }

    @NonNull
    public List<EclipseProject> getDirectLibraries() {
        return this.mDirectLibraries;
    }

    @NonNull
    public List<EclipseProject> getAllLibraries() {
        if (this.mAllLibraries == null) {
            if (this.mDirectLibraries.isEmpty()) {
                return this.mDirectLibraries;
            }
            ArrayList<EclipseProject> all = new ArrayList<EclipseProject>();
            HashSet seen = Sets.newHashSet();
            HashSet path = Sets.newHashSet();
            seen.add(this);
            path.add(this);
            this.addLibraryProjects(all, seen, path);
            this.mAllLibraries = all;
        }
        return this.mAllLibraries;
    }

    private void addLibraryProjects(@NonNull Collection<EclipseProject> collection, @NonNull Set<EclipseProject> seen, @NonNull Set<EclipseProject> path) {
        for (EclipseProject library : this.mDirectLibraries) {
            if (seen.contains(library)) {
                if (!path.contains(library)) continue;
                this.mImporter.reportWarning(library, library.getDir(), "Internal error: cyclic library dependency for " + library);
                continue;
            }
            collection.add(library);
            seen.add(library);
            path.add(library);
            library.addLibraryProjects(collection, seen, path);
            path.remove(library);
        }
    }

    @Override
    public int compareTo(@NonNull EclipseProject other) {
        return this.mDir.compareTo(other.mDir);
    }

    public String toString() {
        return this.mDir.getPath();
    }

    public static List<? extends ImportModule> performImport(@NonNull GradleImport importer, @NonNull Collection<EclipseProject> projects) {
        ArrayList modules = Lists.newArrayList();
        ArrayList replacedByDependencies = Lists.newArrayList();
        for (EclipseProject project : projects) {
            EclipseImportModule module = new EclipseImportModule(importer, project);
            module.initialize();
            if (module.isReplacedWithDependency()) {
                replacedByDependencies.add(module);
                continue;
            }
            modules.add(module);
        }
        for (EclipseImportModule replaced : replacedByDependencies) {
            assert (replaced.getReplaceWithDependencies() != null);
            EclipseProject project = replaced.getProject();
            for (EclipseImportModule module : modules) {
                if (!module.getProject().getAllLibraries().contains(project)) continue;
                module.addDependencies(replaced.getReplaceWithDependencies());
            }
        }
        for (EclipseImportModule module : modules) {
            module.removeJarDependencies();
        }
        Collections.sort(modules);
        return modules;
    }

    @Nullable
    public EclipseImportModule getModule() {
        return this.mModule;
    }

    public void setModule(@Nullable EclipseImportModule module) {
        this.mModule = module;
    }
}

