/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.gradle.eclipse;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.gradle.eclipse.EclipseProject;
import com.android.tools.gradle.eclipse.GradleImport;
import com.android.tools.gradle.eclipse.ImportModule;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;

class EclipseImportModule
extends ImportModule {
    private final EclipseProject mProject;
    private List<ImportModule> mDirectDependencies;
    private List<ImportModule> mAllDependencies;

    public EclipseImportModule(@NonNull GradleImport importer, @NonNull EclipseProject project) {
        super(importer);
        this.mProject = project;
        this.mProject.setModule(this);
    }

    @Override
    @Nullable
    protected File getLintXml() {
        File lintXml = new File(this.mProject.getDir(), "lint.xml");
        return lintXml.exists() ? lintXml : null;
    }

    @Override
    @NonNull
    protected File resolveFile(@NonNull File file) {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.mProject.getDir(), file.getPath());
    }

    @Override
    protected void initDependencies() {
        GradleCoordinate dependency;
        super.initDependencies();
        for (File jar : this.mProject.getJarPaths()) {
            if (this.mImporter.isReplaceJars() && (dependency = this.guessDependency(jar)) != null) {
                this.mDependencies.add(dependency);
                this.mImporter.getSummary().reportReplacedJar(jar, dependency);
                continue;
            }
            this.mJarDependencies.add(this.getJarOutputRelativePath(jar));
        }
        for (File jar : this.mProject.getTestJarPaths()) {
            if (this.mImporter.isReplaceJars() && (dependency = this.guessDependency(jar)) != null) {
                this.mTestDependencies.add(dependency);
                this.mImporter.getSummary().reportReplacedJar(jar, dependency);
                continue;
            }
            this.mTestJarDependencies.add(EclipseImportModule.getTestJarOutputRelativePath(jar));
        }
    }

    public void addDependencies(@NonNull List<GradleCoordinate> dependencies) {
        for (GradleCoordinate dependency : dependencies) {
            if (this.mDependencies.contains(dependency)) continue;
            this.mDependencies.addAll(dependencies);
        }
    }

    @Override
    protected boolean dependsOnLibrary(@NonNull String pkg) {
        if (!this.isAndroidProject()) {
            return false;
        }
        if (pkg.equals(this.mProject.getPackage())) {
            return true;
        }
        for (EclipseProject project : this.mProject.getAllLibraries()) {
            if (!pkg.equals(project.getPackage())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    protected List<ImportModule> getDirectDependencies() {
        if (this.mDirectDependencies == null) {
            this.mDirectDependencies = Lists.newArrayList();
            for (EclipseProject project : this.mProject.getDirectLibraries()) {
                EclipseImportModule module = project.getModule();
                if (module == null) continue;
                this.mDirectDependencies.add(module);
            }
        }
        return this.mDirectDependencies;
    }

    @Override
    @NonNull
    protected List<ImportModule> getAllDependencies() {
        if (this.mAllDependencies == null) {
            this.mAllDependencies = Lists.newArrayList();
            for (EclipseProject project : this.mProject.getAllLibraries()) {
                EclipseImportModule module = project.getModule();
                if (module == null) continue;
                this.mAllDependencies.add(module);
            }
        }
        return this.mAllDependencies;
    }

    @Override
    protected boolean isAndroidProject() {
        return this.mProject.isAndroidProject();
    }

    @Override
    protected boolean isLibrary() {
        return this.mProject.isLibrary();
    }

    @Override
    @Nullable
    protected String getPackage() {
        return this.mProject.getPackage();
    }

    @Override
    @NonNull
    protected String getOriginalName() {
        return this.mProject.getName();
    }

    @Override
    public boolean isApp() {
        return this.mProject.isAndroidProject() && !this.mProject.isLibrary();
    }

    @Override
    public boolean isAndroidLibrary() {
        return this.mProject.isAndroidProject() && this.mProject.isLibrary();
    }

    @Override
    public boolean isJavaLibrary() {
        return !this.mProject.isAndroidProject();
    }

    @Override
    public boolean isNdkProject() {
        return this.mProject.isNdkProject();
    }

    @Override
    @Nullable
    protected File getManifestFile() {
        return this.mProject.getManifestFile();
    }

    @Override
    @Nullable
    protected File getResourceDir() {
        return this.mProject.getResourceDir();
    }

    @Override
    @Nullable
    protected File getAssetsDir() {
        return this.mProject.getAssetsDir();
    }

    @Override
    @NonNull
    protected List<File> getSourcePaths() {
        return this.mProject.getSourcePaths();
    }

    @Override
    @NonNull
    protected List<File> getJarPaths() {
        return this.mProject.getJarPaths();
    }

    @Override
    @NonNull
    protected List<File> getTestJarPaths() {
        return this.mProject.getTestJarPaths();
    }

    @Override
    @NonNull
    protected List<File> getNativeLibs() {
        return this.mProject.getNativeLibs();
    }

    @Override
    @Nullable
    protected File getNativeSources() {
        return this.mProject.getNativeSources();
    }

    @Override
    @Nullable
    protected String getNativeModuleName() {
        return this.mProject.getNativeModuleName();
    }

    @Override
    @NonNull
    protected List<File> getLocalProguardFiles() {
        return this.mProject.getLocalProguardFiles();
    }

    @Override
    @NonNull
    protected List<File> getSdkProguardFiles() {
        return this.mProject.getSdkProguardFiles();
    }

    @Override
    @NonNull
    protected File getCanonicalModuleDir() {
        return this.mProject.getCanonicalDir();
    }

    @Override
    @Nullable
    protected File getOutputDir() {
        return this.mProject.getOutputDir();
    }

    @Override
    @NonNull
    protected String getLanguageLevel() {
        return this.mProject.getLanguageLevel();
    }

    @Override
    protected int getCompileSdkVersion() {
        return this.mProject.getCompileSdkVersion();
    }

    @Override
    protected int getTargetSdkVersion() {
        return this.mProject.getTargetSdkVersion();
    }

    @Override
    protected int getMinSdkVersion() {
        return this.mProject.getMinSdkVersion();
    }

    @Override
    protected boolean dependsOn(@NonNull ImportModule other) {
        return this.mProject.getAllLibraries().contains(((EclipseImportModule)other).mProject);
    }

    @NonNull
    public EclipseProject getProject() {
        return this.mProject;
    }

    @Override
    @Nullable
    protected File getInstrumentationDir() {
        return this.mProject.getInstrumentationDir();
    }
}

