/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer;

import com.android.SdkConstants;
import com.android.hierarchyviewer.HierarchyViewerApplication;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HierarchyViewerApplicationDirector
extends HierarchyViewerDirector {
    private final ExecutorService mExecutor = Executors.newSingleThreadExecutor();

    public static HierarchyViewerDirector createDirector() {
        sDirector = new HierarchyViewerApplicationDirector();
        return sDirector;
    }

    public void terminate() {
        super.terminate();
        this.mExecutor.shutdown();
    }

    public String getAdbLocation() {
        String hvParentLocation = System.getProperty("com.android.hierarchyviewer.bindir");
        if (hvParentLocation != null && hvParentLocation.length() != 0) {
            File platformTools = new File(new File(hvParentLocation).getParent(), "platform-tools");
            if (platformTools.isDirectory()) {
                return platformTools.getAbsolutePath() + File.separator + SdkConstants.FN_ADB;
            }
            String androidOut = System.getenv("ANDROID_HOST_OUT");
            if (androidOut != null) {
                return androidOut + File.separator + "bin" + File.separator + SdkConstants.FN_ADB;
            }
        }
        return SdkConstants.FN_ADB;
    }

    public void executeInBackground(final String taskName, final Runnable task) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                HierarchyViewerApplication.getMainWindow().startTask(taskName);
                task.run();
                HierarchyViewerApplication.getMainWindow().endTask();
            }
        });
    }
}

