/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.lib;

import com.vladium.jcd.cls.IAccessFlags;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class Types {
    public static String getClassPackageName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(0, n) : "";
    }

    public static String accessFlagsToString(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        if (bl) {
            for (int i = 0; i < IAccessFlags.ALL_ACC.length; ++i) {
                int n2 = IAccessFlags.ALL_ACC[i];
                if ((n & n2) == 0) continue;
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(" ");
                }
                if (n2 == 32) {
                    stringBuffer.append("super");
                    continue;
                }
                stringBuffer.append(IAccessFlags.ALL_ACC_NAMES[i]);
            }
        } else {
            for (int i = 0; i < IAccessFlags.ALL_ACC.length; ++i) {
                int n3 = IAccessFlags.ALL_ACC[i];
                if ((n & n3) == 0) continue;
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(IAccessFlags.ALL_ACC_NAMES[i]);
            }
        }
        return stringBuffer.toString();
    }

    public static String javaNameToVMName(String string) {
        if (string == null) {
            return null;
        }
        return string.replace('.', '/');
    }

    public static String vmNameToJavaName(String string) {
        if (string == null) {
            return null;
        }
        return string.replace('/', '.');
    }

    public static String signatureToDescriptor(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("null input: method");
        }
        return Types.signatureToDescriptor(method.getParameterTypes(), method.getReturnType());
    }

    public static String signatureToDescriptor(Class[] classArray, Class clazz) {
        return new signatureCompiler().signatureDescriptor(classArray, clazz);
    }

    public static String typeToDescriptor(Class clazz) {
        return new signatureCompiler().typeDescriptor(clazz);
    }

    public static Class descriptorToType(String string) throws ClassNotFoundException {
        return new typeDescriptorCompiler().descriptorToClass(string);
    }

    public static String descriptorToReturnType(String string) {
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(41);
        if (n < 0 || n2 <= 0 || n >= n2 || n2 >= string.length() - 1) {
            throw new IllegalArgumentException("malformed method descriptor: [" + string + "]");
        }
        return string.substring(n2 + 1);
    }

    public static String[] descriptorToParameterTypes(String string) {
        try {
            methodDescriptorCompiler methodDescriptorCompiler2 = new methodDescriptorCompiler(string);
            methodDescriptorCompiler2.methodDescriptor();
            return methodDescriptorCompiler2.getResult();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error parsing [" + string + "]: " + iOException.toString());
        }
    }

    public static String signatureToMethodDescriptor(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(')');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String typeDescriptorToUserName(String string) {
        return new typeDescriptorCompiler2().descriptorToClass(string);
    }

    public static String methodDescriptorToUserName(String string) {
        String[] stringArray = Types.descriptorToParameterTypes(string);
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            int n;
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if ((n = (string2 = Types.typeDescriptorToUserName(stringArray[i])).lastIndexOf(46)) < 0 || !"java.lang.".equals(string2.substring(0, n + 1))) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string2.substring(n + 1));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String fullMethodDescriptorToUserName(String string, String string2, String string3) {
        if ("<init>".equals(string2)) {
            string2 = Types.simpleClassName(string);
        }
        if ("<clinit>".equals(string2)) {
            string2 = "<static class initializer>";
        }
        return string2 + ' ' + Types.methodDescriptorToUserName(string3);
    }

    public static String fullMethodDescriptorToFullUserName(String string, String string2, String string3) {
        if ("<init>".equals(string2)) {
            string2 = Types.simpleClassName(string);
        }
        if ("<clinit>".equals(string2)) {
            string2 = "<static class initializer>";
        }
        return string + '.' + string2 + ' ' + Types.methodDescriptorToUserName(string3);
    }

    private static String simpleClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static class methodDescriptorCompiler {
        final List m_result = new ArrayList();
        private StringBuffer m_token = new StringBuffer();
        private PushbackReader m_in;

        methodDescriptorCompiler(String string) {
            this.m_in = new PushbackReader(new StringReader(string));
        }

        String[] getResult() {
            String[] stringArray = new String[this.m_result.size()];
            this.m_result.toArray(stringArray);
            return stringArray;
        }

        void methodDescriptor() throws IOException {
            char c;
            this.consume('(');
            while ((c = (char)this.m_in.read()) != ')') {
                this.m_in.unread(c);
                this.parameterDescriptor();
            }
            this.returnDescriptor();
        }

        void parameterDescriptor() throws IOException {
            this.fieldType();
            this.newToken();
        }

        void returnDescriptor() throws IOException {
            char c = (char)this.m_in.read();
            switch (c) {
                case 'V': {
                    this.m_token.append(c);
                    break;
                }
                default: {
                    this.m_in.unread(c);
                    this.fieldType();
                }
            }
        }

        void componentType() throws IOException {
            this.fieldType();
        }

        void objectType() throws IOException {
            char c;
            this.consume('L');
            this.m_token.append('L');
            while ((c = (char)this.m_in.read()) != ';') {
                this.m_token.append(c);
            }
            this.m_token.append(';');
        }

        void arrayType() throws IOException {
            this.consume('[');
            this.m_token.append('[');
            this.componentType();
        }

        void fieldType() throws IOException {
            char c = (char)this.m_in.read();
            this.m_in.unread(c);
            switch (c) {
                case 'L': {
                    this.objectType();
                    break;
                }
                case '[': {
                    this.arrayType();
                    break;
                }
                default: {
                    this.baseType();
                }
            }
        }

        void baseType() throws IOException {
            char c = (char)this.m_in.read();
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    this.m_token.append(c);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown base type: " + c);
                }
            }
        }

        private void consume(char c) throws IOException {
            char c2 = (char)this.m_in.read();
            if (c2 != c) {
                throw new IllegalArgumentException("consumed '" + c2 + "' while expecting '" + c + "'");
            }
        }

        private void newToken() {
            this.m_result.add(this.m_token.toString());
            this.m_token.setLength(0);
        }
    }

    private static class typeDescriptorCompiler2 {
        private typeDescriptorCompiler2() {
        }

        String descriptorToClass(String string) {
            char c = string.charAt(0);
            if (c == '[') {
                return this.arrayOf(string.substring(1));
            }
            if (c == 'L') {
                return Types.vmNameToJavaName(string.substring(1, string.length() - 1));
            }
            return this.primitive(c);
        }

        String arrayOf(String string) {
            char c = string.charAt(0);
            String string2 = c == '[' ? this.arrayOf(string.substring(1)) : (c == 'L' ? Types.vmNameToJavaName(string.substring(1, string.length() - 1)) : this.primitive(c));
            String string3 = string2 + " []";
            return string3;
        }

        String primitive(char c) {
            switch (c) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
            }
            throw new IllegalArgumentException("unknown primitive: " + c);
        }
    }

    private static class typeDescriptorCompiler {
        private typeDescriptorCompiler() {
        }

        Class descriptorToClass(String string) throws ClassNotFoundException {
            char c = string.charAt(0);
            if (c == '[') {
                return this.arrayOf(string.substring(1));
            }
            if (c == 'L') {
                return Class.forName(Types.vmNameToJavaName(string.substring(1, string.length() - 1)));
            }
            return this.primitive(c);
        }

        Class arrayOf(String string) throws ClassNotFoundException {
            char c = string.charAt(0);
            Class<Object> clazz = c == '[' ? this.arrayOf(string.substring(1)) : (c == 'L' ? Class.forName(Types.vmNameToJavaName(string.substring(1, string.length() - 1))) : this.primitive(c));
            Object object = Array.newInstance(clazz, 0);
            return object.getClass();
        }

        Class primitive(char c) throws ClassNotFoundException {
            if (c == 'B') {
                return Byte.TYPE;
            }
            if (c == 'C') {
                return Character.TYPE;
            }
            if (c == 'D') {
                return Double.TYPE;
            }
            if (c == 'F') {
                return Float.TYPE;
            }
            if (c == 'I') {
                return Integer.TYPE;
            }
            if (c == 'J') {
                return Long.TYPE;
            }
            if (c == 'S') {
                return Short.TYPE;
            }
            if (c == 'Z') {
                return Boolean.TYPE;
            }
            throw new ClassNotFoundException("unknown base type: " + c);
        }
    }

    private static final class signatureCompiler {
        private StringBuffer m_desc = new StringBuffer();

        private signatureCompiler() {
        }

        String signatureDescriptor(Class[] classArray, Class clazz) {
            this.emit('(');
            this.parameterTypes(classArray);
            this.emit(')');
            this.returnType(clazz);
            return this.m_desc.toString();
        }

        String typeDescriptor(Class clazz) {
            this.parameterType(clazz);
            return this.m_desc.toString();
        }

        private void parameterTypes(Class[] classArray) {
            if (classArray != null) {
                for (int i = 0; i < classArray.length; ++i) {
                    this.parameterType(classArray[i]);
                }
            }
        }

        private void returnType(Class clazz) {
            if (clazz == null || clazz == Void.TYPE) {
                this.emit('V');
            } else {
                this.parameterType(clazz);
            }
        }

        private void parameterType(Class clazz) {
            if (clazz != null) {
                if (clazz.isPrimitive()) {
                    if (Byte.TYPE == clazz) {
                        this.emit('B');
                    } else if (Character.TYPE == clazz) {
                        this.emit('C');
                    } else if (Double.TYPE == clazz) {
                        this.emit('D');
                    } else if (Float.TYPE == clazz) {
                        this.emit('F');
                    } else if (Integer.TYPE == clazz) {
                        this.emit('I');
                    } else if (Long.TYPE == clazz) {
                        this.emit('J');
                    } else if (Short.TYPE == clazz) {
                        this.emit('S');
                    } else if (Boolean.TYPE == clazz) {
                        this.emit('Z');
                    }
                } else if (clazz.isArray()) {
                    this.emit('[');
                    this.parameterType(clazz.getComponentType());
                } else {
                    this.emit('L');
                    this.emit(Types.javaNameToVMName(clazz.getName()));
                    this.emit(';');
                }
            }
        }

        private void emit(String string) {
            this.m_desc.append(string);
        }

        private void emit(char c) {
            this.m_desc.append(c);
        }
    }
}

