/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SourcePathCache {
    private final File[] m_sourcepath;
    private final Map m_packageCache;
    private static final FileExtensionFilter FILE_EXTENSION_FILTER = new FileExtensionFilter(".java");

    public SourcePathCache(String[] stringArray, boolean bl) {
        if (stringArray == null) {
            throw new IllegalArgumentException("null input: sourcepath");
        }
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            if (bl && (!file.isDirectory() || !file.exists())) continue;
            arrayList.add(file);
        }
        this.m_sourcepath = new File[arrayList.size()];
        arrayList.toArray(this.m_sourcepath);
        this.m_packageCache = new HashMap();
    }

    public SourcePathCache(File[] fileArray, boolean bl) {
        if (fileArray == null) {
            throw new IllegalArgumentException("null input: sourcepath");
        }
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (bl && (!file.isDirectory() || !file.exists())) continue;
            arrayList.add(file);
        }
        this.m_sourcepath = new File[arrayList.size()];
        arrayList.toArray(this.m_sourcepath);
        this.m_packageCache = new HashMap();
    }

    public synchronized File find(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("null input: packageVMName");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null input: name");
        }
        if (this.m_sourcepath.length == 0) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)this.m_packageCache.get(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(this.m_sourcepath.length);
            this.m_packageCache.put(string, cacheEntry);
        }
        Set[] setArray = cacheEntry.m_listings;
        for (int i = 0; i < setArray.length; ++i) {
            Set set = setArray[i];
            if (set == null) {
                setArray[i] = set = this.faultListing(this.m_sourcepath[i], string);
            }
            if (!set.contains(string2)) continue;
            File file = new File(string.replace('/', File.separatorChar), string2);
            return new File(this.m_sourcepath[i], file.getPath()).getAbsoluteFile();
        }
        return null;
    }

    private Set faultListing(File file, String string) {
        File file2 = new File(file, string.replace('/', File.separatorChar));
        File[] fileArray = file2.listFiles(FILE_EXTENSION_FILTER);
        if (fileArray == null || fileArray.length == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            hashSet.add(fileArray[i].getName());
        }
        return hashSet;
    }

    private static final class FileExtensionFilter
    implements FileFilter {
        private final String m_extension;

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n <= 0) {
                return false;
            }
            return this.m_extension.equals(string.substring(n));
        }

        public String toString() {
            return super.toString() + ", extension = [" + this.m_extension + "]";
        }

        FileExtensionFilter(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: extension");
            }
            String string2 = FileExtensionFilter.canonicalizeExtension(string);
            if (string.length() <= 1) {
                throw new IllegalArgumentException("empty input: extension");
            }
            this.m_extension = string2;
        }

        private static String canonicalizeExtension(String string) {
            if (string.charAt(0) != '.') {
                return ".".concat(string);
            }
            return string;
        }
    }

    private static final class CacheEntry {
        final Set[] m_listings;

        CacheEntry(int n) {
            this.m_listings = new Set[n];
        }
    }
}

