/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemAttribute;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.ItemComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

abstract class Item
implements IItem {
    protected final IItem m_parent;
    protected final int[] m_aggregates;
    private final List m_children;

    public final int getChildCount() {
        return this.m_children.size();
    }

    public final IItem getParent() {
        return this.m_parent;
    }

    public final Iterator getChildren() {
        return this.m_children.iterator();
    }

    public final Iterator getChildren(ItemComparator itemComparator) {
        if (itemComparator == null) {
            return this.getChildren();
        }
        IItem[] iItemArray = new IItem[this.m_children.size()];
        this.m_children.toArray(iItemArray);
        Arrays.sort(iItemArray, itemComparator);
        return Arrays.asList(iItemArray).iterator();
    }

    public final IItemAttribute getAttribute(int n, int n2) {
        if ((this.getMetadata().getAttributeIDs() & (long)(1 << n)) == 0L) {
            return null;
        }
        return IItemAttribute.Factory.getAttribute(n, n2);
    }

    public int getAggregate(int n) {
        int[] nArray = this.m_aggregates;
        int n2 = nArray[n];
        if (n2 < 0) {
            n2 = 0;
            Iterator iterator = this.m_children.iterator();
            while (iterator.hasNext()) {
                n2 += ((IItem)iterator.next()).getAggregate(n);
            }
            nArray[n] = n2;
            return n2;
        }
        return n2;
    }

    protected void addChild(IItem iItem) {
        if (iItem == null) {
            throw new IllegalArgumentException("null input: item");
        }
        this.m_children.add(iItem);
    }

    Item(IItem iItem) {
        this.m_parent = iItem;
        this.m_children = new ArrayList();
        this.m_aggregates = new int[13];
        for (int i = 0; i < this.m_aggregates.length; ++i) {
            this.m_aggregates[i] = -1;
        }
    }

    protected static final class ItemMetadata
    implements IItemMetadata {
        private final int m_typeID;
        private final String m_typeName;
        private final long m_attributeIDs;

        public int getTypeID() {
            return this.m_typeID;
        }

        public String getTypeName() {
            return this.m_typeName;
        }

        public long getAttributeIDs() {
            return this.m_attributeIDs;
        }

        ItemMetadata(int n, String string, long l) {
            this.m_typeID = n;
            this.m_typeName = string;
            this.m_attributeIDs = l;
        }
    }
}

