/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SrcFileItem;

public interface IItemMetadata {
    public static final int TYPE_ID_ALL = 0;
    public static final int TYPE_ID_PACKAGE = 1;
    public static final int TYPE_ID_SRCFILE = 2;
    public static final int TYPE_ID_CLASS = 3;
    public static final int TYPE_ID_METHOD = 4;

    public int getTypeID();

    public String getTypeName();

    public long getAttributeIDs();

    public static abstract class Factory {
        private static final IItemMetadata[] METADATA = new IItemMetadata[]{AllItem.getTypeMetadata(), PackageItem.getTypeMetadata(), SrcFileItem.getTypeMetadata(), ClassItem.getTypeMetadata(), MethodItem.getTypeMetadata()};

        public static IItemMetadata getTypeMetadata(int n) {
            if (n < 0 || n > 4) {
                throw new IllegalArgumentException("invalid type ID: " + n);
            }
            return METADATA[n];
        }

        public static IItemMetadata[] getAllTypes() {
            return METADATA;
        }

        private Factory() {
        }
    }
}

