/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.data.MethodDescriptor;
import com.vladium.util.IConstants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class ClassDescriptor
implements IConstants,
Serializable {
    private final String m_packageVMName;
    private final String m_name;
    private final long m_stamp;
    private final String m_srcFileName;
    private final MethodDescriptor[] m_methods;
    private final boolean m_hasCompleteLineNumberInfo;
    private transient int m_hash;

    public ClassDescriptor(String string, String string2, long l, String string3, MethodDescriptor[] methodDescriptorArray) {
        if (string == null) {
            throw new IllegalArgumentException("null input: packageVMName");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null input: name");
        }
        if (methodDescriptorArray == null) {
            throw new IllegalArgumentException("null input: methods");
        }
        this.m_packageVMName = string;
        this.m_name = string2;
        this.m_stamp = l;
        this.m_srcFileName = string3;
        this.m_methods = methodDescriptorArray;
        boolean bl = true;
        for (int i = 0; i < this.m_methods.length; ++i) {
            MethodDescriptor methodDescriptor = methodDescriptorArray[i];
            if ((methodDescriptor.getStatus() & 0xE) != 0 || this.m_methods[i].hasLineNumberInfo()) continue;
            bl = false;
            break;
        }
        this.m_hasCompleteLineNumberInfo = bl;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)object;
        if (this.hashCode() != classDescriptor.hashCode()) {
            return false;
        }
        if (!this.m_name.equals(classDescriptor.m_name)) {
            return false;
        }
        return this.m_packageVMName.equals(classDescriptor.m_packageVMName);
    }

    public final int hashCode() {
        if (this.m_hash == 0) {
            int n;
            this.m_hash = n = this.m_name.hashCode() + 16661 * this.m_packageVMName.hashCode();
            return n;
        }
        return this.m_hash;
    }

    public final String getPackageVMName() {
        return this.m_packageVMName;
    }

    public final String getName() {
        return this.m_name;
    }

    public final long getStamp() {
        return this.m_stamp;
    }

    public final String getClassVMName() {
        if (this.m_packageVMName.length() == 0) {
            return this.m_name;
        }
        return new StringBuffer(this.m_packageVMName).append("/").append(this.m_name).toString();
    }

    public final String getSrcFileName() {
        return this.m_srcFileName;
    }

    public final MethodDescriptor[] getMethods() {
        return this.m_methods;
    }

    public final boolean hasSrcFileInfo() {
        return this.m_srcFileName != null;
    }

    public final boolean hasCompleteLineNumberInfo() {
        return this.m_hasCompleteLineNumberInfo;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string + "class [" + (this.m_packageVMName.length() > 0 ? this.m_packageVMName + "/" : "") + this.m_name + "] descriptor:");
        for (int i = 0; i < this.m_methods.length; ++i) {
            stringBuffer.append(EOL);
            stringBuffer.append(this.m_methods[i].toString(string + "  "));
        }
        return stringBuffer.toString();
    }

    static ClassDescriptor readExternal(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        String string2 = dataInput.readUTF();
        long l = dataInput.readLong();
        byte by = dataInput.readByte();
        String string3 = by != 0 ? dataInput.readUTF() : null;
        int n = dataInput.readInt();
        MethodDescriptor[] methodDescriptorArray = new MethodDescriptor[n];
        for (int i = 0; i < n; ++i) {
            methodDescriptorArray[i] = MethodDescriptor.readExternal(dataInput);
        }
        return new ClassDescriptor(string, string2, l, string3, methodDescriptorArray);
    }

    static void writeExternal(ClassDescriptor classDescriptor, DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(classDescriptor.m_packageVMName);
        dataOutput.writeUTF(classDescriptor.m_name);
        dataOutput.writeLong(classDescriptor.m_stamp);
        if (classDescriptor.m_srcFileName != null) {
            dataOutput.writeByte(1);
            dataOutput.writeUTF(classDescriptor.m_srcFileName);
        } else {
            dataOutput.writeByte(0);
        }
        MethodDescriptor[] methodDescriptorArray = classDescriptor.m_methods;
        int n = methodDescriptorArray.length;
        dataOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            MethodDescriptor.writeExternal(methodDescriptorArray[i], dataOutput);
        }
    }
}

