/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.ArrayDimension;
import lombok.ast.ArrayInitializer;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReference;

public class ArrayCreation
extends AbstractNode
implements Expression {
    private List<Position> parensPositions = new ArrayList<Position>();
    private AbstractNode componentTypeReference = null;
    ListAccessor<ArrayDimension, ArrayCreation> dimensions = ListAccessor.of(this, ArrayDimension.class, "ArrayCreation.dimensions");
    private AbstractNode initializer = null;

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public TypeReference astComponentTypeReference() {
        if (!(this.componentTypeReference instanceof TypeReference)) {
            return null;
        }
        return (TypeReference)this.componentTypeReference;
    }

    public ArrayCreation astComponentTypeReference(TypeReference componentTypeReference) {
        if (componentTypeReference == null) {
            throw new NullPointerException("componentTypeReference is mandatory");
        }
        return this.rawComponentTypeReference(componentTypeReference);
    }

    public Node rawComponentTypeReference() {
        return this.componentTypeReference;
    }

    public ArrayCreation rawComponentTypeReference(Node componentTypeReference) {
        if (componentTypeReference == this.componentTypeReference) {
            return this;
        }
        if (componentTypeReference != null) {
            this.adopt((AbstractNode)componentTypeReference);
        }
        if (this.componentTypeReference != null) {
            this.disown(this.componentTypeReference);
        }
        this.componentTypeReference = (AbstractNode)componentTypeReference;
        return this;
    }

    public RawListAccessor<ArrayDimension, ArrayCreation> rawDimensions() {
        return this.dimensions.asRaw();
    }

    public StrictListAccessor<ArrayDimension, ArrayCreation> astDimensions() {
        return this.dimensions.asStrict();
    }

    public ArrayInitializer astInitializer() {
        if (!(this.initializer instanceof ArrayInitializer)) {
            return null;
        }
        return (ArrayInitializer)this.initializer;
    }

    public ArrayCreation astInitializer(ArrayInitializer initializer) {
        return this.rawInitializer(initializer);
    }

    public Node rawInitializer() {
        return this.initializer;
    }

    public ArrayCreation rawInitializer(Node initializer) {
        if (initializer == this.initializer) {
            return this;
        }
        if (initializer != null) {
            this.adopt((AbstractNode)initializer);
        }
        if (this.initializer != null) {
            this.disown(this.initializer);
        }
        this.initializer = (AbstractNode)initializer;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.componentTypeReference != null) {
            result.add(this.componentTypeReference);
        }
        result.addAll(this.dimensions.backingList());
        if (this.initializer != null) {
            result.add(this.initializer);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.componentTypeReference == original) {
            this.rawComponentTypeReference(replacement);
            return true;
        }
        if (this.rawDimensions().replace(original, replacement)) {
            return true;
        }
        if (this.initializer == original) {
            this.rawInitializer(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.componentTypeReference == child) {
            this.disown((AbstractNode)child);
            this.componentTypeReference = null;
            return true;
        }
        if (this.rawDimensions().remove(child)) {
            return true;
        }
        if (this.initializer == child) {
            this.disown((AbstractNode)child);
            this.initializer = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitArrayCreation(this)) {
            return;
        }
        if (this.componentTypeReference != null) {
            this.componentTypeReference.accept(visitor);
        }
        for (AbstractNode child : this.dimensions.asIterable()) {
            child.accept(visitor);
        }
        if (this.initializer != null) {
            this.initializer.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public ArrayCreation copy() {
        ArrayCreation result = new ArrayCreation();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        if (this.componentTypeReference != null) {
            result.rawComponentTypeReference(this.componentTypeReference.copy());
        }
        for (AbstractNode n : this.dimensions.backingList()) {
            result.rawDimensions().addToEnd(n == null ? null : n.copy());
        }
        if (this.initializer != null) {
            result.rawInitializer(this.initializer.copy());
        }
        return result;
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean needsParentheses() {
        return ExpressionMixin.needsParentheses(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

