/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.internal.CommandLineRunner;
import com.android.ide.common.internal.LoggedErrorException;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class AaptRunner {
    private final String mAaptLocation;
    private final CommandLineRunner mCommandLineRunner;

    public AaptRunner(@NonNull String aaptLocation, @NonNull CommandLineRunner commandLineRunner) {
        this.mAaptLocation = aaptLocation;
        this.mCommandLineRunner = commandLineRunner;
    }

    public void crunchPng(File from, File to) throws InterruptedException, LoggedErrorException, IOException {
        this.crunchPng(from, to, null);
    }

    public void crunchPng(File from, File to, @Nullable Map<String, String> envVariableMap) throws IOException, InterruptedException, LoggedErrorException {
        String[] command = new String[]{this.mAaptLocation, "s", "-i", from.getAbsolutePath(), "-o", to.getAbsolutePath()};
        this.mCommandLineRunner.runCmdLine(command, envVariableMap);
    }
}

