#!/bin/sh

if [ "$PWD" = "" ]; then
	echo "ERROR: the shell does not sets PWD variable"
	exit 1
fi

make clean
rm -vfR ./dist/ ./CMakeFiles/

TOPDIR=`dirname $PWD`
BASEDIR=`basename $PWD`
VERSION=1.4.5
SUBVERSION=
BASETAR="${BASEDIR}-${VERSION}${SUBVERSION}.tar"

echo "> tarball from $TOPDIR for $BASEDIR ..."
cd "$TOPDIR/"
tar -v -f "./$BASETAR" --exclude-from="${BASEDIR}/tarball.list" -c "./${BASEDIR}/"
bzip2 -fv9 "$BASETAR"

echo "- tarball $BASETAR.bz2 complete."
