/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.DeodexUtil;
import org.jf.dexlib.Code.Analysis.Deodexerant;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.OdexDependencies;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.SparseArray;

public class ClassPath {
    private static ClassPath theClassPath = null;
    private final HashMap<String, ClassDef> classDefs = new HashMap();
    protected ClassDef javaLangObjectClassDef;
    private LinkedHashMap<String, TempClassInfo> tempClasses;
    private static final Pattern dalvikCacheOdexPattern = Pattern.compile("@([^@]+)@classes.dex$");
    private static final String arrayPrefix = "[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[";

    public static void InitializeClassPathFromOdex(String[] classPathDirs, String[] extraBootClassPathEntries, String dexFilePath, DexFile dexFile, ClassPathErrorHandler errorHandler) {
        if (!dexFile.isOdex()) {
            throw new ExceptionWithContext("Cannot use InitialiazeClassPathFromOdex with a non-odex DexFile");
        }
        if (theClassPath != null) {
            throw new ExceptionWithContext("Cannot initialize ClassPath multiple times");
        }
        OdexDependencies odexDependencies = dexFile.getOdexDependencies();
        String[] bootClassPath = new String[odexDependencies.getDependencyCount()];
        for (int i = 0; i < bootClassPath.length; ++i) {
            String dependency = odexDependencies.getDependency(i);
            if (dependency.endsWith(".odex")) {
                int slashIndex = dependency.lastIndexOf("/");
                if (slashIndex != -1) {
                    dependency = dependency.substring(slashIndex + 1);
                }
            } else if (dependency.endsWith("@classes.dex")) {
                Matcher m = dalvikCacheOdexPattern.matcher(dependency);
                if (!m.find()) {
                    throw new ExceptionWithContext(String.format("Cannot parse dependency value %s", dependency));
                }
                dependency = m.group(1);
            } else {
                throw new ExceptionWithContext(String.format("Cannot parse dependency value %s", dependency));
            }
            bootClassPath[i] = dependency;
        }
        theClassPath = new ClassPath();
        theClassPath.initClassPath(classPathDirs, bootClassPath, extraBootClassPathEntries, dexFilePath, dexFile, errorHandler);
    }

    public static void InitializeClassPath(String[] classPathDirs, String[] bootClassPath, String[] extraBootClassPathEntries, String dexFilePath, DexFile dexFile, ClassPathErrorHandler errorHandler) {
        if (theClassPath != null) {
            throw new ExceptionWithContext("Cannot initialize ClassPath multiple times");
        }
        theClassPath = new ClassPath();
        theClassPath.initClassPath(classPathDirs, bootClassPath, extraBootClassPathEntries, dexFilePath, dexFile, errorHandler);
    }

    private ClassPath() {
    }

    private void initClassPath(String[] classPathDirs, String[] bootClassPath, String[] extraBootClassPathEntries, String dexFilePath, DexFile dexFile, ClassPathErrorHandler errorHandler) {
        this.tempClasses = new LinkedHashMap();
        if (bootClassPath != null) {
            for (String bootClassPathEntry : bootClassPath) {
                this.loadBootClassPath(classPathDirs, bootClassPathEntry);
            }
        }
        if (extraBootClassPathEntries != null) {
            for (String bootClassPathEntry : extraBootClassPathEntries) {
                this.loadBootClassPath(classPathDirs, bootClassPathEntry);
            }
        }
        if (dexFile != null) {
            this.loadDexFile(dexFilePath, dexFile);
        }
        for (String classType : this.tempClasses.keySet()) {
            ClassDef classDef = null;
            try {
                classDef = ClassPath.loadClassDef(classType);
                assert (classDef != null);
            }
            catch (Exception ex) {
                if (errorHandler != null) {
                    errorHandler.ClassPathError(classType, ex);
                }
                throw ExceptionWithContext.withContext(ex, String.format("Error while loading ClassPath class %s", classType));
            }
            if (!classType.equals("Ljava/lang/Object;")) continue;
            this.javaLangObjectClassDef = classDef;
        }
        for (String primitiveType : new String[]{"Z", "B", "S", "C", "I", "J", "F", "D"}) {
            PrimitiveClassDef classDef = new PrimitiveClassDef(primitiveType);
            this.classDefs.put(primitiveType, classDef);
        }
        this.tempClasses = null;
    }

    private void loadBootClassPath(String[] classPathDirs, String bootClassPathEntry) {
        for (String classPathDir : classPathDirs) {
            File file = null;
            DexFile dexFile = null;
            int extIndex = bootClassPathEntry.lastIndexOf(".");
            String baseEntry = extIndex == -1 ? bootClassPathEntry : bootClassPathEntry.substring(0, extIndex);
            for (String ext : new String[]{"", ".odex", ".jar", ".apk", ".zip"}) {
                file = ext.length() == 0 ? new File(classPathDir, bootClassPathEntry) : new File(classPathDir, baseEntry + ext);
                if (!file.exists()) continue;
                if (!file.canRead()) {
                    System.err.println(String.format("warning: cannot open %s for reading. Will continue looking.", file.getPath()));
                    continue;
                }
                try {
                    dexFile = new DexFile(file, false, true);
                }
                catch (DexFile.NoClassesDexException ex) {
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error while reading boot class path entry \"" + bootClassPathEntry + "\".");
                }
            }
            if (dexFile == null) continue;
            try {
                this.loadDexFile(file.getPath(), dexFile);
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, String.format("Error while loading boot classpath entry %s", bootClassPathEntry));
            }
            return;
        }
        throw new ExceptionWithContext(String.format("Cannot locate boot class path file %s", bootClassPathEntry));
    }

    private void loadDexFile(String dexFilePath, DexFile dexFile) {
        for (ClassDefItem classDefItem : dexFile.ClassDefsSection.getItems()) {
            try {
                TempClassInfo tempClassInfo = new TempClassInfo(dexFilePath, classDefItem);
                this.tempClasses.put(tempClassInfo.classType, tempClassInfo);
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, String.format("Error while loading class %s", classDefItem.getClassType().getTypeDescriptor()));
            }
        }
    }

    public static ClassDef getClassDef(String classType) {
        return ClassPath.getClassDef(classType, true);
    }

    private static ClassDef loadClassDef(String classType) {
        ClassDef classDef = ClassPath.getClassDef(classType, false);
        if (classDef == null) {
            TempClassInfo classInfo = ClassPath.theClassPath.tempClasses.get(classType);
            if (classInfo == null) {
                return null;
            }
            try {
                classDef = new ClassDef(classInfo);
                ClassPath.theClassPath.classDefs.put(classDef.classType, classDef);
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, String.format("Error while loading class %s from file %s", classInfo.classType, classInfo.dexFilePath));
            }
        }
        return classDef;
    }

    public static ClassDef getClassDef(String classType, boolean createUnresolvedClassDef) {
        ClassDef classDef = ClassPath.theClassPath.classDefs.get(classType);
        if (classDef == null) {
            if (classType.charAt(0) == '[') {
                return theClassPath.createArrayClassDef(classType);
            }
            if (createUnresolvedClassDef) {
                return theClassPath.createUnresolvedClassDef(classType);
            }
            return null;
        }
        return classDef;
    }

    public static ClassDef getClassDef(TypeIdItem classType) {
        return ClassPath.getClassDef(classType.getTypeDescriptor());
    }

    public static ClassDef getClassDef(TypeIdItem classType, boolean creatUnresolvedClassDef) {
        return ClassPath.getClassDef(classType.getTypeDescriptor(), creatUnresolvedClassDef);
    }

    private static ClassDef getArrayClassDefByElementClassAndDimension(ClassDef classDef, int arrayDimension) {
        return ClassPath.getClassDef(arrayPrefix.substring(256 - arrayDimension) + classDef.classType);
    }

    private ClassDef createUnresolvedClassDef(String classType) {
        assert (classType.charAt(0) == 'L');
        UnresolvedClassDef unresolvedClassDef = new UnresolvedClassDef(classType);
        this.classDefs.put(classType, unresolvedClassDef);
        return unresolvedClassDef;
    }

    private ClassDef createArrayClassDef(String arrayClassName) {
        assert (arrayClassName != null);
        assert (arrayClassName.charAt(0) == '[');
        ArrayClassDef arrayClassDef = new ArrayClassDef(arrayClassName);
        if (arrayClassDef.elementClass == null) {
            return null;
        }
        this.classDefs.put(arrayClassName, arrayClassDef);
        return arrayClassDef;
    }

    public static ClassDef getCommonSuperclass(ClassDef class1, ClassDef class2) {
        int class1Depth;
        if (class1 == class2) {
            return class1;
        }
        if (class1 == null) {
            return class2;
        }
        if (class2 == null) {
            return class1;
        }
        if (class2.isInterface) {
            if (class1.implementsInterface(class2)) {
                return class2;
            }
            return ClassPath.theClassPath.javaLangObjectClassDef;
        }
        if (class1.isInterface) {
            if (class2.implementsInterface(class1)) {
                return class1;
            }
            return ClassPath.theClassPath.javaLangObjectClassDef;
        }
        if (class1 instanceof ArrayClassDef && class2 instanceof ArrayClassDef) {
            return ClassPath.getCommonArraySuperclass((ArrayClassDef)class1, (ArrayClassDef)class2);
        }
        int class2Depth = class2.getClassDepth();
        for (class1Depth = class1.getClassDepth(); class1Depth > class2Depth; --class1Depth) {
            class1 = class1.superclass;
        }
        while (class2Depth > class1Depth) {
            class2 = class2.superclass;
            --class2Depth;
        }
        while (class1Depth > 0) {
            if (class1 == class2) {
                return class1;
            }
            class1 = class1.superclass;
            --class1Depth;
            class2 = class2.superclass;
            --class2Depth;
        }
        return class1;
    }

    private static ClassDef getCommonArraySuperclass(ArrayClassDef class1, ArrayClassDef class2) {
        assert (class1 != class2);
        if (class1.elementClass instanceof PrimitiveClassDef || class2.elementClass instanceof PrimitiveClassDef) {
            return ClassPath.theClassPath.javaLangObjectClassDef;
        }
        if (class1.arrayDimensions == class2.arrayDimensions) {
            ClassDef commonElementClass = ClassPath.getCommonSuperclass(class1.elementClass, class2.elementClass);
            return ClassPath.getArrayClassDefByElementClassAndDimension(commonElementClass, class1.arrayDimensions);
        }
        int dimensions = Math.min(class1.arrayDimensions, class2.arrayDimensions);
        return ClassPath.getArrayClassDefByElementClassAndDimension(ClassPath.theClassPath.javaLangObjectClassDef, dimensions);
    }

    public static void validateAgainstDeodexerant(String host, int port, int skipClasses) {
        Deodexerant deodexerant = new Deodexerant(host, port);
        int count = 0;
        try {
            String[] inlineMethods = deodexerant.getInlineMethods();
            new DeodexUtil(null).checkInlineMethods(inlineMethods);
        }
        catch (Exception ex) {
            throw ExceptionWithContext.withContext(ex, "Error while checking inline methods");
        }
        try {
            for (ClassDef classDef : ClassPath.theClassPath.classDefs.values()) {
                if (count < skipClasses) {
                    ++count;
                    continue;
                }
                if (count % 1000 == 0) {
                    System.out.println(count);
                }
                if (classDef instanceof UnresolvedClassDef || classDef instanceof ArrayClassDef || classDef instanceof PrimitiveClassDef) continue;
                String[] vtable = deodexerant.getVirtualMethods(classDef.classType);
                if (vtable.length != classDef.vtable.length) {
                    throw new ValidationException(String.format("virtual table size mismatch for class %s", classDef.classType));
                }
                for (int i = 0; i < classDef.vtable.length; ++i) {
                    if (classDef.vtable[i].equals(vtable[i])) continue;
                    throw new ValidationException(String.format("virtual method mismatch for class %s at index %d", classDef.classType, i));
                }
                String[] fields = deodexerant.getInstanceFields(classDef.classType);
                if (fields.length != classDef.instanceFields.size()) {
                    throw new ValidationException(String.format("field count mismatch for class %s", classDef.classType));
                }
                for (int i = 0; i < classDef.instanceFields.size(); ++i) {
                    String[] fieldValues = fields[i].split(" ");
                    if (fieldValues.length != 2) {
                        throw new ValidationException("Could not parse field");
                    }
                    int fieldOffset = Integer.parseInt(fieldValues[0]);
                    String field = (String)classDef.instanceFields.get(fieldOffset);
                    if (field == null) {
                        throw new ValidationException("Could not find a field at the given offset");
                    }
                    if (field.equals(fieldValues[1])) continue;
                    throw new ValidationException(String.format("field offset mismatch for class %s at index %d", classDef.classType, i));
                }
                ++count;
            }
        }
        catch (Exception ex) {
            throw ExceptionWithContext.withContext(ex, String.format("Error while checking class #%d", count));
        }
    }

    private static class TempClassInfo {
        public final String dexFilePath;
        public final String classType;
        public final boolean isInterface;
        public final String superclassType;
        public final String[] interfaces;
        public final String[] virtualMethods;
        public final String[][] instanceFields;

        public TempClassInfo(String dexFilePath, ClassDefItem classDefItem) {
            this.dexFilePath = dexFilePath;
            this.classType = classDefItem.getClassType().getTypeDescriptor();
            this.isInterface = (classDefItem.getAccessFlags() & AccessFlags.INTERFACE.getValue()) != 0;
            TypeIdItem superclassType = classDefItem.getSuperclass();
            this.superclassType = superclassType == null ? null : superclassType.getTypeDescriptor();
            this.interfaces = this.loadInterfaces(classDefItem);
            ClassDataItem classDataItem = classDefItem.getClassData();
            if (classDataItem != null) {
                this.virtualMethods = this.loadVirtualMethods(classDataItem);
                this.instanceFields = this.loadInstanceFields(classDataItem);
            } else {
                this.virtualMethods = null;
                this.instanceFields = null;
            }
        }

        private String[] loadInterfaces(ClassDefItem classDefItem) {
            List<TypeIdItem> types;
            TypeListItem typeList = classDefItem.getInterfaces();
            if (typeList != null && (types = typeList.getTypes()) != null && types.size() > 0) {
                String[] interfaces = new String[types.size()];
                for (int i = 0; i < interfaces.length; ++i) {
                    interfaces[i] = types.get(i).getTypeDescriptor();
                }
                return interfaces;
            }
            return null;
        }

        private String[] loadVirtualMethods(ClassDataItem classDataItem) {
            ClassDataItem.EncodedMethod[] encodedMethods = classDataItem.getVirtualMethods();
            if (encodedMethods != null && encodedMethods.length > 0) {
                String[] virtualMethods = new String[encodedMethods.length];
                for (int i = 0; i < encodedMethods.length; ++i) {
                    virtualMethods[i] = encodedMethods[i].method.getVirtualMethodString();
                }
                return virtualMethods;
            }
            return null;
        }

        private String[][] loadInstanceFields(ClassDataItem classDataItem) {
            ClassDataItem.EncodedField[] encodedFields = classDataItem.getInstanceFields();
            if (encodedFields != null && encodedFields.length > 0) {
                String[][] instanceFields = new String[encodedFields.length][2];
                for (int i = 0; i < encodedFields.length; ++i) {
                    ClassDataItem.EncodedField encodedField = encodedFields[i];
                    instanceFields[i][0] = encodedField.field.getFieldName().getStringValue();
                    instanceFields[i][1] = encodedField.field.getFieldType().getTypeDescriptor();
                }
                return instanceFields;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassDef
    implements Comparable<ClassDef> {
        private final String classType;
        private final ClassDef superclass;
        private final TreeSet<ClassDef> implementedInterfaces;
        private final boolean isInterface;
        private final int classDepth;
        private final String[] vtable;
        private final HashMap<String, Integer> virtualMethodLookup;
        private final SparseArray<String> instanceFields;
        private final HashMap<String, Integer> instanceFieldLookup;
        public static final int ArrayClassDef = 0;
        public static final int PrimitiveClassDef = 1;
        public static final int UnresolvedClassDef = 2;
        private String[] virtualMethods;
        private LinkedHashMap<String, ClassDef> interfaceTable;

        protected ClassDef(String classType, int classFlavor) {
            if (classFlavor == 0) {
                assert (classType.charAt(0) == '[');
                this.classType = classType;
                this.superclass = theClassPath.javaLangObjectClassDef;
                this.implementedInterfaces = new TreeSet();
                this.implementedInterfaces.add(ClassPath.getClassDef("Ljava/lang/Cloneable;"));
                this.implementedInterfaces.add(ClassPath.getClassDef("Ljava/io/Serializable;"));
                this.isInterface = false;
                this.vtable = this.superclass.vtable;
                this.virtualMethodLookup = this.superclass.virtualMethodLookup;
                this.instanceFields = this.superclass.instanceFields;
                this.instanceFieldLookup = this.superclass.instanceFieldLookup;
                this.classDepth = 1;
                this.virtualMethods = null;
                this.interfaceTable = null;
            } else if (classFlavor == 1) {
                assert (classType.charAt(0) != '[' && classType.charAt(0) != 'L');
                this.classType = classType;
                this.superclass = null;
                this.implementedInterfaces = null;
                this.isInterface = false;
                this.vtable = null;
                this.virtualMethodLookup = null;
                this.instanceFields = null;
                this.instanceFieldLookup = null;
                this.classDepth = 0;
                this.virtualMethods = null;
                this.interfaceTable = null;
            } else {
                assert (classType.charAt(0) == 'L');
                this.classType = classType;
                this.superclass = theClassPath.javaLangObjectClassDef;
                this.implementedInterfaces = new TreeSet();
                this.isInterface = false;
                this.vtable = this.superclass.vtable;
                this.virtualMethodLookup = this.superclass.virtualMethodLookup;
                this.instanceFields = this.superclass.instanceFields;
                this.instanceFieldLookup = this.superclass.instanceFieldLookup;
                this.classDepth = 1;
                this.virtualMethods = null;
                this.interfaceTable = null;
            }
        }

        protected ClassDef(TempClassInfo classInfo) {
            int i;
            this.classType = classInfo.classType;
            this.isInterface = classInfo.isInterface;
            this.superclass = this.loadSuperclass(classInfo);
            this.classDepth = this.superclass == null ? 0 : this.superclass.classDepth + 1;
            this.implementedInterfaces = this.loadAllImplementedInterfaces(classInfo);
            this.interfaceTable = this.loadInterfaceTable(classInfo);
            this.virtualMethods = classInfo.virtualMethods;
            this.vtable = this.loadVtable(classInfo);
            this.virtualMethodLookup = new HashMap((int)Math.ceil((float)this.vtable.length / 0.7f), 0.75f);
            for (i = 0; i < this.vtable.length; ++i) {
                this.virtualMethodLookup.put(this.vtable[i], i);
            }
            this.instanceFields = this.loadFields(classInfo);
            this.instanceFieldLookup = new HashMap((int)Math.ceil((float)this.instanceFields.size() / 0.7f), 0.75f);
            for (i = 0; i < this.instanceFields.size(); ++i) {
                this.instanceFieldLookup.put(this.instanceFields.get(i), i);
            }
        }

        public String getClassType() {
            return this.classType;
        }

        public ClassDef getSuperclass() {
            return this.superclass;
        }

        public int getClassDepth() {
            return this.classDepth;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        public boolean extendsClass(ClassDef superclassDef) {
            if (superclassDef == null) {
                return false;
            }
            if (this == superclassDef) {
                return true;
            }
            if (superclassDef instanceof UnresolvedClassDef) {
                throw ((UnresolvedClassDef)superclassDef).unresolvedValidationException();
            }
            int superclassDepth = superclassDef.classDepth;
            ClassDef ancestor = this;
            while (ancestor.classDepth > superclassDepth) {
                ancestor = ancestor.getSuperclass();
            }
            return ancestor == superclassDef;
        }

        public boolean implementsInterface(ClassDef interfaceDef) {
            assert (!(interfaceDef instanceof UnresolvedClassDef));
            return this.implementedInterfaces.contains(interfaceDef);
        }

        public boolean hasVirtualMethod(String method) {
            return this.virtualMethodLookup.containsKey(method);
        }

        public String getInstanceField(int fieldOffset) {
            return this.instanceFields.get(fieldOffset, null);
        }

        public String getVirtualMethod(int vtableIndex) {
            if (vtableIndex < 0 || vtableIndex >= this.vtable.length) {
                return null;
            }
            return this.vtable[vtableIndex];
        }

        private void swap(byte[] fieldTypes, String[] fields, int position1, int position2) {
            byte tempType = fieldTypes[position1];
            fieldTypes[position1] = fieldTypes[position2];
            fieldTypes[position2] = tempType;
            String tempField = fields[position1];
            fields[position1] = fields[position2];
            fields[position2] = tempField;
        }

        private ClassDef loadSuperclass(TempClassInfo classInfo) {
            if (classInfo.classType.equals("Ljava/lang/Object;")) {
                if (classInfo.superclassType != null) {
                    throw new ExceptionWithContext("Invalid superclass " + classInfo.superclassType + " for Ljava/lang/Object;. " + "The Object class cannot have a superclass");
                }
                return null;
            }
            String superclassType = classInfo.superclassType;
            if (superclassType == null) {
                throw new ExceptionWithContext(classInfo.classType + " has no superclass");
            }
            ClassDef superclass = ClassPath.loadClassDef(superclassType);
            if (superclass == null) {
                throw new ClassNotFoundException(String.format("Could not find superclass %s", superclassType));
            }
            if (!this.isInterface && superclass.isInterface) {
                throw new ValidationException("Class " + this.classType + " has the interface " + superclass.classType + " as its superclass");
            }
            if (this.isInterface && !superclass.isInterface && superclass != theClassPath.javaLangObjectClassDef) {
                throw new ValidationException("Interface " + this.classType + " has the non-interface class " + superclass.classType + " as its superclass");
            }
            return superclass;
        }

        private TreeSet<ClassDef> loadAllImplementedInterfaces(TempClassInfo classInfo) {
            assert (this.classType != null);
            assert (this.classType.equals("Ljava/lang/Object;") || this.superclass != null);
            assert (classInfo != null);
            TreeSet<ClassDef> implementedInterfaceSet = new TreeSet<ClassDef>();
            if (this.superclass != null) {
                for (ClassDef interfaceDef : this.superclass.implementedInterfaces) {
                    implementedInterfaceSet.add(interfaceDef);
                }
            }
            if (classInfo.interfaces != null) {
                for (String interfaceType : classInfo.interfaces) {
                    ClassDef interfaceDef = ClassPath.loadClassDef(interfaceType);
                    if (interfaceDef == null) {
                        throw new ClassNotFoundException(String.format("Could not find interface %s", interfaceType));
                    }
                    assert (interfaceDef.isInterface());
                    implementedInterfaceSet.add(interfaceDef);
                    interfaceDef = interfaceDef.getSuperclass();
                    while (!interfaceDef.getClassType().equals("Ljava/lang/Object;")) {
                        assert (interfaceDef.isInterface());
                        implementedInterfaceSet.add(interfaceDef);
                        interfaceDef = interfaceDef.getSuperclass();
                    }
                }
            }
            return implementedInterfaceSet;
        }

        private LinkedHashMap<String, ClassDef> loadInterfaceTable(TempClassInfo classInfo) {
            if (classInfo.interfaces == null) {
                return null;
            }
            LinkedHashMap<String, ClassDef> interfaceTable = new LinkedHashMap<String, ClassDef>();
            for (String interfaceType : classInfo.interfaces) {
                if (interfaceTable.containsKey(interfaceType)) continue;
                ClassDef interfaceDef = ClassPath.loadClassDef(interfaceType);
                if (interfaceDef == null) {
                    throw new ClassNotFoundException(String.format("Could not find interface %s", interfaceType));
                }
                interfaceTable.put(interfaceType, interfaceDef);
                if (interfaceDef.interfaceTable == null) continue;
                for (ClassDef superInterface : interfaceDef.interfaceTable.values()) {
                    if (interfaceTable.containsKey(superInterface.classType)) continue;
                    interfaceTable.put(superInterface.classType, superInterface);
                }
            }
            return interfaceTable;
        }

        private String[] loadVtable(TempClassInfo classInfo) {
            LinkedList<String> virtualMethodList = new LinkedList<String>();
            HashMap<String, Integer> tempVirtualMethodLookup = new HashMap<String, Integer>();
            int methodIndex = 0;
            if (this.superclass != null) {
                for (String method : this.superclass.vtable) {
                    virtualMethodList.add(method);
                    tempVirtualMethodLookup.put(method, methodIndex++);
                }
                assert (this.superclass.instanceFields != null);
            }
            if (!this.isInterface) {
                if (classInfo.virtualMethods != null) {
                    for (String virtualMethod : classInfo.virtualMethods) {
                        if (tempVirtualMethodLookup.get(virtualMethod) != null) continue;
                        virtualMethodList.add(virtualMethod);
                        tempVirtualMethodLookup.put(virtualMethod, methodIndex++);
                    }
                }
                if (this.interfaceTable != null) {
                    for (ClassDef interfaceDef : this.interfaceTable.values()) {
                        if (interfaceDef.virtualMethods == null) continue;
                        for (String virtualMethod : interfaceDef.virtualMethods) {
                            if (tempVirtualMethodLookup.get(virtualMethod) != null) continue;
                            virtualMethodList.add(virtualMethod);
                            tempVirtualMethodLookup.put(virtualMethod, methodIndex++);
                        }
                    }
                }
            }
            String[] vtable = new String[virtualMethodList.size()];
            for (int i = 0; i < virtualMethodList.size(); ++i) {
                vtable[i] = (String)virtualMethodList.get(i);
            }
            return vtable;
        }

        private int getNextFieldOffset() {
            if (this.instanceFields == null || this.instanceFields.size() == 0) {
                return 8;
            }
            int lastItemIndex = this.instanceFields.size() - 1;
            int fieldOffset = this.instanceFields.keyAt(lastItemIndex);
            String lastField = this.instanceFields.valueAt(lastItemIndex);
            int fieldTypeIndex = lastField.indexOf(":") + 1;
            switch (lastField.charAt(fieldTypeIndex)) {
                case 'D': 
                case 'J': {
                    return fieldOffset + 8;
                }
            }
            return fieldOffset + 4;
        }

        private SparseArray<String> loadFields(TempClassInfo classInfo) {
            int fieldOffset;
            int front;
            boolean REFERENCE = false;
            boolean WIDE = true;
            int OTHER = 2;
            String[] fields = null;
            byte[] fieldTypes = null;
            if (classInfo.instanceFields != null) {
                fields = new String[classInfo.instanceFields.length];
                fieldTypes = new byte[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    String[] fieldInfo = classInfo.instanceFields[i];
                    String fieldName = fieldInfo[0];
                    String fieldType = fieldInfo[1];
                    String field = String.format("%s:%s", fieldName, fieldType);
                    fieldTypes[i] = this.getFieldType(fieldType);
                    fields[i] = field;
                }
            }
            if (fields == null) {
                fields = new String[]{};
                fieldTypes = new byte[]{};
            }
            int back = fields.length - 1;
            for (front = 0; front < fields.length; ++front) {
                if (fieldTypes[front] != 0) {
                    while (back > front) {
                        if (fieldTypes[back] == 0) {
                            this.swap(fieldTypes, fields, front, back--);
                            break;
                        }
                        --back;
                    }
                }
                if (fieldTypes[front] != 0) break;
            }
            int startFieldOffset = 8;
            if (this.superclass != null) {
                startFieldOffset = this.superclass.getNextFieldOffset();
            }
            int fieldIndexMod = startFieldOffset % 8 == 0 ? 0 : 1;
            if (front < fields.length && front % 2 != fieldIndexMod) {
                if (fieldTypes[front] == 1) {
                    for (back = fields.length - 1; back > front; --back) {
                        if (fieldTypes[back] != 2) continue;
                        this.swap(fieldTypes, fields, front++, back);
                        break;
                    }
                } else {
                    ++front;
                }
            }
            back = fields.length - 1;
            while (front < fields.length) {
                if (fieldTypes[front] != 1) {
                    while (back > front) {
                        if (fieldTypes[back] == 1) {
                            this.swap(fieldTypes, fields, front, back--);
                            break;
                        }
                        --back;
                    }
                }
                if (fieldTypes[front] != 1) break;
                ++front;
            }
            int superFieldCount = 0;
            if (this.superclass != null) {
                superFieldCount = this.superclass.instanceFields.size();
            }
            int totalFieldCount = superFieldCount + fields.length;
            SparseArray<String> instanceFields = new SparseArray<String>(totalFieldCount);
            if (this.superclass != null && superFieldCount > 0) {
                for (int i = 0; i < superFieldCount; ++i) {
                    instanceFields.append(this.superclass.instanceFields.keyAt(i), this.superclass.instanceFields.valueAt(i));
                }
                fieldOffset = instanceFields.keyAt(superFieldCount - 1);
                String lastSuperField = this.superclass.instanceFields.valueAt(superFieldCount - 1);
                assert (lastSuperField.indexOf(58) >= 0);
                assert (lastSuperField.indexOf(58) < lastSuperField.length() - 1);
                char fieldType = lastSuperField.charAt(lastSuperField.indexOf(58) + 1);
                fieldOffset = fieldType == 'J' || fieldType == 'D' ? (fieldOffset += 8) : (fieldOffset += 4);
            } else {
                fieldOffset = 8;
            }
            boolean gotDouble = false;
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                if (fieldTypes[i] == 1 && !gotDouble && !gotDouble) {
                    if (fieldOffset % 8 != 0) {
                        assert (fieldOffset % 8 == 4);
                        fieldOffset += 4;
                    }
                    gotDouble = true;
                }
                instanceFields.append(fieldOffset, field);
                if (fieldTypes[i] == 1) {
                    fieldOffset += 8;
                    continue;
                }
                fieldOffset += 4;
            }
            return instanceFields;
        }

        private byte getFieldType(String fieldType) {
            switch (fieldType.charAt(0)) {
                case 'L': 
                case '[': {
                    return 0;
                }
                case 'D': 
                case 'J': {
                    return 1;
                }
            }
            return 2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassDef)) {
                return false;
            }
            ClassDef classDef = (ClassDef)o;
            return this.classType.equals(classDef.classType);
        }

        public int hashCode() {
            return this.classType.hashCode();
        }

        @Override
        public int compareTo(ClassDef classDef) {
            return this.classType.compareTo(classDef.classType);
        }
    }

    public static class UnresolvedClassDef
    extends ClassDef {
        protected UnresolvedClassDef(String unresolvedClassDef) {
            super(unresolvedClassDef, 2);
            assert (unresolvedClassDef.charAt(0) == 'L');
        }

        protected ValidationException unresolvedValidationException() {
            return new ValidationException(String.format("class %s cannot be resolved.", this.getClassType()));
        }

        public ClassDef getSuperclass() {
            throw this.unresolvedValidationException();
        }

        public int getClassDepth() {
            throw this.unresolvedValidationException();
        }

        public boolean isInterface() {
            throw this.unresolvedValidationException();
        }

        public boolean extendsClass(ClassDef superclassDef) {
            if (superclassDef != theClassPath.javaLangObjectClassDef && superclassDef != this) {
                throw this.unresolvedValidationException();
            }
            return true;
        }

        public boolean implementsInterface(ClassDef interfaceDef) {
            throw this.unresolvedValidationException();
        }

        public boolean hasVirtualMethod(String method) {
            if (!super.hasVirtualMethod(method)) {
                throw this.unresolvedValidationException();
            }
            return true;
        }
    }

    public static class PrimitiveClassDef
    extends ClassDef {
        protected PrimitiveClassDef(String primitiveClassType) {
            super(primitiveClassType, 1);
            assert (primitiveClassType.charAt(0) != 'L' && primitiveClassType.charAt(0) != '[');
        }
    }

    public static class ArrayClassDef
    extends ClassDef {
        private final ClassDef elementClass;
        private final int arrayDimensions;

        protected ArrayClassDef(String arrayClassType) {
            super(arrayClassType, 0);
            assert (arrayClassType.charAt(0) == '[');
            int i = 0;
            while (arrayClassType.charAt(i) == '[') {
                ++i;
            }
            String elementClassType = arrayClassType.substring(i);
            if (i > 256) {
                throw new ExceptionWithContext("Error while creating array class for element type " + elementClassType + " with " + i + " dimensions. The maximum number of dimensions is 256");
            }
            try {
                this.elementClass = ClassPath.getClassDef(arrayClassType.substring(i));
            }
            catch (ClassNotFoundException ex) {
                throw ExceptionWithContext.withContext(ex, "Error while creating array class " + arrayClassType);
            }
            this.arrayDimensions = i;
        }

        public ClassDef getBaseElementClass() {
            return this.elementClass;
        }

        public ClassDef getImmediateElementClass() {
            if (this.arrayDimensions == 1) {
                return this.elementClass;
            }
            return ClassPath.getArrayClassDefByElementClassAndDimension(this.elementClass, this.arrayDimensions - 1);
        }

        public int getArrayDimensions() {
            return this.arrayDimensions;
        }

        public boolean extendsClass(ClassDef superclassDef) {
            if (!(superclassDef instanceof ArrayClassDef)) {
                if (superclassDef == theClassPath.javaLangObjectClassDef) {
                    return true;
                }
                if (superclassDef.isInterface) {
                    return this.implementsInterface(superclassDef);
                }
                return false;
            }
            ArrayClassDef arraySuperclassDef = (ArrayClassDef)superclassDef;
            if (this.arrayDimensions == arraySuperclassDef.arrayDimensions) {
                ClassDef baseElementClass = arraySuperclassDef.getBaseElementClass();
                if (baseElementClass.isInterface) {
                    return true;
                }
                return baseElementClass.extendsClass(arraySuperclassDef.getBaseElementClass());
            }
            if (this.arrayDimensions > arraySuperclassDef.arrayDimensions) {
                ClassDef baseElementClass = arraySuperclassDef.getBaseElementClass();
                if (baseElementClass.isInterface) {
                    return true;
                }
                return baseElementClass == theClassPath.javaLangObjectClassDef;
            }
            return false;
        }
    }

    private static class ClassNotFoundException
    extends ExceptionWithContext {
        public ClassNotFoundException(String message) {
            super(message);
        }
    }

    public static interface ClassPathErrorHandler {
        public void ClassPathError(String var1, Exception var2);
    }
}

