/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.CodeItem;
import org.jf.util.IndentingWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffsetInstructionFormatMethodItem<T extends Instruction>
extends InstructionMethodItem<T> {
    protected LabelMethodItem label;

    public OffsetInstructionFormatMethodItem(MethodDefinition.LabelCache labelCache, CodeItem codeItem, int codeAddress, T instruction) {
        super(codeItem, codeAddress, instruction);
        this.label = new LabelMethodItem(codeAddress + ((OffsetInstruction)instruction).getTargetAddressOffset(), this.getLabelPrefix());
        this.label = labelCache.internLabel(this.label);
    }

    @Override
    protected void writeTargetLabel(IndentingWriter writer) throws IOException {
        this.label.writeTo(writer);
    }

    public LabelMethodItem getLabel() {
        return this.label;
    }

    private String getLabelPrefix() {
        switch (this.instruction.getFormat()) {
            case Format10t: 
            case Format20t: 
            case Format30t: {
                return "goto_";
            }
            case Format21t: 
            case Format22t: {
                return "cond_";
            }
            case Format31t: {
                if (this.instruction.opcode == Opcode.FILL_ARRAY_DATA) {
                    return "array_";
                }
                if (this.instruction.opcode == Opcode.PACKED_SWITCH) {
                    return "pswitch_data_";
                }
                assert (this.instruction.opcode == Opcode.SPARSE_SWITCH);
                return "sswitch_data_";
            }
        }
        assert (false);
        return null;
    }
}

