/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.DominatorTree;
import llvm.Instruction;
import llvm.Twine;
import llvm.Type;
import llvm.Use;
import llvm.Value;
import llvm.llvmJNI;

public class PHINode
extends Instruction {
    private long swigCPtr;

    protected PHINode(long l2, boolean bl2) {
        super(llvmJNI.SWIGPHINodeUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(PHINode pHINode) {
        return pHINode == null ? 0L : pHINode.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_PHINode(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static PHINode Create(Type type, Twine twine, Instruction instruction) {
        long l2 = llvmJNI.PHINode_Create__SWIG_0(Type.getCPtr(type), type, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l2 == 0L ? null : new PHINode(l2, false);
    }

    public static PHINode Create(Type type, Twine twine) {
        long l2 = llvmJNI.PHINode_Create__SWIG_1(Type.getCPtr(type), type, Twine.getCPtr(twine), twine);
        return l2 == 0L ? null : new PHINode(l2, false);
    }

    public static PHINode Create(Type type) {
        long l2 = llvmJNI.PHINode_Create__SWIG_2(Type.getCPtr(type), type);
        return l2 == 0L ? null : new PHINode(l2, false);
    }

    public static PHINode Create(Type type, Twine twine, BasicBlock basicBlock) {
        long l2 = llvmJNI.PHINode_Create__SWIG_3(Type.getCPtr(type), type, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l2 == 0L ? null : new PHINode(l2, false);
    }

    public void reserveOperandSpace(long l2) {
        llvmJNI.PHINode_reserveOperandSpace(this.swigCPtr, this, l2);
    }

    public Value getOperand(long l2) {
        long l3 = llvmJNI.PHINode_getOperand(this.swigCPtr, this, l2);
        return l3 == 0L ? null : new Value(l3, false);
    }

    public void setOperand(long l2, Value value) {
        llvmJNI.PHINode_setOperand(this.swigCPtr, this, l2, Value.getCPtr(value), value);
    }

    public Use op_begin() {
        long l2 = llvmJNI.PHINode_op_begin__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Use(l2, false);
    }

    public Use op_end() {
        long l2 = llvmJNI.PHINode_op_end__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Use(l2, false);
    }

    public long getNumOperands() {
        return llvmJNI.PHINode_getNumOperands(this.swigCPtr, this);
    }

    public long getNumIncomingValues() {
        return llvmJNI.PHINode_getNumIncomingValues(this.swigCPtr, this);
    }

    public Value getIncomingValue(long l2) {
        long l3 = llvmJNI.PHINode_getIncomingValue(this.swigCPtr, this, l2);
        return l3 == 0L ? null : new Value(l3, false);
    }

    public void setIncomingValue(long l2, Value value) {
        llvmJNI.PHINode_setIncomingValue(this.swigCPtr, this, l2, Value.getCPtr(value), value);
    }

    public static long getOperandNumForIncomingValue(long l2) {
        return llvmJNI.PHINode_getOperandNumForIncomingValue(l2);
    }

    public static long getIncomingValueNumForOperand(long l2) {
        return llvmJNI.PHINode_getIncomingValueNumForOperand(l2);
    }

    public BasicBlock getIncomingBlock(long l2) {
        long l3 = llvmJNI.PHINode_getIncomingBlock__SWIG_0(this.swigCPtr, this, l2);
        return l3 == 0L ? null : new BasicBlock(l3, false);
    }

    public BasicBlock getIncomingBlock(Use use) {
        long l2 = llvmJNI.PHINode_getIncomingBlock__SWIG_1(this.swigCPtr, this, Use.getCPtr(use), use);
        return l2 == 0L ? null : new BasicBlock(l2, false);
    }

    public void setIncomingBlock(long l2, BasicBlock basicBlock) {
        llvmJNI.PHINode_setIncomingBlock(this.swigCPtr, this, l2, BasicBlock.getCPtr(basicBlock), basicBlock);
    }

    public static long getOperandNumForIncomingBlock(long l2) {
        return llvmJNI.PHINode_getOperandNumForIncomingBlock(l2);
    }

    public static long getIncomingBlockNumForOperand(long l2) {
        return llvmJNI.PHINode_getIncomingBlockNumForOperand(l2);
    }

    public void addIncoming(Value value, BasicBlock basicBlock) {
        llvmJNI.PHINode_addIncoming(this.swigCPtr, this, Value.getCPtr(value), value, BasicBlock.getCPtr(basicBlock), basicBlock);
    }

    public Value removeIncomingValue(long l2, boolean bl2) {
        long l3 = llvmJNI.PHINode_removeIncomingValue__SWIG_0(this.swigCPtr, this, l2, bl2);
        return l3 == 0L ? null : new Value(l3, false);
    }

    public Value removeIncomingValue(long l2) {
        long l3 = llvmJNI.PHINode_removeIncomingValue__SWIG_1(this.swigCPtr, this, l2);
        return l3 == 0L ? null : new Value(l3, false);
    }

    public Value removeIncomingValue(BasicBlock basicBlock, boolean bl2) {
        long l2 = llvmJNI.PHINode_removeIncomingValue__SWIG_2(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock, bl2);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value removeIncomingValue(BasicBlock basicBlock) {
        long l2 = llvmJNI.PHINode_removeIncomingValue__SWIG_3(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public int getBasicBlockIndex(BasicBlock basicBlock) {
        return llvmJNI.PHINode_getBasicBlockIndex(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock);
    }

    public Value getIncomingValueForBlock(BasicBlock basicBlock) {
        long l2 = llvmJNI.PHINode_getIncomingValueForBlock(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value hasConstantValue(DominatorTree dominatorTree) {
        long l2 = llvmJNI.PHINode_hasConstantValue__SWIG_0(this.swigCPtr, this, DominatorTree.getCPtr(dominatorTree), dominatorTree);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value hasConstantValue() {
        long l2 = llvmJNI.PHINode_hasConstantValue__SWIG_1(this.swigCPtr, this);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public static boolean classof(PHINode pHINode) {
        return llvmJNI.PHINode_classof__SWIG_0(PHINode.getCPtr(pHINode), pHINode);
    }

    public static boolean classof(Instruction instruction) {
        return llvmJNI.PHINode_classof__SWIG_1(Instruction.getCPtr(instruction), instruction);
    }

    public static boolean classof(Value value) {
        return llvmJNI.PHINode_classof__SWIG_2(Value.getCPtr(value), value);
    }

    public static PHINode dyn_cast(Instruction instruction) {
        long l2 = llvmJNI.PHINode_dyn_cast(Instruction.getCPtr(instruction), instruction);
        return l2 == 0L ? null : new PHINode(l2, false);
    }
}

