/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import java.math.BigInteger;
import llvm.APInt;
import llvm.Constant;
import llvm.IntegerType;
import llvm.LLVMContext;
import llvm.StringRef;
import llvm.Type;
import llvm.Value;
import llvm.llvmJNI;

public class ConstantInt
extends Constant {
    private long swigCPtr;

    protected ConstantInt(long l2, boolean bl2) {
        super(llvmJNI.SWIGConstantIntUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(ConstantInt constantInt) {
        return constantInt == null ? 0L : constantInt.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_ConstantInt(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static ConstantInt getTrue(LLVMContext lLVMContext) {
        long l2 = llvmJNI.ConstantInt_getTrue(LLVMContext.getCPtr(lLVMContext), lLVMContext);
        return l2 == 0L ? null : new ConstantInt(l2, false);
    }

    public static ConstantInt getFalse(LLVMContext lLVMContext) {
        long l2 = llvmJNI.ConstantInt_getFalse(LLVMContext.getCPtr(lLVMContext), lLVMContext);
        return l2 == 0L ? null : new ConstantInt(l2, false);
    }

    public static Constant get(Type type, BigInteger bigInteger, boolean bl2) {
        long l2 = llvmJNI.ConstantInt_get__SWIG_0(Type.getCPtr(type), type, bigInteger, bl2);
        return l2 == 0L ? null : new Constant(l2, false);
    }

    public static Constant get(Type type, BigInteger bigInteger) {
        long l2 = llvmJNI.ConstantInt_get__SWIG_1(Type.getCPtr(type), type, bigInteger);
        return l2 == 0L ? null : new Constant(l2, false);
    }

    public static ConstantInt get(IntegerType integerType, BigInteger bigInteger, boolean bl2) {
        long l2 = llvmJNI.ConstantInt_get__SWIG_2(IntegerType.getCPtr(integerType), integerType, bigInteger, bl2);
        return l2 == 0L ? null : new ConstantInt(l2, false);
    }

    public static ConstantInt get(IntegerType integerType, BigInteger bigInteger) {
        long l2 = llvmJNI.ConstantInt_get__SWIG_3(IntegerType.getCPtr(integerType), integerType, bigInteger);
        return l2 == 0L ? null : new ConstantInt(l2, false);
    }

    public static ConstantInt getSigned(IntegerType integerType, long l2) {
        long l3 = llvmJNI.ConstantInt_getSigned__SWIG_0(IntegerType.getCPtr(integerType), integerType, l2);
        return l3 == 0L ? null : new ConstantInt(l3, false);
    }

    public static Constant getSigned(Type type, long l2) {
        long l3 = llvmJNI.ConstantInt_getSigned__SWIG_1(Type.getCPtr(type), type, l2);
        return l3 == 0L ? null : new Constant(l3, false);
    }

    public static ConstantInt get(LLVMContext lLVMContext, APInt aPInt) {
        long l2 = llvmJNI.ConstantInt_get__SWIG_4(LLVMContext.getCPtr(lLVMContext), lLVMContext, APInt.getCPtr(aPInt), aPInt);
        return l2 == 0L ? null : new ConstantInt(l2, false);
    }

    public static ConstantInt get(IntegerType integerType, StringRef stringRef, short s2) {
        long l2 = llvmJNI.ConstantInt_get__SWIG_5(IntegerType.getCPtr(integerType), integerType, StringRef.getCPtr(stringRef), stringRef, s2);
        return l2 == 0L ? null : new ConstantInt(l2, false);
    }

    public static Constant get(Type type, APInt aPInt) {
        long l2 = llvmJNI.ConstantInt_get__SWIG_6(Type.getCPtr(type), type, APInt.getCPtr(aPInt), aPInt);
        return l2 == 0L ? null : new Constant(l2, false);
    }

    public APInt getValue() {
        return new APInt(llvmJNI.ConstantInt_getValue(this.swigCPtr, this), false);
    }

    public long getBitWidth() {
        return llvmJNI.ConstantInt_getBitWidth(this.swigCPtr, this);
    }

    public BigInteger getZExtValue() {
        return llvmJNI.ConstantInt_getZExtValue(this.swigCPtr, this);
    }

    public long getSExtValue() {
        return llvmJNI.ConstantInt_getSExtValue(this.swigCPtr, this);
    }

    public boolean equalsInt(BigInteger bigInteger) {
        return llvmJNI.ConstantInt_equalsInt(this.swigCPtr, this, bigInteger);
    }

    public IntegerType getType() {
        long l2 = llvmJNI.ConstantInt_getType(this.swigCPtr, this);
        return l2 == 0L ? null : new IntegerType(l2, false);
    }

    public static boolean isValueValidForType(Type type, BigInteger bigInteger) {
        return llvmJNI.ConstantInt_isValueValidForType__SWIG_0(Type.getCPtr(type), type, bigInteger);
    }

    public static boolean isValueValidForType(Type type, long l2) {
        return llvmJNI.ConstantInt_isValueValidForType__SWIG_1(Type.getCPtr(type), type, l2);
    }

    public boolean isNullValue() {
        return llvmJNI.ConstantInt_isNullValue(this.swigCPtr, this);
    }

    public boolean isZero() {
        return llvmJNI.ConstantInt_isZero(this.swigCPtr, this);
    }

    public boolean isOne() {
        return llvmJNI.ConstantInt_isOne(this.swigCPtr, this);
    }

    public boolean isAllOnesValue() {
        return llvmJNI.ConstantInt_isAllOnesValue(this.swigCPtr, this);
    }

    public boolean isMaxValue(boolean bl2) {
        return llvmJNI.ConstantInt_isMaxValue(this.swigCPtr, this, bl2);
    }

    public boolean isMinValue(boolean bl2) {
        return llvmJNI.ConstantInt_isMinValue(this.swigCPtr, this, bl2);
    }

    public boolean uge(BigInteger bigInteger) {
        return llvmJNI.ConstantInt_uge(this.swigCPtr, this, bigInteger);
    }

    public BigInteger getLimitedValue(BigInteger bigInteger) {
        return llvmJNI.ConstantInt_getLimitedValue__SWIG_0(this.swigCPtr, this, bigInteger);
    }

    public BigInteger getLimitedValue() {
        return llvmJNI.ConstantInt_getLimitedValue__SWIG_1(this.swigCPtr, this);
    }

    public static boolean classof(ConstantInt constantInt) {
        return llvmJNI.ConstantInt_classof__SWIG_0(ConstantInt.getCPtr(constantInt), constantInt);
    }

    public static boolean classof(Value value) {
        return llvmJNI.ConstantInt_classof__SWIG_1(Value.getCPtr(value), value);
    }

    public static ConstantInt dyn_cast(Constant constant) {
        long l2 = llvmJNI.ConstantInt_dyn_cast(Constant.getCPtr(constant), constant);
        return l2 == 0L ? null : new ConstantInt(l2, false);
    }
}

